/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassVisitor;

public class FullyQualifiedClassNameChecker
implements ClassVisitor {
    private static final String INVALID_CLASS_EXTENSION = ClassUtil.internalClassName((String)".class");
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;

    public FullyQualifiedClassNameChecker(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List classSpecifications) {
        if (classSpecifications != null) {
            for (int index = 0; index < classSpecifications.size(); ++index) {
                ClassSpecification classSpecification = (ClassSpecification)classSpecifications.get(index);
                this.checkType(classSpecification.annotationType);
                this.checkClassName(classSpecification.className);
                this.checkType(classSpecification.extendsAnnotationType);
                this.checkClassName(classSpecification.extendsClassName);
                this.checkMemberSpecifications(classSpecification.fieldSpecifications, true);
                this.checkMemberSpecifications(classSpecification.methodSpecifications, false);
            }
        }
    }

    private void checkMemberSpecifications(List memberSpecifications, boolean isField) {
        if (memberSpecifications != null) {
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                this.checkType(memberSpecification.annotationType);
                if (isField) {
                    this.checkType(memberSpecification.descriptor);
                    continue;
                }
                this.checkDescriptor(memberSpecification.descriptor);
            }
        }
    }

    private void checkDescriptor(String descriptor) {
        if (descriptor != null) {
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
            this.checkType(internalTypeEnumeration.returnType());
            while (internalTypeEnumeration.hasMoreTypes()) {
                this.checkType(internalTypeEnumeration.nextType());
            }
        }
    }

    private void checkType(String type) {
        if (type != null) {
            this.checkClassName(ClassUtil.internalClassNameFromType((String)type));
        }
    }

    private void checkClassName(String className) {
        if (className != null && !FullyQualifiedClassNameChecker.containsWildCards(className) && this.programClassPool.getClass(className) == null && this.libraryClassPool.getClass(className) == null && this.notePrinter.accepts(className)) {
            this.notePrinter.print(className, "Note: the configuration refers to the unknown class '" + ClassUtil.externalClassName((String)className) + "'");
            int lastSeparatorIndex = className.lastIndexOf(47);
            String fullyQualifiedClassName = className.endsWith(INVALID_CLASS_EXTENSION) ? className.substring(0, lastSeparatorIndex) : "**/" + className.substring(lastSeparatorIndex + 1);
            ClassNameFilter classNameFilter = new ClassNameFilter(fullyQualifiedClassName, (ClassVisitor)this);
            this.programClassPool.classesAccept((ClassVisitor)classNameFilter);
            this.libraryClassPool.classesAccept((ClassVisitor)classNameFilter);
        }
    }

    private static boolean containsWildCards(String string) {
        return string != null && (string.indexOf(33) >= 0 || string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(44) >= 0 || string.indexOf("///") >= 0 || string.indexOf(60) >= 0);
    }

    public void visitAnyClass(Clazz clazz) {
        System.out.println("      Maybe you meant the fully qualified name '" + ClassUtil.externalClassName((String)clazz.getName()) + "'?");
    }
}

