/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.reflect.visitor.CallableReferenceInfoToOwnerVisitor;
import proguard.classfile.kotlin.reflect.visitor.CallableReferenceInfoVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinDeclarationContainerFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.obfuscate.util.InstructionSequenceObfuscator;
import proguard.obfuscate.util.ReplacementSequences;
import proguard.resources.kotlinmodule.visitor.KotlinMetadataToModuleVisitor;

public class KotlinCallableReferenceFixer
implements KotlinMetadataVisitor {
    private ClassPool programClassPool;
    private ClassPool libraryClassPool;

    public KotlinCallableReferenceFixer(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
    }

    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata syntheticClass) {
        if (syntheticClass.callableReferenceInfo != null) {
            clazz.accept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new NamedMethodVisitor("getName", "()Ljava/lang/String;", (MemberVisitor)new InstructionSequenceObfuscator(new NameOrSignatureReplacementSequences(syntheticClass.callableReferenceInfo.getName(), this.programClassPool, this.libraryClassPool))), new NamedMethodVisitor("getSignature", "()Ljava/lang/String;", (MemberVisitor)new InstructionSequenceObfuscator(new NameOrSignatureReplacementSequences(syntheticClass.callableReferenceInfo.getSignature(), this.programClassPool, this.libraryClassPool)))}));
            syntheticClass.callableReferenceInfoAccept((CallableReferenceInfoVisitor)new CallableReferenceInfoToOwnerVisitor((KotlinMetadataVisitor)new KotlinDeclarationContainerFilter(declarationContainer -> declarationContainer.k == 2 || declarationContainer.k == 5, (KotlinMetadataVisitor)new KotlinMetadataToModuleVisitor(kotlinModule -> clazz.accept((ClassVisitor)new NamedMethodVisitor("getOwner", "()Lkotlin/reflect/KDeclarationContainer;", (MemberVisitor)new InstructionSequenceObfuscator(new OwnerReplacementSequences(kotlinModule.name, this.programClassPool, this.libraryClassPool))))))));
        }
    }

    public static final class OwnerReplacementSequences
    implements ReplacementSequences {
        private final Instruction[][][] SEQUENCES;
        private final Constant[] CONSTANTS;

        OwnerReplacementSequences(String name, ClassPool programClassPool, ClassPool libraryClassPool) {
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(programClassPool, libraryClassPool);
            this.SEQUENCES = new Instruction[][][]{{____.ldc_(0x40000000).ldc_(0x40000001).invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinPackage", "(Ljava/lang/Class;Ljava/lang/String;)Lkotlin/reflect/KDeclarationContainer;").areturn().__(), ____.ldc_(0x40000000).ldc(name).invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinPackage", "(Ljava/lang/Class;Ljava/lang/String;)Lkotlin/reflect/KDeclarationContainer;").areturn().__()}};
            this.CONSTANTS = ____.constants();
        }

        @Override
        public Instruction[][][] getSequences() {
            return this.SEQUENCES;
        }

        @Override
        public Constant[] getConstants() {
            return this.CONSTANTS;
        }
    }

    public static final class NameOrSignatureReplacementSequences
    implements ReplacementSequences {
        private final Instruction[][][] SEQUENCES;
        private final Constant[] CONSTANTS;

        NameOrSignatureReplacementSequences(String name, ClassPool programClassPool, ClassPool libraryClassPool) {
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(programClassPool, libraryClassPool);
            this.SEQUENCES = new Instruction[][][]{{____.ldc_(0x40000000).areturn().__(), ____.ldc(name).areturn().__()}};
            this.CONSTANTS = ____.constants();
        }

        @Override
        public Instruction[][][] getSequences() {
            return this.SEQUENCES;
        }

        @Override
        public Constant[] getConstants() {
            return this.CONSTANTS;
        }
    }
}

