/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.reflect.CallableReferenceInfo;
import proguard.classfile.kotlin.reflect.FunctionReferenceInfo;
import proguard.classfile.kotlin.reflect.LocalVariableReferenceInfo;
import proguard.classfile.kotlin.reflect.PropertyReferenceInfo;
import proguard.classfile.kotlin.reflect.visitor.CallableReferenceInfoVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.util.kotlin.asserter.AssertUtil;
import proguard.util.kotlin.asserter.constraint.AbstractKotlinMetadataConstraint;

public class SyntheticClassIntegrity
extends AbstractKotlinMetadataConstraint
implements KotlinMetadataVisitor {
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        final AssertUtil util = new AssertUtil("Synthetic class", this.reporter);
        switch (kotlinSyntheticClassKindMetadata.flavor) {
            case DEFAULT_IMPLS: {
                if (clazz.getName().endsWith("$DefaultImpls")) break;
                this.reporter.report("Default implementations class name does not end with $DefaultImpls");
                break;
            }
            case WHEN_MAPPINGS: {
                if (clazz.getName().endsWith("$WhenMappings")) break;
                this.reporter.report("When mappings class name does not end with $WhenMappings");
                break;
            }
            case LAMBDA: {
                try {
                    Integer.parseInt(clazz.getName().substring(clazz.getName().lastIndexOf("$") + 1));
                }
                catch (NumberFormatException e) {
                    this.reporter.report("Lambda inner classname is not an integer.");
                }
                if (kotlinSyntheticClassKindMetadata.functions.isEmpty()) {
                    this.reporter.report("Lambda class has no functions");
                    break;
                }
                if (kotlinSyntheticClassKindMetadata.functions.size() <= 1) break;
                this.reporter.report("Lambda class has multiple functions");
                break;
            }
        }
        if (clazz.extendsOrImplements("kotlin/jvm/internal/CallableReference")) {
            util.setParentElement("Synthetic callable reference class");
            util.reportIfNullReference("callable reference info", kotlinSyntheticClassKindMetadata.callableReferenceInfo);
            kotlinSyntheticClassKindMetadata.callableReferenceInfoAccept(new CallableReferenceInfoVisitor(){

                public void visitAnyCallableReferenceInfo(CallableReferenceInfo callableReferenceInfo) {
                    util.setParentElement("Synthetic callable reference (" + callableReferenceInfo.getClass().getSimpleName() + ")");
                    util.reportIfNull("name", callableReferenceInfo.getName());
                    util.reportIfNull("signature", callableReferenceInfo.getSignature());
                }

                public void visitFunctionReferenceInfo(FunctionReferenceInfo functionReferenceInfo) {
                    this.visitAnyCallableReferenceInfo((CallableReferenceInfo)functionReferenceInfo);
                    this.checkOwner((CallableReferenceInfo)functionReferenceInfo);
                }

                public void visitPropertyReferenceInfo(PropertyReferenceInfo propertyReferenceInfo) {
                    this.visitAnyCallableReferenceInfo((CallableReferenceInfo)propertyReferenceInfo);
                    this.checkOwner((CallableReferenceInfo)propertyReferenceInfo);
                }

                public void visitLocalVariableReferenceInfo(LocalVariableReferenceInfo localVariableReferenceInfo) {
                    this.visitAnyCallableReferenceInfo((CallableReferenceInfo)localVariableReferenceInfo);
                    this.checkOwner((CallableReferenceInfo)localVariableReferenceInfo);
                }

                private void checkOwner(CallableReferenceInfo callableReferenceInfo) {
                    util.reportIfNull("owner", callableReferenceInfo.getOwner());
                    if (callableReferenceInfo.getOwner() != null && (callableReferenceInfo.getOwner().k == 2 || callableReferenceInfo.getOwner().k == 5)) {
                        util.reportIfNull("referenced module", callableReferenceInfo.getOwner().referencedModule);
                    }
                }
            });
        }
    }
}

