/*
 * Decompiled with CFR 0.152.
 */
package proguard.configuration;

import java.io.IOException;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.BranchTargetFinder;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.configuration.ConfigurationLogger;
import proguard.configuration.ConfigurationLoggingInstructionSequenceConstants;
import proguard.configuration.ConfigurationLoggingInstructionSequencesReplacer;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.io.DataEntry;
import proguard.io.ExtraDataEntryNameMap;
import proguard.util.ProcessingFlagSetter;

public class ConfigurationLoggingAdder {
    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, ExtraDataEntryNameMap extraDataEntryNameMap) throws IOException {
        ClassReader classReader = new ClassReader(false, false, false, false, null, (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassPoolFiller(programClassPool), new ClassReferenceInitializer(programClassPool, libraryClassPool), new ClassSubHierarchyInitializer(), new ProcessingFlagSetter(512)}));
        classReader.read((DataEntry)new ClassPathDataEntry(ConfigurationLogger.ClassInfo.class));
        classReader.read((DataEntry)new ClassPathDataEntry(ConfigurationLogger.MemberInfo.class));
        classReader.read((DataEntry)new ClassPathDataEntry(ConfigurationLogger.class));
        this.initializeConfigurationLogger(programClassPool);
        ConfigurationLoggingInstructionSequenceConstants constants = new ConfigurationLoggingInstructionSequenceConstants(programClassPool, libraryClassPool);
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        programClassPool.classesAccept((ClassVisitor)new ClassProcessingFlagFilter(0, 512, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new PeepholeEditor(branchTargetFinder, codeAttributeEditor, (InstructionVisitor)new ConfigurationLoggingInstructionSequencesReplacer(constants.CONSTANTS, constants.RESOURCE, branchTargetFinder, codeAttributeEditor, new ExtraClassAdder(extraDataEntryNameMap)))))));
    }

    private void initializeConfigurationLogger(ClassPool programClassPool) {
        ProgramClass configurationLoggerClass = (ProgramClass)programClassPool.getClass(ConfigurationLoggingInstructionSequenceConstants.LOGGER_CLASS_NAME);
        if (configurationLoggerClass == null) {
            throw new RuntimeException("ConfigurationLogger class could not be found in the program classpool.");
        }
    }

    private static class ExtraClassAdder
    implements InstructionVisitor {
        private final ExtraDataEntryNameMap extraDataEntryNameMap;

        ExtraClassAdder(ExtraDataEntryNameMap extraDataEntryNameMap) {
            this.extraDataEntryNameMap = extraDataEntryNameMap;
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            this.extraDataEntryNameMap.addExtraClassToClass(clazz, ConfigurationLogger.class);
            this.extraDataEntryNameMap.addExtraClassToClass(clazz, ConfigurationLogger.ClassInfo.class);
            this.extraDataEntryNameMap.addExtraClassToClass(clazz, ConfigurationLogger.MemberInfo.class);
        }
    }
}

