/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllBootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.attribute.visitor.NonEmptyAttributeFilter;
import proguard.classfile.attribute.visitor.RequiredAttributeFilter;
import proguard.classfile.constant.visitor.AllBootstrapMethodArgumentVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.BridgeMethodFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.kotlin.visitor.AllFunctionVisitor;
import proguard.classfile.kotlin.visitor.AllPropertyVisitor;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionToDefaultMethodVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinInterfaceToDefaultImplsClassVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataToClazzVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.MultiKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinClassKindFilter;
import proguard.classfile.kotlin.visitor.filter.KotlinSyntheticClassKindFilter;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DynamicReturnedClassVisitor;
import proguard.classfile.visitor.FunctionalInterfaceFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MethodFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.classfile.visitor.ProgramMemberFilter;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.fixer.kotlin.KotlinAnnotationFlagFixer;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassNameAdapterFunction;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.ClassRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberNameCollector;
import proguard.obfuscate.MemberNameConflictFixer;
import proguard.obfuscate.MemberObfuscator;
import proguard.obfuscate.MemberSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.NewMemberNameFilter;
import proguard.obfuscate.OriginalClassNameFilter;
import proguard.obfuscate.ParameterNameMarker;
import proguard.obfuscate.RenamedFlagSetter;
import proguard.obfuscate.ResourceFileNameObfuscator;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.obfuscate.kotlin.KotlinAliasNameObfuscator;
import proguard.obfuscate.kotlin.KotlinAliasReferenceFixer;
import proguard.obfuscate.kotlin.KotlinCallableReferenceFixer;
import proguard.obfuscate.kotlin.KotlinCompanionEqualizer;
import proguard.obfuscate.kotlin.KotlinDataClassObfuscator;
import proguard.obfuscate.kotlin.KotlinDefaultImplsMethodNameEqualizer;
import proguard.obfuscate.kotlin.KotlinDefaultMethodNameEqualizer;
import proguard.obfuscate.kotlin.KotlinIntrinsicsReplacementSequences;
import proguard.obfuscate.kotlin.KotlinModuleFixer;
import proguard.obfuscate.kotlin.KotlinModuleNameObfuscator;
import proguard.obfuscate.kotlin.KotlinMultiFileFacadeFixer;
import proguard.obfuscate.kotlin.KotlinObjectFixer;
import proguard.obfuscate.kotlin.KotlinPropertyNameObfuscator;
import proguard.obfuscate.kotlin.KotlinPropertyRenamer;
import proguard.obfuscate.kotlin.KotlinSourceDebugExtensionAttributeObfuscator;
import proguard.obfuscate.kotlin.KotlinSyntheticClassFixer;
import proguard.obfuscate.kotlin.KotlinUnsupportedExceptionReplacementSequences;
import proguard.obfuscate.kotlin.KotlinValueParameterNameShrinker;
import proguard.obfuscate.kotlin.KotlinValueParameterUsageMarker;
import proguard.obfuscate.util.InstructionSequenceObfuscator;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.PrintWriterUtil;
import proguard.util.StringParser;
import proguard.util.kotlin.asserter.KotlinMetadataAsserter;

public class Obfuscator {
    private final Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool) throws IOException {
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        PrintWriter out = new PrintWriter(System.out, true);
        PrintWriter err = new PrintWriter(System.err, true);
        programClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        libraryClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        BottomClassFilter memberInfoLinker = new BottomClassFilter((ClassVisitor)new MethodLinker());
        programClassPool.classesAccept((ClassVisitor)memberInfoLinker);
        libraryClassPool.classesAccept((ClassVisitor)memberInfoLinker);
        if (this.configuration.useUniqueClassMemberNames) {
            programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MethodLinker()));
        }
        NameMarker nameMarker = new NameMarker();
        libraryClassPool.classesAccept((ClassVisitor)nameMarker);
        libraryClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)nameMarker));
        programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassProcessingFlagFilter(0x400000, 0, (ClassVisitor)nameMarker), new AllMemberVisitor((MemberVisitor)new MemberProcessingFlagFilter(0x400000, 0, (MemberVisitor)nameMarker))}));
        programClassPool.classesAccept((ClassVisitor)new ClassVersionFilter(0x330000, (ClassVisitor)new AllAttributeVisitor((AttributeVisitor)new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor((BootstrapMethodInfoVisitor)new AllBootstrapMethodArgumentVisitor((ConstantVisitor)new ConstantTagFilter(7, (ConstantVisitor)new ReferencedClassVisitor((ClassVisitor)new FunctionalInterfaceFilter((ClassVisitor)new ClassHierarchyTraveler(true, false, true, false, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(1024, 0, (MemberVisitor)nameMarker))))))))))));
        programClassPool.classesAccept((ClassVisitor)new ClassVersionFilter(0x330000, (ClassVisitor)new AllConstantVisitor((ConstantVisitor)new DynamicReturnedClassVisitor((ClassVisitor)new FunctionalInterfaceFilter((ClassVisitor)new ClassHierarchyTraveler(true, false, true, false, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(1024, 0, (MemberVisitor)nameMarker))))))));
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new ClassProcessingFlagFilter(0x400000, 0, (ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinInterfaceToDefaultImplsClassVisitor((ClassVisitor)nameMarker))));
        }
        NonEmptyAttributeFilter attributeUsageMarker = new NonEmptyAttributeFilter((AttributeVisitor)new AttributeUsageMarker());
        AttributeNameFilter optionalAttributeUsageMarker = this.configuration.keepAttributes == null ? null : new AttributeNameFilter(this.configuration.keepAttributes, (AttributeVisitor)attributeUsageMarker);
        programClassPool.classesAccept((ClassVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new RequiredAttributeFilter((AttributeVisitor)attributeUsageMarker, (AttributeVisitor)optionalAttributeUsageMarker)));
        if (this.configuration.keepParameterNames) {
            programClassPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new NewMemberNameFilter((MemberVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new ParameterNameMarker((AttributeVisitor)attributeUsageMarker)))));
            if (this.configuration.keepKotlinMetadata) {
                programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinValueParameterUsageMarker()));
            }
        }
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinValueParameterNameShrinker()));
            programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinSyntheticClassKindFilter(KotlinSyntheticClassKindFilter::isLambda, (KotlinMetadataVisitor)new KotlinMetadataToClazzVisitor((ClassVisitor)new AllAttributeVisitor((AttributeVisitor)new AttributeNameFilter("SourceDebugExtension", (AttributeVisitor)new MultiAttributeVisitor(new AttributeVisitor[]{attributeUsageMarker, new KotlinSourceDebugExtensionAttributeObfuscator()})))))));
        }
        programClassPool.classesAccept((ClassVisitor)new AttributeShrinker());
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinAnnotationFlagFixer()));
        }
        if (this.configuration.applyMapping != null) {
            if (this.configuration.verbose) {
                out.println("Applying mapping from [" + PrintWriterUtil.fileName(this.configuration.applyMapping) + "]...");
            }
            WarningPrinter warningPrinter = new WarningPrinter(err, this.configuration.warn);
            MappingReader reader = new MappingReader(this.configuration.applyMapping);
            MultiMappingProcessor keeper = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(programClassPool, warningPrinter), new MappingKeeper(libraryClassPool, null)});
            reader.pump(keeper);
            int warningCount = warningPrinter.getWarningCount();
            if (warningCount > 0) {
                err.println("Warning: there were " + warningCount + " kept classes and class members that were remapped anyway.");
                err.println("         You should adapt your configuration or edit the mapping file.");
                if (!this.configuration.ignoreWarnings) {
                    err.println("         If you are sure this remapping won't hurt,");
                    err.println("         you could try your luck using the '-ignorewarnings' option.");
                }
                err.println("         (https://www.guardsquare.com/proguard/manual/troubleshooting#mappingconflict1)");
                if (!this.configuration.ignoreWarnings) {
                    throw new IOException("Please correct the above warnings first.");
                }
            }
        }
        DictionaryNameFactory classNameFactory = this.configuration.classObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.classObfuscationDictionary, null) : null;
        DictionaryNameFactory packageNameFactory = this.configuration.packageObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.packageObfuscationDictionary, null) : null;
        programClassPool.classesAccept((ClassVisitor)new ClassObfuscator(programClassPool, libraryClassPool, classNameFactory, packageNameFactory, this.configuration.useMixedCaseClassNames, this.configuration.keepPackageNames, this.configuration.flattenPackageHierarchy, this.configuration.repackageClasses, this.configuration.allowAccessModification, this.configuration.keepKotlinMetadata));
        NameFactory nameFactory = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            nameFactory = new DictionaryNameFactory(this.configuration.obfuscationDictionary, nameFactory);
        }
        WarningPrinter warningPrinter = new WarningPrinter(err, this.configuration.warn);
        HashMap descriptorMap = new HashMap();
        if (this.configuration.useUniqueClassMemberNames) {
            programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)));
            programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap)));
        } else {
            programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, true, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)}));
            programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(false, false, false, true, (ClassVisitor)new ClassAccessFilter(1024, 0, (ClassVisitor)new ClassHierarchyTraveler(false, false, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new ClassHierarchyTraveler(false, false, false, true, (ClassVisitor)new ClassHierarchyTraveler(false, false, true, false, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(0, 1032, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)}));
        }
        SpecialNameFactory specialNameFactory = new SpecialNameFactory(new SimpleNameFactory());
        HashMap specialDescriptorMap = new HashMap();
        programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        libraryClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap))))), new MapCleaner(descriptorMap)}));
        programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, (ClassVisitor)new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap)))), new MapCleaner(descriptorMap)}));
        int warningCount = warningPrinter.getWarningCount();
        if (warningCount > 0) {
            err.println("Warning: there were " + warningCount + " conflicting class member name mappings.");
            err.println("         Your configuration may be inconsistent.");
            if (!this.configuration.ignoreWarnings) {
                err.println("         If you are sure the conflicts are harmless,");
                err.println("         you could try your luck using the '-ignorewarnings' option.");
            }
            err.println("         (https://www.guardsquare.com/proguard/manual/troubleshooting#mappingconflict2)");
            if (!this.configuration.ignoreWarnings) {
                throw new IOException("Please correct the above warnings first.");
            }
        }
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new InstructionSequenceObfuscator(new KotlinIntrinsicsReplacementSequences(programClassPool, libraryClassPool)), new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new MultiKotlinMetadataVisitor(new KotlinMetadataVisitor[]{new KotlinPropertyNameObfuscator(nameFactory), new KotlinAliasNameObfuscator(nameFactory), new KotlinCompanionEqualizer(), new KotlinSyntheticClassFixer(), new KotlinObjectFixer(), new AllFunctionVisitor(new KotlinFunctionVisitor[]{new KotlinDefaultImplsMethodNameEqualizer(), new KotlinDefaultMethodNameEqualizer(), new KotlinFunctionToDefaultMethodVisitor((MemberVisitor)new InstructionSequenceObfuscator(new KotlinUnsupportedExceptionReplacementSequences(programClassPool, libraryClassPool)))}), new KotlinClassKindFilter(kc -> kc.flags.isData, (KotlinMetadataVisitor)new KotlinDataClassObfuscator())}))}));
            resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new ResourceFileProcessingFlagFilter(0, 0x400000, (ResourceFileVisitor)new KotlinModuleNameObfuscator(nameFactory)));
        }
        if (this.configuration.printMapping != null) {
            if (this.configuration.verbose) {
                out.println("Printing mapping to [" + PrintWriterUtil.fileName(this.configuration.printMapping) + "]...");
            }
            PrintWriter mappingWriter = PrintWriterUtil.createPrintWriter(this.configuration.printMapping, out);
            try {
                programClassPool.classesAcceptAlphabetically((ClassVisitor)new MappingPrinter(mappingWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printMapping, mappingWriter);
            }
        }
        if (this.configuration.addConfigurationDebugging) {
            programClassPool.classesAccept((ClassVisitor)new RenamedFlagSetter());
        }
        ClassCounter obfuscatedClassCounter = new ClassCounter();
        MemberCounter obfuscatedFieldCounter = new MemberCounter();
        MemberCounter obfuscatedMethodCounter = new MemberCounter();
        ClassRenamer classRenamer = new ClassRenamer((ClassVisitor)new ProgramClassFilter((ClassVisitor)obfuscatedClassCounter), (MemberVisitor)new ProgramMemberFilter((MemberVisitor)new MethodFilter((MemberVisitor)obfuscatedMethodCounter, (MemberVisitor)obfuscatedFieldCounter)));
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinMultiFileFacadeFixer()));
        }
        programClassPool.classesAccept((ClassVisitor)classRenamer);
        libraryClassPool.classesAccept((ClassVisitor)classRenamer);
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new AllPropertyVisitor((KotlinPropertyVisitor)new KotlinPropertyRenamer())));
        }
        programClassPool.classesAccept((ClassVisitor)new ClassReferenceFixer(false));
        libraryClassPool.classesAccept((ClassVisitor)new ClassReferenceFixer(false));
        programClassPool.classesAccept((ClassVisitor)new MemberReferenceFixer(this.configuration.android));
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new MultiKotlinMetadataVisitor(new KotlinMetadataVisitor[]{new AllTypeVisitor((KotlinTypeVisitor)new KotlinAliasReferenceFixer()), new KotlinCallableReferenceFixer(programClassPool, libraryClassPool)})));
        }
        if (this.configuration.repackageClasses != null && this.configuration.allowAccessModification) {
            programClassPool.classesAccept((ClassVisitor)new AccessFixer());
            programClassPool.classesAccept((ClassVisitor)new OriginalClassNameFilter(null, (ClassVisitor)new AllAttributeVisitor((AttributeVisitor)new AllInnerClassesInfoVisitor((InnerClassesInfoVisitor)new InnerClassesAccessFixer()))));
        }
        programClassPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new BridgeMethodFixer()));
        if (this.configuration.newSourceFileAttribute != null) {
            programClassPool.classesAccept((ClassVisitor)new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        programClassPool.classesAccept((ClassVisitor)new ConstantPoolShrinker());
        if (this.configuration.adaptResourceFileNames != null) {
            resourceFilePool.resourceFilesAccept(new ListParser((StringParser)new FileNameParser()).parse(this.configuration.adaptResourceFileNames), (ResourceFileVisitor)new ResourceFileNameObfuscator(new ClassNameAdapterFunction(programClassPool), true));
        }
        if (this.configuration.verbose) {
            System.out.println("  Number of obfuscated classes:                  " + obfuscatedClassCounter.getCount());
            System.out.println("  Number of obfuscated fields:                   " + obfuscatedFieldCounter.getCount());
            System.out.println("  Number of obfuscated methods:                  " + obfuscatedMethodCounter.getCount());
        }
        if (this.configuration.keepKotlinMetadata) {
            resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new ResourceFileProcessingFlagFilter(0, 8192, (ResourceFileVisitor)new KotlinModuleFixer()));
        }
        if (this.configuration.keepKotlinMetadata && this.configuration.enableKotlinAsserter) {
            new KotlinMetadataAsserter().execute(programClassPool, libraryClassPool, resourceFilePool, warningPrinter);
        }
    }
}

