/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;

public class TailRecursionSimplifier
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraTailRecursionVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private final MyRecursionChecker recursionChecker = new MyRecursionChecker();
    private final StackSizeComputer stackSizeComputer = new StackSizeComputer();
    private Method targetMethod;
    private boolean inlinedAny;

    public TailRecursionSimplifier() {
        this(null);
    }

    public TailRecursionSimplifier(InstructionVisitor extraTailRecursionVisitor) {
        this.extraTailRecursionVisitor = extraTailRecursionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int accessFlags = method.getAccessFlags();
        if ((accessFlags & 0x1A) != 0 && (accessFlags & 0x520) == 0) {
            this.targetMethod = method;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength);
            codeAttribute.instructionsAccept(clazz, method, (InstructionVisitor)this);
            if (this.inlinedAny) {
                this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
                codeAttribute.exceptionsAccept(clazz, method, (ExceptionInfoVisitor)this);
                this.codeAttributeComposer.endCodeFragment();
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
            }
        }
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(offset, instruction);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this.recursionChecker);
                if (!this.recursionChecker.isRecursive()) break;
                int nextOffset = offset + constantInstruction.length(offset);
                Instruction nextInstruction = InstructionFactory.create((byte[])codeAttribute.code, (int)nextOffset);
                switch (nextInstruction.opcode) {
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: {
                        codeAttribute.exceptionsAccept(clazz, method, offset, (ExceptionInfoVisitor)this.recursionChecker);
                        if (!this.recursionChecker.isRecursive()) break;
                        this.stackSizeComputer.visitCodeAttribute(clazz, method, codeAttribute);
                        if (!this.stackSizeComputer.isReachable(nextOffset) || this.stackSizeComputer.getStackSizeAfter(nextOffset) != 0) break;
                        this.codeAttributeComposer.appendLabel(offset);
                        this.storeParameters(clazz, method);
                        int gotoOffset = offset + 1;
                        this.codeAttributeComposer.appendInstruction(gotoOffset, (Instruction)new BranchInstruction(-89, -gotoOffset));
                        this.inlinedAny = true;
                        if (this.extraTailRecursionVisitor != null) {
                            this.extraTailRecursionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                        }
                        return;
                    }
                }
                break;
            }
        }
        this.codeAttributeComposer.appendInstruction(offset, (Instruction)constantInstruction);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.codeAttributeComposer.appendException(new ExceptionInfo(exceptionInfo.u2startPC, exceptionInfo.u2endPC, exceptionInfo.u2handlerPC, exceptionInfo.u2catchType));
    }

    private void storeParameters(Clazz clazz, Method method) {
        String parameterType;
        int parameterIndex;
        String descriptor = method.getDescriptor(clazz);
        boolean isStatic = (method.getAccessFlags() & 8) != 0;
        int parameterSize = ClassUtil.internalMethodParameterSize((String)descriptor);
        int parameterOffset = isStatic ? 0 : 1;
        String[] parameterTypes = new String[parameterSize];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        for (parameterIndex = 0; parameterIndex < parameterSize; ++parameterIndex) {
            parameterTypes[parameterIndex] = parameterType = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize((String)parameterType) != 2) continue;
            ++parameterIndex;
        }
        this.codeAttributeComposer.beginCodeFragment(parameterSize + 1);
        for (parameterIndex = parameterSize - 1; parameterIndex >= 0; --parameterIndex) {
            byte opcode;
            parameterType = parameterTypes[parameterIndex];
            if (parameterType == null) continue;
            switch (parameterType.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    opcode = 54;
                    break;
                }
                case 'J': {
                    opcode = 55;
                    break;
                }
                case 'F': {
                    opcode = 56;
                    break;
                }
                case 'D': {
                    opcode = 57;
                    break;
                }
                default: {
                    opcode = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(parameterSize - parameterIndex - 1, (Instruction)new VariableInstruction(opcode, parameterOffset + parameterIndex));
        }
        if (!isStatic) {
            this.codeAttributeComposer.appendInstruction(parameterSize, (Instruction)new VariableInstruction(58, 0));
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    private class MyRecursionChecker
    implements ConstantVisitor,
    ExceptionInfoVisitor {
        private boolean recursive;

        private MyRecursionChecker() {
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant methodrefConstant) {
            this.recursive = TailRecursionSimplifier.this.targetMethod.equals(methodrefConstant.referencedMethod);
        }

        public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
            this.recursive = false;
        }
    }
}

