/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.ReverseDependencyCalculator;
import proguard.optimize.ReverseDependencyStore;

public class InfluenceFixpointVisitor
implements ClassPoolVisitor {
    private static final boolean DEBUG = System.getProperty("ifv") != null;
    private static final int THREAD_COUNT;
    private final MemberVisitorFactory memberVisitorFactory;
    private ReverseDependencyStore reverseDependencyStore;
    private final ExecutorService executorService = Executors.newFixedThreadPool(THREAD_COUNT, new MyThreadFactory());
    private final Set<MyAnalysis> queuedAnalyses = Collections.synchronizedSet(new HashSet());
    private final CountLatch countLatch = new CountLatch();

    public InfluenceFixpointVisitor(MemberVisitorFactory memberVisitorFactory) {
        this.memberVisitorFactory = memberVisitorFactory;
    }

    public void visitClassPool(ClassPool classPool) {
        this.reverseDependencyStore = new ReverseDependencyCalculator(classPool).reverseDependencyStore();
        long start = 0L;
        if (DEBUG) {
            start = System.currentTimeMillis();
        }
        try {
            classPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new MyAnalysisSubmitter()));
            this.countLatch.await();
            this.executorService.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Parallel execution is taking too long", e);
        }
        if (DEBUG) {
            long end = System.currentTimeMillis();
            System.out.print("InfluenceFixpointVisitor........................");
            System.out.printf(" took: %6d ms%n", end - start);
        }
    }

    static {
        Integer threads = null;
        try {
            String threadCountString = System.getProperty("parallel.threads");
            if (threadCountString != null) {
                threads = Integer.parseInt(threadCountString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        threads = threads == null ? Runtime.getRuntime().availableProcessors() - 1 : Math.min(threads, Runtime.getRuntime().availableProcessors());
        THREAD_COUNT = Math.max(1, threads);
    }

    private static class CountLatch {
        private int counter;

        private CountLatch() {
        }

        public synchronized void increment() {
            ++this.counter;
        }

        public synchronized void decrement() {
            if (--this.counter <= 0) {
                this.notifyAll();
            }
        }

        public synchronized void await() throws InterruptedException {
            if (this.counter > 0) {
                this.wait();
            }
        }
    }

    private class MyAnalysis
    implements Runnable {
        private final Clazz clazz;
        private final Member member;

        private MyAnalysis(Clazz clazz, Member member) {
            this.clazz = clazz;
            this.member = member;
        }

        @Override
        public void run() {
            try {
                InfluenceFixpointVisitor.this.queuedAnalyses.remove(this);
                MemberVisitor memberVisitor = ((MyAnalysisThread)Thread.currentThread()).memberVisitor;
                this.member.accept(this.clazz, memberVisitor);
            }
            finally {
                InfluenceFixpointVisitor.this.countLatch.decrement();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyAnalysis that = (MyAnalysis)o;
            return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.member, that.member);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.member);
        }
    }

    private class MyAnalysisSubmitter
    implements MemberVisitor {
        private MyAnalysisSubmitter() {
        }

        public void visitAnyMember(Clazz clazz, Member member) {
            MyAnalysis analysis = new MyAnalysis(clazz, member);
            if (InfluenceFixpointVisitor.this.queuedAnalyses.add(analysis)) {
                InfluenceFixpointVisitor.this.countLatch.increment();
                InfluenceFixpointVisitor.this.executorService.submit(analysis);
            }
        }
    }

    private class MyAnalysisThread
    extends Thread {
        private final MemberVisitor memberVisitor;

        public MyAnalysisThread(Runnable runnable) {
            super(runnable);
            MemberVisitorFactory memberVisitorFactory = InfluenceFixpointVisitor.this.memberVisitorFactory;
            ReverseDependencyStore reverseDependencyStore = InfluenceFixpointVisitor.this.reverseDependencyStore;
            Objects.requireNonNull(reverseDependencyStore);
            this.memberVisitor = memberVisitorFactory.createMemberVisitor(new ReverseDependencyStore.InfluencedMethodTraveller(reverseDependencyStore, new MyAnalysisSubmitter()));
        }
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new MyAnalysisThread(runnable);
        }
    }

    public static interface MemberVisitorFactory {
        public MemberVisitor createMemberVisitor(MemberVisitor var1);
    }
}

