/*
 * Decompiled with CFR 0.152.
 */
package proguard.mark;

import java.util.Arrays;
import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeProcessingFlagFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.visitor.KotlinFunctionToDefaultMethodVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionToMethodVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.util.ProcessingFlagSetter;

public class Marker {
    private final Configuration configuration;

    public Marker(Configuration configuration) {
        this.configuration = configuration;
    }

    public void mark(ClassPool programClassPool, ClassPool libraryClassPool) {
        MultiClassPoolVisitor classPoolVisitor = new MultiClassPoolVisitor(new ClassPoolVisitor[]{this.createShrinkingMarker(), this.createOptimizationMarker(), this.createObfuscationMarker()});
        programClassPool.accept((ClassPoolVisitor)classPoolVisitor);
        libraryClassPool.accept((ClassPoolVisitor)classPoolVisitor);
        if (this.configuration.keepKotlinMetadata) {
            ClassNameFilter classVisitor = new ClassNameFilter("kotlin/Metadata", (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ProcessingFlagSetter(0x700000), new AllMemberVisitor((MemberVisitor)new ProcessingFlagSetter(0x700000))}));
            programClassPool.classesAccept((ClassVisitor)classVisitor);
            libraryClassPool.classesAccept((ClassVisitor)classVisitor);
        }
        if (this.configuration.keepKotlinMetadata) {
            this.disableOptimizationForKotlinFeatures(programClassPool, libraryClassPool);
        }
    }

    private ClassPoolVisitor createShrinkingMarker() {
        ProcessingFlagSetter marker = new ProcessingFlagSetter(0x100000);
        MultiClassVisitor classUsageMarker = new MultiClassVisitor(new ClassVisitor[]{marker, new NamedMethodVisitor("<init>", "()V", (MemberVisitor)marker)});
        return new KeepClassSpecificationVisitorFactory(true, false, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)classUsageMarker, (MemberVisitor)marker);
    }

    private ClassPoolVisitor createOptimizationMarker() {
        ProcessingFlagSetter marker = new ProcessingFlagSetter(0x200000);
        MemberDescriptorReferencedClassVisitor descriptorClassMarker = new MemberDescriptorReferencedClassVisitor((ClassVisitor)new ClassAccessFilter(0, 16384, (ClassVisitor)marker));
        return new MultiClassPoolVisitor(new ClassPoolVisitor[]{new KeepClassSpecificationVisitorFactory(false, true, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)marker, (MemberVisitor)marker, (MemberVisitor)marker, (AttributeVisitor)marker), new KeepClassSpecificationVisitorFactory(false, false, true).createClassPoolVisitor(this.configuration.keep, null, (MemberVisitor)descriptorClassMarker, (MemberVisitor)descriptorClassMarker, null)});
    }

    private ClassPoolVisitor createObfuscationMarker() {
        ProcessingFlagSetter marker = new ProcessingFlagSetter(0x400000);
        ClassProcessingFlagFilter classMarker = new ClassProcessingFlagFilter(0, 512, (ClassVisitor)marker);
        MemberProcessingFlagFilter memberMarker = new MemberProcessingFlagFilter(0, 512, (MemberVisitor)marker);
        AttributeProcessingFlagFilter attributeMarker = new AttributeProcessingFlagFilter(0, 512, (AttributeVisitor)marker);
        return new KeepClassSpecificationVisitorFactory(false, false, true).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)classMarker, (MemberVisitor)memberMarker, (MemberVisitor)memberMarker, (AttributeVisitor)attributeMarker);
    }

    private void disableOptimizationForKotlinFeatures(ClassPool programClassPool, ClassPool libraryClassPool) {
        ReferencedKotlinMetadataVisitor classVisitor = new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinDontOptimizeMarker());
        programClassPool.classesAccept((ClassVisitor)classVisitor);
        libraryClassPool.classesAccept((ClassVisitor)classVisitor);
    }

    private static boolean hasAnyOf(int value, int ... flag) {
        return (value & Arrays.stream(flag).reduce((a, b) -> a | b).orElse(0)) != 0;
    }

    public static class KotlinDontOptimizeMarker
    implements KotlinMetadataVisitor,
    KotlinFunctionVisitor {
        private static final MultiMemberVisitor MEMBER_AND_CLASS_MARKER = new MultiMemberVisitor(new MemberVisitor[]{new ProcessingFlagSetter(0x200000), new MemberToClassVisitor((ClassVisitor)new ProcessingFlagSetter(0x200000))});

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            kotlinDeclarationContainerMetadata.functionsAccept(clazz, (KotlinFunctionVisitor)this);
        }

        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            this.visitKotlinDeclarationContainerMetadata(clazz, (KotlinDeclarationContainerMetadata)kotlinClassKindMetadata);
            if (kotlinClassKindMetadata.flags.isObject) {
                clazz.fieldAccept("INSTANCE", null, (MemberVisitor)MEMBER_AND_CLASS_MARKER);
            }
            clazz.methodsAccept((MemberVisitor)new MemberNameFilter("<init>", (MemberVisitor)new AllParameterVisitor(false, (_clazz, member, parameterIndex, parameterCount, parameterOffset, parameterSize, parameterType, referencedClass) -> {
                if (parameterType.equals("Lkotlin/jvm/internal/DefaultConstructorMarker;")) {
                    clazz.accept((ClassVisitor)new ProcessingFlagSetter(0x200000));
                    member.accept(_clazz, (MemberVisitor)new ProcessingFlagSetter(0x200000));
                }
            })));
            if (kotlinClassKindMetadata.companionObjectName != null) {
                clazz.fieldAccept(kotlinClassKindMetadata.companionObjectName, null, (MemberVisitor)MEMBER_AND_CLASS_MARKER);
            }
        }

        public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            if (kotlinSyntheticClassKindMetadata.flavor == KotlinSyntheticClassKindMetadata.Flavor.LAMBDA) {
                kotlinSyntheticClassKindMetadata.functionsAccept(clazz, (KotlinFunctionVisitor)new KotlinFunctionToMethodVisitor((MemberVisitor)MEMBER_AND_CLASS_MARKER));
            }
            if (clazz.extendsOrImplements("kotlin/jvm/internal/CallableReference")) {
                clazz.accept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ProcessingFlagSetter(0x200000), new AllMemberVisitor((MemberVisitor)new MemberAccessFilter(1, 0, (MemberVisitor)new MultiMemberVisitor(new MemberVisitor[]{new ProcessingFlagSetter(0x200000), new AllAttributeVisitor((AttributeVisitor)new AttributeNameFilter("Code", (AttributeVisitor)new ProcessingFlagSetter(0x200000)))})))}));
            }
        }

        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            if (Marker.hasAnyOf(kotlinFunctionMetadata.referencedMethod.getProcessingFlags(), new int[]{0x200000, 0x100000, 0x400000})) {
                kotlinFunctionMetadata.accept(clazz, kotlinDeclarationContainerMetadata, (KotlinFunctionVisitor)new KotlinFunctionToDefaultMethodVisitor((MemberVisitor)MEMBER_AND_CLASS_MARKER));
            }
            if (kotlinDeclarationContainerMetadata.k == 1 && ((KotlinClassKindMetadata)kotlinDeclarationContainerMetadata).flags.isInterface && !kotlinFunctionMetadata.flags.modality.isAbstract && Marker.hasAnyOf(kotlinFunctionMetadata.referencedMethod.getProcessingFlags(), new int[]{0x200000, 0x100000, 0x400000})) {
                kotlinFunctionMetadata.referencedDefaultImplementationMethod.accept(kotlinFunctionMetadata.referencedDefaultImplementationMethodClass, (MemberVisitor)new ProcessingFlagSetter(0x200000));
                kotlinFunctionMetadata.referencedDefaultImplementationMethodClass.accept((ClassVisitor)new ProcessingFlagSetter(0x200000));
            }
        }

        public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            if (Marker.hasAnyOf(kotlinFunctionMetadata.referencedMethod.getProcessingFlags(), new int[]{0x200000, 0x100000, 0x400000})) {
                kotlinFunctionMetadata.accept(clazz, kotlinSyntheticClassKindMetadata, (KotlinFunctionVisitor)new KotlinFunctionToDefaultMethodVisitor((MemberVisitor)MEMBER_AND_CLASS_MARKER));
            }
        }
    }
}

