/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;

public class KeptMemberFilter
implements MemberVisitor {
    private final MemberVisitor memberVisitor;

    public KeptMemberFilter(MemberVisitor memberVisitor) {
        this.memberVisitor = memberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (KeepMarker.isKept((Field)programField)) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (KeepMarker.isKept((Method)programMethod)) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (KeepMarker.isKept((Field)libraryField)) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (KeepMarker.isKept((Method)libraryMethod)) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

