/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class ConstantParameterFilter
implements MemberVisitor {
    private final MemberVisitor constantParameterVisitor;

    public ConstantParameterFilter(MemberVisitor constantParameterVisitor) {
        this.constantParameterVisitor = constantParameterVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        boolean isStatic = (programMethod.getAccessFlags() & 8) != 0;
        int parameterStart = isStatic ? 0 : 1;
        int parameterCount = ClassUtil.internalMethodParameterCount((String)programMethod.getDescriptor((Clazz)programClass), (boolean)isStatic);
        for (int index = parameterStart; index < parameterCount; ++index) {
            Value value = StoringInvocationUnit.getMethodParameterValue((Method)programMethod, index);
            if (value == null || !value.isParticular()) continue;
            this.constantParameterVisitor.visitProgramMethod(programClass, programMethod);
        }
    }
}

