/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.optimize.info.MutableBoolean;

public class RepeatedClassPoolVisitor
implements ClassPoolVisitor {
    private static final Logger logger = LogManager.getLogger(RepeatedClassPoolVisitor.class);
    private final MutableBoolean repeatTrigger;
    private final ClassPoolVisitor classPoolVisitor;

    public RepeatedClassPoolVisitor(MutableBoolean repeatTrigger, ClassPoolVisitor classPoolVisitor) {
        this.repeatTrigger = repeatTrigger;
        this.classPoolVisitor = classPoolVisitor;
    }

    public void visitClassPool(ClassPool classPool) {
        do {
            logger.debug("RepeatedClassPoolVisitor: new iteration");
            this.repeatTrigger.reset();
            this.classPoolVisitor.visitClassPool(classPool);
        } while (this.repeatTrigger.isSet());
        logger.debug("RepeatedClassPoolVisitor: done iterating");
    }
}

