/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AttributeCounter;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.ExceptClassConstantFilter;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.InterfaceAdder;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.editor.SubclassAdder;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ExceptClassesFilter;
import proguard.classfile.visitor.ImplementedClassConstantFilter;
import proguard.classfile.visitor.ImplementingClassConstantFilter;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SimilarMemberVisitor;
import proguard.classfile.visitor.SubclassFilter;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.CaughtClassFilter;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassFilter;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ProgramClassOptimizationInfo;
import proguard.optimize.info.ProgramFieldOptimizationInfo;
import proguard.optimize.info.SideEffectClassFilter;
import proguard.util.FixedStringMatcher;
import proguard.util.NotMatcher;
import proguard.util.OrMatcher;
import proguard.util.ProcessingFlagSetter;
import proguard.util.StringMatcher;

public class ClassMerger
implements ClassVisitor,
ConstantVisitor {
    private static final Logger logger = LogManager.getLogger(ClassMerger.class);
    private static final boolean DEBUG = false;
    private static final boolean DETAILS = false;
    private final ProgramClass targetClass;
    private final boolean allowAccessModification;
    private final boolean mergeInterfacesAggressively;
    private final boolean mergeWrapperClasses;
    private final ClassVisitor extraClassVisitor;

    public ClassMerger(ProgramClass targetClass, boolean allowAccessModification, boolean mergeInterfacesAggressively, boolean mergeWrapperClasses) {
        this(targetClass, allowAccessModification, mergeInterfacesAggressively, mergeWrapperClasses, null);
    }

    public ClassMerger(ProgramClass targetClass, boolean allowAccessModification, boolean mergeInterfacesAggressively, boolean mergeWrapperClasses, ClassVisitor extraClassVisitor) {
        this.targetClass = targetClass;
        this.allowAccessModification = allowAccessModification;
        this.mergeInterfacesAggressively = mergeInterfacesAggressively;
        this.mergeWrapperClasses = mergeWrapperClasses;
        this.extraClassVisitor = extraClassVisitor;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        try {
            this.visitProgramClass0(programClass);
        }
        catch (RuntimeException ex) {
            logger.error("Unexpected error while merging classes:");
            logger.error("  Class        = [{}]", (Object)programClass.getName());
            logger.error("  Target class = [{}]", (Object)this.targetClass.getName());
            logger.error("  Exception    = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            logger.debug("{}", new Supplier[]{() -> {
                StringWriter sw = new StringWriter();
                programClass.accept((ClassVisitor)new ClassPrinter(new PrintWriter(sw)));
                return sw.toString();
            }});
            logger.debug("{}", new Supplier[]{() -> {
                StringWriter sw = new StringWriter();
                this.targetClass.accept((ClassVisitor)new ClassPrinter(new PrintWriter(sw)));
                return sw.toString();
            }});
            throw ex;
        }
    }

    private void visitProgramClass0(ProgramClass programClass) {
        if (this.isMergeable(programClass)) {
            logger.debug("ClassMerger [{}] -> [{}]", (Object)programClass.getName(), (Object)this.targetClass.getName());
            logger.debug("  Source instantiated? [ {}]", (Object)InstantiationClassMarker.isInstantiated((Clazz)programClass));
            logger.debug("  Target instantiated? [ {}]", (Object)InstantiationClassMarker.isInstantiated((Clazz)this.targetClass));
            logger.debug("  Source interface? [{}]", (Object)((programClass.getAccessFlags() & 0x200) != 0 ? 1 : 0));
            logger.debug("  Target interface? [{}]", (Object)((this.targetClass.getAccessFlags() & 0x200) != 0 ? 1 : 0));
            logger.debug("  Source subclasses ({})", (Object)programClass.subClassCount);
            logger.debug("  Target subclasses ({})", (Object)this.targetClass.subClassCount);
            logger.debug("  Source superclass [{}]", (Object)programClass.getSuperClass().getName());
            logger.debug("  Target superclass [{}]", (Object)this.targetClass.getSuperClass().getName());
            logger.trace("=== Before ===");
            logger.trace("{}", new Supplier[]{() -> {
                StringWriter sw = new StringWriter();
                programClass.accept((ClassVisitor)new ClassPrinter(new PrintWriter(sw)));
                return sw.toString();
            }});
            logger.trace("{}", new Supplier[]{() -> {
                StringWriter sw = new StringWriter();
                this.targetClass.accept((ClassVisitor)new ClassPrinter(new PrintWriter(sw)));
                return sw.toString();
            }});
            int targetAccessFlags = this.targetClass.getAccessFlags();
            int sourceAccessFlags = programClass.getAccessFlags();
            this.targetClass.u2accessFlags = targetAccessFlags & sourceAccessFlags & 0x600 | (targetAccessFlags | sourceAccessFlags) & 0x6021;
            programClass.interfaceConstantsAccept((ConstantVisitor)new ExceptClassConstantFilter(this.targetClass.getName(), (ConstantVisitor)new ImplementedClassConstantFilter((Clazz)this.targetClass, (ConstantVisitor)new ImplementingClassConstantFilter((Clazz)this.targetClass, (ConstantVisitor)new InterfaceAdder(this.targetClass)))));
            this.targetClass.interfaceConstantsAccept((ConstantVisitor)new ReferencedClassVisitor((ClassVisitor)new SubclassFilter((Clazz)this.targetClass, (ClassVisitor)new SubclassAdder((Clazz)this.targetClass))));
            MemberAdder memberAdder = new MemberAdder(this.targetClass, (MemberVisitor)new MultiMemberVisitor(new MemberVisitor[]{new MyMemberOptimizationInfoCopier(), new ProcessingFlagSetter(16384)}));
            programClass.fieldsAccept((MemberVisitor)(this.mergeWrapperClasses ? new MemberAccessFilter(8, 0, (MemberVisitor)memberAdder) : memberAdder));
            programClass.methodsAccept((MemberVisitor)(this.mergeWrapperClasses ? new MemberNameFilter((StringMatcher)new NotMatcher((StringMatcher)new FixedStringMatcher("<init>")), (MemberVisitor)memberAdder) : memberAdder));
            programClass.attributesAccept((AttributeVisitor)new AttributeNameFilter((StringMatcher)new NotMatcher((StringMatcher)new OrMatcher(new StringMatcher[]{new FixedStringMatcher("BootstrapMethods"), new OrMatcher(new StringMatcher[]{new FixedStringMatcher("SourceFile"), new OrMatcher(new StringMatcher[]{new FixedStringMatcher("InnerClasses"), new FixedStringMatcher("EnclosingMethod")})})})), (AttributeVisitor)new AttributeAdder(this.targetClass, true)));
            logger.debug("merging optimization info for {} and {}", (Object)this.targetClass.getName(), (Object)programClass.getName());
            ProgramClassOptimizationInfo.getProgramClassOptimizationInfo((Clazz)this.targetClass).merge(ClassOptimizationInfo.getClassOptimizationInfo((Clazz)programClass));
            ClassMerger.setTargetClass((Clazz)programClass, (Clazz)this.targetClass);
            logger.trace("=== After ====");
            logger.trace("Target instantiated? {}", (Object)InstantiationClassMarker.isInstantiated((Clazz)this.targetClass));
            logger.trace("{}", new Supplier[]{() -> {
                StringWriter sw = new StringWriter();
                this.targetClass.accept((ClassVisitor)new ClassPrinter(new PrintWriter(sw)));
                return sw.toString();
            }});
            logger.trace("  Interfaces:");
            logger.trace("{}", new Supplier[]{() -> {
                StringWriter sw = new StringWriter();
                this.targetClass.interfaceConstantsAccept((ConstantVisitor)new ClassPrinter(new PrintWriter(sw)));
                return sw.toString();
            }});
            if (this.extraClassVisitor != null) {
                this.extraClassVisitor.visitProgramClass(programClass);
            }
        }
    }

    public boolean isMergeable(ProgramClass programClass) {
        return !(programClass.equals(this.targetClass) || KeepMarker.isKept((Clazz)programClass) || KeepMarker.isKept((Clazz)this.targetClass) || ClassMerger.getTargetClass((Clazz)programClass) != null || ClassMerger.getTargetClass((Clazz)this.targetClass) != null || (programClass.getAccessFlags() & 0x2000) != 0 || programClass.u4version != this.targetClass.u4version || ClassMerger.isNestHostOrMember((Clazz)programClass) || !this.mergeWrapperClasses && (programClass.getAccessFlags() & 0x1000) == 0 && this.hasNonCopiableAttributes((Clazz)programClass) || !this.allowAccessModification && ((programClass.getAccessFlags() & this.targetClass.getAccessFlags() & 1) == 0 || PackageVisibleMemberContainingClassMarker.containsPackageVisibleMembers((Clazz)programClass) || PackageVisibleMemberInvokingClassMarker.invokesPackageVisibleMembers((Clazz)programClass)) && !ClassUtil.internalPackageName((String)programClass.getName()).equals(ClassUtil.internalPackageName((String)this.targetClass.getName())) || (programClass.getAccessFlags() & 0x600) != (this.targetClass.getAccessFlags() & 0x600) && (!this.isOnlySubClass((Clazz)programClass, this.targetClass) || programClass.getSuperClass() == null || !programClass.getSuperClass().equals(this.targetClass) && !programClass.getSuperClass().equals(this.targetClass.getSuperClass())) || this.indirectlyImplementedInterfaces((Clazz)programClass).contains(this.targetClass) || this.targetClass.extendsOrImplements((Clazz)programClass) || (programClass.getAccessFlags() & 0x200) != 0 && (this.targetClass.getAccessFlags() & 0x200) != 0 && !this.subInterfaces((Clazz)programClass, (Clazz)this.targetClass).equals(this.subInterfaces((Clazz)this.targetClass, (Clazz)programClass)) || !this.sideEffectSuperClasses((Clazz)programClass).equals(this.sideEffectSuperClasses((Clazz)this.targetClass)) || !this.instanceofedSuperClasses((Clazz)programClass).equals(this.instanceofedSuperClasses((Clazz)this.targetClass)) || !this.caughtSuperClasses((Clazz)programClass).equals(this.caughtSuperClasses((Clazz)this.targetClass)) || DotClassMarker.isDotClassed((Clazz)programClass) && DotClassMarker.isDotClassed((Clazz)this.targetClass) || !this.mergeWrapperClasses && this.haveAnyIdenticalFields((Clazz)programClass, (Clazz)this.targetClass) || !this.mergeWrapperClasses && (this.introducesUnwantedFields((Clazz)programClass, this.targetClass) || this.introducesUnwantedFields((Clazz)this.targetClass, programClass)) || !this.mergeWrapperClasses && (this.shadowsAnyFields((Clazz)programClass, (Clazz)this.targetClass) || this.shadowsAnyFields((Clazz)this.targetClass, (Clazz)programClass)) || this.haveAnyIdenticalMethods((Clazz)programClass, (Clazz)this.targetClass) || !this.mergeInterfacesAggressively && (this.introducesUnwantedAbstractMethods((Clazz)programClass, this.targetClass) || this.introducesUnwantedAbstractMethods((Clazz)this.targetClass, programClass)) || this.overridesAnyMethods((Clazz)programClass, this.targetClass) || this.overridesAnyMethods((Clazz)this.targetClass, programClass) || this.shadowsAnyMethods((Clazz)programClass, (Clazz)this.targetClass) || this.shadowsAnyMethods((Clazz)this.targetClass, (Clazz)programClass) || ClassMerger.hasSignatureAttribute((Clazz)programClass) || ClassMerger.hasSignatureAttribute((Clazz)this.targetClass));
    }

    private boolean print(ProgramClass programClass, String message) {
        logger.debug("Merge [{}] <- [{}] {}", (Object)this.targetClass.getName(), (Object)programClass.getName(), (Object)message);
        return true;
    }

    private boolean isOnlySubClass(Clazz subClass, ProgramClass clazz) {
        return clazz.subClassCount == 1 && clazz.subClasses[0].equals(subClass);
    }

    private Set indirectlyImplementedInterfaces(Clazz clazz) {
        HashSet set = new HashSet();
        ReferencedClassVisitor referencedInterfaceCollector = new ReferencedClassVisitor((ClassVisitor)new ClassHierarchyTraveler(false, false, true, false, (ClassVisitor)new ClassCollector(set)));
        clazz.superClassConstantAccept((ConstantVisitor)referencedInterfaceCollector);
        clazz.interfaceConstantsAccept((ConstantVisitor)referencedInterfaceCollector);
        return set;
    }

    private Set subInterfaces(Clazz clazz, Clazz exceptClass) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(false, false, false, true, (ClassVisitor)new ClassAccessFilter(512, 0, (ClassVisitor)new ExceptClassesFilter(new Clazz[]{exceptClass}, (ClassVisitor)new ClassCollector(set))));
        return set;
    }

    private Set sideEffectSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, (ClassVisitor)new SideEffectClassFilter((ClassVisitor)new ClassCollector(set)));
        return set;
    }

    private Set instanceofedSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, (ClassVisitor)new InstanceofClassFilter((ClassVisitor)new ClassCollector(set)));
        return set;
    }

    private Set caughtSuperClasses(Clazz clazz) {
        if (!clazz.extends_("java/lang/Throwable")) {
            return Collections.EMPTY_SET;
        }
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, false, false, (ClassVisitor)new CaughtClassFilter((ClassVisitor)new ClassCollector(set)));
        return set;
    }

    static boolean hasSignatureAttribute(Clazz clazz) {
        AttributeCounter counter = new AttributeCounter();
        clazz.attributesAccept((AttributeVisitor)new AttributeNameFilter((StringMatcher)new FixedStringMatcher("Signature"), (AttributeVisitor)counter));
        return counter.getCount() > 0;
    }

    private boolean haveAnyIdenticalFields(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.fieldsAccept((MemberVisitor)new SimilarMemberVisitor(targetClass, true, false, false, false, (MemberVisitor)counter));
        return counter.getCount() > 0;
    }

    private boolean introducesUnwantedFields(Clazz programClass, ProgramClass targetClass) {
        if (!InstantiationClassMarker.isInstantiated((Clazz)targetClass) && (targetClass.subClassCount == 0 || this.isOnlySubClass(programClass, targetClass))) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        programClass.fieldsAccept((MemberVisitor)new MemberAccessFilter(0, 8, (MemberVisitor)counter));
        return counter.getCount() > 0;
    }

    private boolean shadowsAnyFields(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, (ClassVisitor)new AllFieldVisitor((MemberVisitor)new SimilarMemberVisitor(targetClass, true, true, true, false, (MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)counter))));
        return counter.getCount() > 0;
    }

    private boolean haveAnyIdenticalMethods(Clazz clazz, Clazz targetClass) {
        MemberCounter counter = new MemberCounter();
        clazz.methodsAccept((MemberVisitor)new MemberAccessFilter(0, 1024, (MemberVisitor)new SimilarMemberVisitor(targetClass, true, false, false, false, (MemberVisitor)new MemberAccessFilter(0, 1024, (MemberVisitor)counter))));
        return counter.getCount() > 0;
    }

    private boolean introducesUnwantedAbstractMethods(Clazz clazz, ProgramClass targetClass) {
        if ((targetClass.getAccessFlags() & 0x600) != 0 && (targetClass.subClassCount == 0 || this.isOnlySubClass(clazz, targetClass))) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        HashSet targetSet = new HashSet();
        clazz.methodsAccept((MemberVisitor)new MemberAccessFilter(1024, 0, (MemberVisitor)new MultiMemberVisitor(new MemberVisitor[]{counter, new SimilarMemberVisitor((Clazz)targetClass, true, true, true, false, (MemberVisitor)new MemberAccessFilter(1024, 0, (MemberVisitor)new MemberCollector(false, true, true, targetSet)))})));
        return targetSet.size() < counter.getCount();
    }

    private boolean overridesAnyMethods(Clazz clazz, ProgramClass targetClass) {
        if (!InstantiationClassMarker.isInstantiated((Clazz)targetClass) && (targetClass.subClassCount == 0 || this.isOnlySubClass(clazz, targetClass))) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        clazz.methodsAccept((MemberVisitor)new MemberAccessFilter(0, 1024, (MemberVisitor)new InitializerMethodFilter(null, (MemberVisitor)new SimilarMemberVisitor((Clazz)targetClass, true, true, false, false, (MemberVisitor)new MemberAccessFilter(0, 1034, (MemberVisitor)counter)))));
        return counter.getCount() > 0;
    }

    private boolean shadowsAnyMethods(Clazz clazz, Clazz targetClass) {
        if (clazz.extends_(targetClass) || targetClass.extends_(clazz)) {
            return false;
        }
        MemberCounter counter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new InitializerMethodFilter(null, (MemberVisitor)new SimilarMemberVisitor(targetClass, true, true, false, false, (MemberVisitor)new MemberAccessFilter(16, 0, (MemberVisitor)counter)))));
        if (counter.getCount() > 0) {
            return true;
        }
        clazz.hierarchyAccept(true, false, false, true, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(2, 0, (MemberVisitor)new InitializerMethodFilter(null, (MemberVisitor)new SimilarMemberVisitor(targetClass, true, true, true, false, (MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)counter))))));
        if (counter.getCount() > 0) {
            return true;
        }
        clazz.hierarchyAccept(true, false, false, true, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(8, 0, (MemberVisitor)new InitializerMethodFilter(null, (MemberVisitor)new SimilarMemberVisitor(targetClass, true, true, true, false, (MemberVisitor)new MemberAccessFilter(0, 2, (MemberVisitor)counter))))));
        return counter.getCount() > 0;
    }

    private boolean hasNonCopiableAttributes(Clazz clazz) {
        AttributeCounter counter = new AttributeCounter();
        clazz.attributesAccept((AttributeVisitor)new AttributeNameFilter((StringMatcher)new OrMatcher(new StringMatcher[]{new FixedStringMatcher("InnerClasses"), new FixedStringMatcher("EnclosingMethod")}), (AttributeVisitor)counter));
        return counter.getCount() > 0;
    }

    public static boolean isNestHostOrMember(Clazz clazz) {
        AttributeCounter counter = new AttributeCounter();
        clazz.attributesAccept((AttributeVisitor)new AttributeNameFilter((StringMatcher)new OrMatcher(new StringMatcher[]{new FixedStringMatcher("NestHost"), new FixedStringMatcher("NestMembers")}), (AttributeVisitor)counter));
        return counter.getCount() > 0;
    }

    public static void setTargetClass(Clazz clazz, Clazz targetClass) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setTargetClass(targetClass);
    }

    public static Clazz getTargetClass(Clazz clazz) {
        Clazz targetClass = null;
        while ((clazz = ClassOptimizationInfo.getClassOptimizationInfo(clazz).getTargetClass()) != null) {
            targetClass = clazz;
        }
        return targetClass;
    }

    private static class MyMemberOptimizationInfoCopier
    implements MemberVisitor {
        private MyMemberOptimizationInfoCopier() {
        }

        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            ProgramField copiedField = (ProgramField)programField.getProcessingInfo();
            Object info = copiedField.getProcessingInfo();
            programField.setProcessingInfo(info instanceof ProgramFieldOptimizationInfo ? new ProgramFieldOptimizationInfo((ProgramFieldOptimizationInfo)info) : info);
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        }
    }
}

