/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class GotoReturnReplacer
implements InstructionVisitor {
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public GotoReturnReplacer(CodeAttributeEditor codeAttributeEditor) {
        this(codeAttributeEditor, null);
    }

    public GotoReturnReplacer(CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        if (opcode == -89 || opcode == -56) {
            int targetOffset = offset + branchInstruction.branchOffset;
            if (!this.codeAttributeEditor.isModified(offset) && !this.codeAttributeEditor.isModified(targetOffset)) {
                Instruction targetInstruction = InstructionFactory.create((byte[])codeAttribute.code, (int)targetOffset);
                switch (targetInstruction.opcode) {
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: {
                        SimpleInstruction returnInstruction = new SimpleInstruction(targetInstruction.opcode);
                        this.codeAttributeEditor.replaceInstruction(offset, (Instruction)returnInstruction);
                        if (this.extraInstructionVisitor == null) break;
                        this.extraInstructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, offset, branchInstruction);
                    }
                }
            }
        }
    }
}

