/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;

public class VariableAllocator
implements AttributeVisitor,
ParameterVisitor {
    private final boolean supportsInstructionPreloading;
    private int maxLocals = 0;
    private int localVariable = -1;
    private int instanceVariable = -1;
    private final InstructionSequenceBuilder builder;
    private final Map<Integer, Integer> originalOffsets = new HashMap<Integer, Integer>();
    private final Map<Integer, String> parameterTypes = new HashMap<Integer, String>();
    private final Map<Integer, Integer> newParameterVariables = new HashMap<Integer, Integer>();

    public VariableAllocator(ProgramClass programClass, ProgramMethod programMethod, boolean supportsInstructionPreloading) {
        this.supportsInstructionPreloading = supportsInstructionPreloading;
        if (programMethod != null) {
            programMethod.accept(programClass, (MemberVisitor)new AllParameterVisitor(false, (ParameterVisitor)this));
            programMethod.attributesAccept(programClass, (AttributeVisitor)this);
        }
        this.builder = new InstructionSequenceBuilder(programClass);
    }

    public int getLocalVariable() {
        if (this.localVariable == -1) {
            this.localVariable = this.maxLocals++;
        }
        return this.localVariable;
    }

    public boolean supportsInstructionPreloading() {
        return this.supportsInstructionPreloading;
    }

    public int getInstanceVariable() {
        if (!this.supportsInstructionPreloading()) {
            throw new IllegalStateException("Trying to get the instance variable but VariableAllocator can't support preloading.");
        }
        if (this.instanceVariable == -1) {
            this.instanceVariable = this.maxLocals++;
            this.builder.aload_0().astore(this.instanceVariable);
        }
        return this.instanceVariable;
    }

    public int getParameterVariable(int parameterIndex) {
        int newLocalOffset;
        if (!this.supportsInstructionPreloading()) {
            throw new IllegalStateException("Trying to get the parameter variable but VariableAllocator can't support preloading.");
        }
        if (!this.originalOffsets.containsKey(parameterIndex)) {
            throw new IllegalStateException("Trying to get the parameter for index " + parameterIndex + " but it does not exists.");
        }
        String parameterType = this.parameterTypes.get(parameterIndex);
        int parameterOffset = this.originalOffsets.get(parameterIndex);
        if (this.newParameterVariables.containsKey(parameterOffset)) {
            newLocalOffset = this.newParameterVariables.get(parameterOffset);
        } else {
            newLocalOffset = this.maxLocals;
            this.maxLocals += ClassUtil.isInternalCategory2Type((String)parameterType) ? 2 : 1;
            this.newParameterVariables.put(parameterOffset, newLocalOffset);
            char type = parameterType.charAt(0);
            switch (type) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.builder.iload(parameterOffset).istore(newLocalOffset);
                    break;
                }
                case 'J': {
                    this.builder.lload(parameterOffset).lstore(newLocalOffset);
                    break;
                }
                case 'F': {
                    this.builder.fload(parameterOffset).fstore(newLocalOffset);
                    break;
                }
                case 'D': {
                    this.builder.dload(parameterOffset).dstore(newLocalOffset);
                    break;
                }
                case 'L': 
                case '[': {
                    this.builder.aload(parameterOffset).astore(newLocalOffset);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot determine of parameter type with signature " + parameterType);
                }
            }
        }
        return newLocalOffset;
    }

    public int getNextGlobalVariable() {
        return this.maxLocals++;
    }

    public int getNextWideGlobalVariable() {
        int result = this.maxLocals;
        this.maxLocals += 2;
        return result;
    }

    public Instruction[] preloadInstructions() {
        return this.builder.instructions();
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.maxLocals = codeAttribute.u2maxLocals;
    }

    public void visitParameter(Clazz clazz, Member member, int parameterIndex, int parameterCount, int parameterOffset, int parameterSize, String parameterType, Clazz referencedClass) {
        boolean isStatic = (member.getAccessFlags() & 8) != 0;
        this.originalOffsets.put(parameterIndex, isStatic ? parameterOffset : parameterOffset + 1);
        this.parameterTypes.put(parameterIndex, parameterType);
    }
}

