/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin;

import proguard.AppView;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.kotlin.UnsupportedKotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataRemover;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.kotlin.KotlinMetadataInitializer;
import proguard.classfile.visitor.ClassVisitor;
import proguard.pass.Pass;

public class KotlinUnsupportedVersionChecker
implements Pass {
    @Override
    public void execute(AppView appView) throws Exception {
        ReferencedKotlinMetadataVisitor unsupportedMetadataChecker = new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new MyUnsupportedKotlinMetadataChecker());
        appView.programClassPool.classesAccept((ClassVisitor)unsupportedMetadataChecker);
        appView.libraryClassPool.classesAccept((ClassVisitor)unsupportedMetadataChecker);
    }

    private static class MyUnsupportedKotlinMetadataChecker
    implements KotlinMetadataVisitor {
        private MyUnsupportedKotlinMetadataChecker() {
        }

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        public void visitUnsupportedKotlinMetadata(Clazz clazz, UnsupportedKotlinMetadata kotlinMetadata) {
            if (kotlinMetadata.mv == null || kotlinMetadata.mv.length < 3 || !KotlinMetadataInitializer.isSupportedMetadataVersion((KotlinMetadataVersion)new KotlinMetadataVersion(kotlinMetadata.mv))) {
                throw new RuntimeException("Unsupported Kotlin metadata version found on class '" + clazz.getName() + "'." + System.lineSeparator() + "DexGuard currently supports Kotlin versions up to " + KotlinMetadataInitializer.MAX_SUPPORTED_VERSION.major + "." + KotlinMetadataInitializer.MAX_SUPPORTED_VERSION.minor + ".");
            }
            clazz.accept((ClassVisitor)new KotlinMetadataRemover());
        }
    }
}

