/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptMemberFilter;

public class DescriptorKeepChecker
implements MemberVisitor,
ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private Clazz referencingClass;
    private Member referencingMember;
    private boolean isField;

    public DescriptorKeepChecker(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List keepSpecifications) {
        this.programClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        this.libraryClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = new KeepClassSpecificationVisitorFactory(true, true, true).createClassPoolVisitor(keepSpecifications, (ClassVisitor)keepMarker, (MemberVisitor)keepMarker, (MemberVisitor)keepMarker, null);
        this.programClassPool.accept(classPoolvisitor);
        this.libraryClassPool.accept(classPoolvisitor);
        this.programClassPool.classesAccept((ClassVisitor)new AllMemberVisitor((MemberVisitor)new KeptMemberFilter(this)));
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.referencingClass = programClass;
        this.referencingMember = programMethod;
        this.isField = false;
        Clazz[] referencedClasses = programMethod.referencedClasses;
        if (referencedClasses != null) {
            int count = referencedClasses.length;
            if (ClassUtil.isInternalClassType((String)programMethod.getDescriptor((Clazz)programClass))) {
                --count;
            }
            for (int index = 0; index < count; ++index) {
                if (referencedClasses[index] == null) continue;
                referencedClasses[index].accept((ClassVisitor)this);
            }
        }
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (!KeepMarker.isKept((Clazz)programClass)) {
            this.notePrinter.print(this.referencingClass.getName(), programClass.getName(), "Note: the configuration keeps the entry point '" + ClassUtil.externalClassName((String)this.referencingClass.getName()) + " { " + (this.isField ? ClassUtil.externalFullFieldDescription((int)0, (String)this.referencingMember.getName(this.referencingClass), (String)this.referencingMember.getDescriptor(this.referencingClass)) : ClassUtil.externalFullMethodDescription((String)this.referencingClass.getName(), (int)0, (String)this.referencingMember.getName(this.referencingClass), (String)this.referencingMember.getDescriptor(this.referencingClass))) + "; }', but not the descriptor class '" + ClassUtil.externalClassName((String)programClass.getName()) + "'");
        }
    }
}

