/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.classfile.io.visitor.ProcessingFlagDataEntryFilter;
import proguard.classfile.util.ClassUtil;
import proguard.configuration.InitialStateInfo;
import proguard.io.ClassFilter;
import proguard.io.ClassMapDataEntryReplacer;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryDirectoryFilter;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryFilter;
import proguard.io.ExtraDataEntryNameMap;
import proguard.io.ExtraDataEntryReader;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.IdleRewriter;
import proguard.io.ManifestRewriter;
import proguard.io.NameFilteredDataEntryReader;
import proguard.io.NameFilteredDataEntryWriter;
import proguard.io.NonClosingDataEntryWriter;
import proguard.io.RenamedDataEntryReader;
import proguard.io.RenamedDataEntryWriter;
import proguard.io.UniqueDataEntryWriter;
import proguard.pass.Pass;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.util.ResourceFilePoolNameFunction;
import proguard.resources.kotlinmodule.io.KotlinModuleDataEntryWriter;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.MapStringFunction;
import proguard.util.StringFunction;
import proguard.util.StringMatcher;
import proguard.util.StringParser;

public class OutputWriter
implements Pass {
    private static final Logger logger = LogManager.getLogger(OutputWriter.class);
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws IOException {
        logger.info("Writing output...");
        if (this.configuration.addConfigurationDebugging) {
            logger.error("Warning: -addconfigurationdebugging is enabled; the resulting build will contain obfuscation information.");
            logger.error("It should only be used for debugging purposes.");
        }
        ClassPath programJars = this.configuration.programJars;
        StringMatcher uncompressedFilter = this.configuration.dontCompress == null ? null : new ListParser((StringParser)new FileNameParser()).parse(this.configuration.dontCompress);
        KeyStore.PrivateKeyEntry[] privateKeyEntries = this.retrievePrivateKeys(this.configuration);
        Date currentDate = new Date();
        int modificationTime = currentDate.getYear() - 80 << 25 | currentDate.getMonth() + 1 << 21 | currentDate.getDate() << 16 | currentDate.getHours() << 11 | currentDate.getMinutes() << 5 | currentDate.getSeconds() >> 1;
        DataEntryWriterFactory dataEntryWriterFactory = new DataEntryWriterFactory(appView.programClassPool, appView.resourceFilePool, modificationTime, uncompressedFilter, this.configuration.zipAlign, this.configuration.android, this.configuration.obfuscate, privateKeyEntries);
        UniqueDataEntryWriter extraDataEntryWriter = null;
        if (this.configuration.extraJar != null) {
            ClassPath extraClassPath = new ClassPath();
            extraClassPath.add(new ClassPathEntry(this.configuration.extraJar, true));
            OutputWriter.log(extraClassPath, 0, 1, privateKeyEntries);
            extraDataEntryWriter = new UniqueDataEntryWriter(dataEntryWriterFactory.createDataEntryWriter(extraClassPath, 0, 1, null));
        }
        int firstInputIndex = 0;
        int lastInputIndex = 0;
        for (int index = 0; index < programJars.size(); ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput()) {
                lastInputIndex = index;
                continue;
            }
            int nextIndex = index + 1;
            if (nextIndex != programJars.size() && programJars.get(nextIndex).isOutput()) continue;
            OutputWriter.log(programJars, lastInputIndex + 1, nextIndex, privateKeyEntries);
            this.writeOutput(dataEntryWriterFactory, this.configuration, appView.programClassPool, appView.initialStateInfo, appView.resourceFilePool, (DataEntryWriter)(extraDataEntryWriter != null ? new NonClosingDataEntryWriter((DataEntryWriter)extraDataEntryWriter) : null), appView.extraDataEntryNameMap, programJars, firstInputIndex, lastInputIndex + 1, nextIndex);
            firstInputIndex = nextIndex;
        }
        if (extraDataEntryWriter != null) {
            extraDataEntryWriter.close();
        }
    }

    private KeyStore.PrivateKeyEntry[] retrievePrivateKeys(Configuration configuration) throws IOException {
        List<File> keyStoreFiles = configuration.keyStores;
        List<String> keyStorePasswords = configuration.keyStorePasswords;
        List<String> keyAliases = configuration.keyAliases;
        List<String> keyPasswords = configuration.keyPasswords;
        if (keyStoreFiles == null || keyStorePasswords == null || keyAliases == null || keyPasswords == null) {
            return null;
        }
        try {
            int keyCount = Math.max(keyStoreFiles.size(), keyAliases.size());
            KeyStore.PrivateKeyEntry[] privateKeys = new KeyStore.PrivateKeyEntry[keyCount];
            HashMap<X509Certificate, Integer> certificates = new HashMap<X509Certificate, Integer>(keyCount);
            for (int index = 0; index < keyCount; ++index) {
                String keyPassword;
                String keyAlias;
                String keyStorePassword;
                File keyStoreFile = keyStoreFiles.get(Math.min(index, keyStoreFiles.size() - 1));
                KeyStore.PrivateKeyEntry privateKeyEntry = this.retrievePrivateKey(keyStoreFile, keyStorePassword = keyStorePasswords.get(Math.min(index, keyStorePasswords.size() - 1)), keyAlias = keyAliases.get(Math.min(index, keyAliases.size() - 1)), keyPassword = keyPasswords.get(Math.min(index, keyPasswords.size() - 1)));
                X509Certificate certificate = (X509Certificate)privateKeyEntry.getCertificate();
                Integer duplicateIndex = certificates.put(certificate, index);
                if (duplicateIndex != null) {
                    throw new IllegalArgumentException("Duplicate specified signing certificates #" + (duplicateIndex + 1) + " and #" + (index + 1) + " out of " + keyCount + " [" + certificate.getSubjectDN().getName() + "]");
                }
                privateKeys[index] = privateKeyEntry;
            }
            return privateKeys;
        }
        catch (Exception e) {
            throw new IOException("Can't sign jar (" + e.getMessage() + ")", e);
        }
    }

    private KeyStore.PrivateKeyEntry retrievePrivateKey(File keyStoreFile, String keyStorePassword, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        FileInputStream keyStoreInputStream = new FileInputStream(keyStoreFile);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
        keyStoreInputStream.close();
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(keyPassword.toCharArray());
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, protectionParameter);
        if (entry == null) {
            throw new GeneralSecurityException("Can't find key alias '" + keyAlias + "' in key store [" + keyStoreFile.getPath() + "]");
        }
        return entry;
    }

    private void writeOutput(DataEntryWriterFactory dataEntryWriterFactory, Configuration configuration, ClassPool programClassPool, InitialStateInfo initialStateInfo, ResourceFilePool resourceFilePool, DataEntryWriter extraDataEntryWriter, ExtraDataEntryNameMap extraDataEntryNameMap, ClassPath classPath, int fromInputIndex, int fromOutputIndex, int toOutputIndex) throws IOException {
        try {
            DataEntryCopier resourceCopier;
            DataEntryWriter writer;
            DataEntryWriter resourceWriter = writer = dataEntryWriterFactory.createDataEntryWriter(classPath, fromOutputIndex, toOutputIndex, null);
            if (configuration.obfuscate && configuration.adaptResourceFileNames != null) {
                resourceWriter = this.renameResourceFiles(resourceFilePool, resourceWriter);
            }
            if (configuration.keepKotlinMetadata && (configuration.shrink || configuration.obfuscate)) {
                resourceWriter = new NameFilteredDataEntryWriter("META-INF/*.kotlin_module", (DataEntryWriter)new FilteredDataEntryWriter((DataEntryFilter)new ProcessingFlagDataEntryFilter(resourceFilePool, 0, 8192), (DataEntryWriter)new KotlinModuleDataEntryWriter(resourceFilePool, resourceWriter)), resourceWriter);
            }
            DataEntryCopier resourceRewriter = resourceCopier = new DataEntryCopier(resourceWriter);
            if ((configuration.shrink || configuration.optimize || configuration.obfuscate) && configuration.adaptResourceFileContents != null) {
                DataEntryCopier adaptingContentWriter = resourceRewriter;
                if (configuration.obfuscate) {
                    adaptingContentWriter = this.adaptResourceFiles(configuration, programClassPool, resourceWriter);
                }
                resourceRewriter = new NameFilteredDataEntryReader(configuration.adaptResourceFileContents, (DataEntryReader)adaptingContentWriter, (DataEntryReader)resourceRewriter);
            }
            Object reader = this.writeDirectories(configuration, programClassPool, (DataEntryReader)resourceCopier, (DataEntryReader)resourceRewriter);
            reader = this.writeExtraConfigurationFiles(configuration, programClassPool, initialStateInfo, extraDataEntryNameMap, (DataEntryReader)reader, extraDataEntryWriter != null ? extraDataEntryWriter : writer);
            ClassFilter classReader = new ClassFilter((DataEntryReader)new IdleRewriter(writer), (DataEntryReader)reader);
            ClassFilter extraClassReader = extraDataEntryWriter != null ? new ClassFilter((DataEntryReader)new IdleRewriter(extraDataEntryWriter), (DataEntryReader)reader) : classReader;
            reader = new ExtraDataEntryReader(extraDataEntryNameMap, (DataEntryReader)classReader, (DataEntryReader)extraClassReader);
            new InputReader(configuration).readInput("  Copying resources from program ", classPath, fromInputIndex, fromOutputIndex, (DataEntryReader)reader);
            writer.close();
        }
        catch (IOException ex) {
            String message = "Can't write [" + classPath.get(fromOutputIndex).getName() + "] (" + ex.getMessage() + ")";
            throw new IOException(message, ex);
        }
    }

    private DataEntryReader writeExtraConfigurationFiles(Configuration configuration, ClassPool programClassPool, InitialStateInfo initialStateInfo, ExtraDataEntryNameMap extraDataEntryNameMap, DataEntryReader resourceCopier, DataEntryWriter extraFileWriter) {
        if (configuration.addConfigurationDebugging) {
            extraDataEntryNameMap.addExtraDataEntry("classmap.txt");
            resourceCopier = new NameFilteredDataEntryReader("classmap.txt", (DataEntryReader)new ClassMapDataEntryReplacer(programClassPool, initialStateInfo, extraFileWriter), resourceCopier);
        }
        return resourceCopier;
    }

    private DataEntryWriter renameResourceFiles(ResourceFilePool resourceFilePool, DataEntryWriter dataEntryWriter) {
        return new FilteredDataEntryWriter((DataEntryFilter)new DataEntryDirectoryFilter(), dataEntryWriter, (DataEntryWriter)new RenamedDataEntryWriter((StringFunction)new ResourceFilePoolNameFunction(resourceFilePool), dataEntryWriter));
    }

    private DataEntryReader adaptResourceFiles(Configuration configuration, ClassPool programClassPool, DataEntryWriter writer) {
        Charset charset = configuration.android ? StandardCharsets.UTF_8 : Charset.defaultCharset();
        return new NameFilteredDataEntryReader("META-INF/MANIFEST.MF,META-INF/*.SF", (DataEntryReader)new ManifestRewriter(programClassPool, charset, writer), (DataEntryReader)new DataEntryRewriter(programClassPool, charset, writer));
    }

    private DirectoryFilter writeDirectories(Configuration configuration, ClassPool programClassPool, DataEntryReader directoryCopier, DataEntryReader fileCopier) {
        NameFilteredDataEntryReader directoryRewriter = null;
        if (configuration.keepDirectories != null) {
            MapStringFunction packagePrefixFunction = new MapStringFunction(OutputWriter.createPackagePrefixMap(programClassPool));
            directoryRewriter = new NameFilteredDataEntryReader(configuration.keepDirectories, (DataEntryReader)new RenamedDataEntryReader((StringFunction)packagePrefixFunction, directoryCopier, directoryCopier));
        }
        return new DirectoryFilter(directoryRewriter, fileCopier);
    }

    private static Map<String, String> createPackagePrefixMap(ClassPool classPool) {
        HashMap<String, String> packagePrefixMap = new HashMap<String, String>();
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            String packagePrefix = ClassUtil.internalPackagePrefix((String)className);
            String mappedNewPackagePrefix = (String)packagePrefixMap.get(packagePrefix);
            if (mappedNewPackagePrefix != null && mappedNewPackagePrefix.equals(packagePrefix)) continue;
            String newClassName = classPool.getClass(className).getName();
            String newPackagePrefix = ClassUtil.internalPackagePrefix((String)newClassName);
            packagePrefixMap.put(packagePrefix, newPackagePrefix);
        }
        return packagePrefixMap;
    }

    private static void log(ClassPath classPath, int fromIndex, int toIndex, KeyStore.PrivateKeyEntry[] privateKeyEntries) {
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            ClassPathEntry classPathEntry = classPath.get(index);
            List<String> filter = DataEntryReaderFactory.getFilterExcludingVersionedClasses(classPathEntry);
            logger.info("Preparing {}output {} [{}]{}", (Object)(privateKeyEntries == null ? "" : "signed "), (Object)(classPathEntry.isDex() ? "dex" : (classPathEntry.isApk() ? "apk" : (classPathEntry.isAab() ? "aab" : (classPathEntry.isJar() ? "jar" : (classPathEntry.isAar() ? "aar" : (classPathEntry.isWar() ? "war" : (classPathEntry.isEar() ? "ear" : (classPathEntry.isJmod() ? "jmod" : (classPathEntry.isZip() ? "zip" : "directory"))))))))), (Object)classPathEntry.getName(), (Object)(filter != null || classPathEntry.isFiltered() ? " (filtered)" : ""));
        }
    }
}

