/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.ClassObfuscator;

public class OriginalClassNameFilter
implements ClassVisitor {
    private final ClassVisitor acceptedClassVisitor;
    private final ClassVisitor rejectedClassVisitor;

    public OriginalClassNameFilter(ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisitor) {
        this.acceptedClassVisitor = acceptedClassVisitor;
        this.rejectedClassVisitor = rejectedClassVisitor;
    }

    public void visitAnyClass(Clazz clazz) {
        ClassVisitor delegateVisitor = this.selectVisitor(clazz);
        if (delegateVisitor != null) {
            clazz.accept(delegateVisitor);
        }
    }

    private ClassVisitor selectVisitor(Clazz clazz) {
        return ClassObfuscator.hasOriginalClassName(clazz) ? this.acceptedClassVisitor : this.rejectedClassVisitor;
    }
}

