/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.ConstantValueFactory;
import proguard.evaluation.value.InitialValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.info.FieldOptimizationInfo;

public class ProgramFieldOptimizationInfo
extends FieldOptimizationInfo
implements AttributeVisitor {
    private static final ValueFactory VALUE_FACTORY = new ParticularValueFactory();
    private static final ConstantValueFactory CONSTANT_VALUE_FACTORY = new ConstantValueFactory(VALUE_FACTORY);
    private static final InitialValueFactory INITIAL_VALUE_FACTORY = new InitialValueFactory(VALUE_FACTORY);
    private volatile boolean isWritten;
    private volatile boolean isRead;
    private volatile boolean canBeMadePrivate = true;
    private final boolean alwaysInitializeValue;
    private volatile ReferenceValue referencedClass;

    public ProgramFieldOptimizationInfo(Clazz clazz, Field field, boolean alwaysInitializeValue) {
        int accessFlags = field.getAccessFlags();
        this.isRead = (accessFlags & 0x40) != 0;
        this.isWritten = this.isRead;
        this.alwaysInitializeValue = alwaysInitializeValue;
        this.resetValue(clazz, field);
    }

    public ProgramFieldOptimizationInfo(ProgramFieldOptimizationInfo programFieldOptimizationInfo) {
        this.value = programFieldOptimizationInfo.value;
        this.isWritten = programFieldOptimizationInfo.isWritten;
        this.isRead = programFieldOptimizationInfo.isRead;
        this.canBeMadePrivate = programFieldOptimizationInfo.canBeMadePrivate;
        this.alwaysInitializeValue = programFieldOptimizationInfo.alwaysInitializeValue;
        this.referencedClass = programFieldOptimizationInfo.referencedClass;
    }

    @Override
    public boolean isKept() {
        return false;
    }

    public void setWritten() {
        this.isWritten = true;
    }

    @Override
    public boolean isWritten() {
        return this.isWritten;
    }

    public void setRead() {
        this.isRead = true;
    }

    @Override
    public boolean isRead() {
        return this.isRead;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    @Override
    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public synchronized void generalizeReferencedClass(ReferenceValue referencedClass) {
        this.referencedClass = this.referencedClass != null ? this.referencedClass.generalize(referencedClass) : referencedClass;
    }

    @Override
    public ReferenceValue getReferencedClass() {
        return this.referencedClass;
    }

    public void resetValue(Clazz clazz, Field field) {
        int accessFlags = field.getAccessFlags();
        this.value = null;
        if ((accessFlags & 8) != 0) {
            field.accept(clazz, (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)this));
        }
        if (this.value == null && (this.alwaysInitializeValue || !ClassUtil.isInternalPrimitiveType((String)field.getDescriptor(clazz)) || (accessFlags & 0x10) == 0)) {
            this.value = INITIAL_VALUE_FACTORY.createValue(field.getDescriptor(clazz));
        }
    }

    public synchronized void generalizeValue(Value value) {
        this.value = this.value != null ? this.value.generalize(value) : value;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.value = CONSTANT_VALUE_FACTORY.constantValue(clazz, constantValueAttribute.u2constantValueIndex);
    }

    public static void setProgramFieldOptimizationInfo(Clazz clazz, Field field, boolean optimizeConservatively) {
        field.setProcessingInfo((Object)new ProgramFieldOptimizationInfo(clazz, field, optimizeConservatively));
    }

    public static ProgramFieldOptimizationInfo getProgramFieldOptimizationInfo(Field field) {
        return (ProgramFieldOptimizationInfo)field.getProcessingInfo();
    }
}

