/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.NameFactory;
import proguard.util.Processable;
import proguard.util.SimpleProcessable;

public class MemberObfuscator
implements MemberVisitor {
    private final boolean allowAggressiveOverloading;
    private final NameFactory nameFactory;
    private final Map descriptorMap;

    public MemberObfuscator(boolean allowAggressiveOverloading, NameFactory nameFactory, Map descriptorMap) {
        this.allowAggressiveOverloading = allowAggressiveOverloading;
        this.nameFactory = nameFactory;
        this.descriptorMap = descriptorMap;
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        String name = member.getName(clazz);
        if (ClassUtil.isInitializer((String)name)) {
            return;
        }
        String descriptor = member.getDescriptor(clazz);
        if (!this.allowAggressiveOverloading || clazz.extendsOrImplements("java/lang/annotation/Annotation")) {
            descriptor = descriptor.substring(0, descriptor.indexOf(41) + 1);
        }
        Map nameMap = MemberObfuscator.retrieveNameMap(this.descriptorMap, descriptor);
        String newName = MemberObfuscator.newMemberName(member);
        if (newName == null) {
            this.nameFactory.reset();
            while (nameMap.containsKey(newName = this.nameFactory.nextName())) {
            }
            nameMap.put(newName, name);
            MemberObfuscator.setNewMemberName(member, newName);
        }
    }

    static Map retrieveNameMap(Map descriptorMap, String descriptor) {
        HashMap nameMap = (HashMap)descriptorMap.get(descriptor);
        if (nameMap == null) {
            nameMap = new HashMap();
            descriptorMap.put(descriptor, nameMap);
        }
        return nameMap;
    }

    public static void setFixedNewMemberName(Member member, String name) {
        Processable lastProcessable = MethodLinker.lastProcessable((Processable)member);
        if (!(lastProcessable instanceof LibraryMember) && !(lastProcessable instanceof MyFixedName)) {
            lastProcessable.setProcessingInfo((Object)new MyFixedName(name));
        } else {
            lastProcessable.setProcessingInfo((Object)name);
        }
    }

    public static void setNewMemberName(Member member, String name) {
        MethodLinker.lastProcessable((Processable)member).setProcessingInfo((Object)name);
    }

    static boolean hasFixedNewMemberName(Member member) {
        Processable lastProcessable = MethodLinker.lastProcessable((Processable)member);
        return lastProcessable instanceof LibraryMember || lastProcessable instanceof MyFixedName;
    }

    public static String newMemberName(Member member) {
        return (String)MethodLinker.lastProcessable((Processable)member).getProcessingInfo();
    }

    private static class MyFixedName
    extends SimpleProcessable {
        public MyFixedName(String newName) {
            super(0, (Object)newName);
        }
    }
}

