/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Arrays;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberInfoBlock;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllLineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberRangeFinder;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.pass.Pass;

public class LineNumberLinearizer
implements Pass,
ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private static final Logger logger = LogManager.getLogger(LineNumberLinearizer.class);
    public static final int SHIFT_ROUNDING = 1000;
    private static final int SHIFT_ROUNDING_LIMIT = 50000;
    private final Stack<MyLineNumberBlock> enclosingLineNumbers = new Stack();
    private LineNumberInfo previousLineNumberInfo;
    private int highestUsedLineNumber;
    private int currentLineNumberShift;

    @Override
    public void execute(AppView appView) {
        appView.programClassPool.classesAccept((ClassVisitor)this);
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        LineNumberRangeFinder lineNumberRangeFinder = new LineNumberRangeFinder();
        programClass.methodsAccept((MemberVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new AllLineNumberInfoVisitor((LineNumberInfoVisitor)lineNumberRangeFinder)));
        if (lineNumberRangeFinder.hasSource()) {
            this.highestUsedLineNumber = lineNumberRangeFinder.getHighestLineNumber();
            programClass.methodsAccept((MemberVisitor)this);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, (AttributeVisitor)this);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        logger.debug("LineNumberLinearizer [{}.{}{}]:", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        this.enclosingLineNumbers.clear();
        LineNumberInfo[] infos = lineNumberTableAttribute.lineNumberTable;
        int lineNumberTableLength = lineNumberTableAttribute.u2lineNumberTableLength;
        boolean[] inlinedBlock = new boolean[lineNumberTableLength];
        int currentDepth = 0;
        for (int i = 0; i < lineNumberTableLength; ++i) {
            LineNumberInfo currentInfo = infos[i];
            if (currentInfo.u2lineNumber == -2) {
                ++currentDepth;
            }
            boolean bl = inlinedBlock[i] = currentDepth > 0;
            if (currentInfo.u2lineNumber != -1) continue;
            --currentDepth;
        }
        LineNumberInfo previousLineNumberInfo = null;
        for (int i = 0; i < lineNumberTableLength; ++i) {
            LineNumberInfo lineNumberInfo = infos[i];
            String source = lineNumberInfo.getSource();
            logger.debug("    [{}] line {}{}", (Object)lineNumberInfo.u2startPC, (Object)lineNumberInfo.u2lineNumber, (Object)(source == null ? "" : " [" + source + "]"));
            if (source != null && inlinedBlock[i]) {
                int lineNumber = lineNumberInfo.u2lineNumber;
                if (lineNumber == -2) {
                    this.enclosingLineNumbers.push(previousLineNumberInfo != null ? new MyLineNumberBlock(this.currentLineNumberShift, previousLineNumberInfo.u2lineNumber, previousLineNumberInfo.getSource() != null ? previousLineNumberInfo.getBlock() : null) : new MyLineNumberBlock(0, 0, null));
                    int separatorIndex1 = source.indexOf(58);
                    int separatorIndex2 = source.indexOf(58, separatorIndex1 + 1);
                    int startLineNumber = Integer.parseInt(source.substring(separatorIndex1 + 1, separatorIndex2));
                    int endLineNumber = Integer.parseInt(source.substring(separatorIndex2 + 1));
                    startLineNumber = 0;
                    endLineNumber = 0;
                    this.currentLineNumberShift = this.highestUsedLineNumber > 50000 ? this.highestUsedLineNumber - startLineNumber + 1 : (startLineNumber > this.highestUsedLineNumber ? 0 : (this.highestUsedLineNumber - startLineNumber + 1000) / 1000 * 1000);
                    this.highestUsedLineNumber = endLineNumber + this.currentLineNumberShift;
                    logger.debug(" (enter with shift {})", (Object)this.currentLineNumberShift);
                } else if (lineNumber == -1) {
                    if (this.enclosingLineNumbers.isEmpty()) {
                        logger.debug("Problem linearizing line numbers for optimized code ({}.{})", (Object)clazz.getName(), (Object)method.getName(clazz));
                    } else {
                        MyLineNumberBlock lineNumberBlock = this.enclosingLineNumbers.pop();
                        infos[i] = lineNumberInfo = lineNumberBlock.enclosingSource != null ? lineNumberBlock.enclosingSource.line(lineNumberInfo.u2startPC, lineNumberBlock.enclosingLineNumber) : new LineNumberInfo(lineNumberInfo.u2startPC, lineNumberBlock.enclosingLineNumber);
                        this.currentLineNumberShift = lineNumberBlock.lineNumberShift;
                        logger.debug(" (exit to shift {})", (Object)this.currentLineNumberShift);
                    }
                } else {
                    logger.debug(" (apply shift {})", (Object)this.currentLineNumberShift);
                    lineNumberInfo.u2lineNumber += this.currentLineNumberShift;
                }
            }
            previousLineNumberInfo = lineNumberInfo;
            logger.debug(" -> line {}", (Object)lineNumberInfo.u2lineNumber);
        }
        lineNumberTableAttribute.lineNumberTable = (LineNumberInfo[])Arrays.stream(infos, 0, lineNumberTableLength).filter(info -> info.u2lineNumber != -2).toArray(LineNumberInfo[]::new);
        lineNumberTableAttribute.u2lineNumberTableLength = lineNumberTableAttribute.lineNumberTable.length;
    }

    private static class MyLineNumberBlock {
        public final int lineNumberShift;
        public final int enclosingLineNumber;
        public final LineNumberInfoBlock enclosingSource;

        public MyLineNumberBlock(int lineNumberShift, int enclosingLineNumber, LineNumberInfoBlock enclosingSource) {
            this.lineNumberShift = lineNumberShift;
            this.enclosingLineNumber = enclosingLineNumber;
            this.enclosingSource = enclosingSource;
        }
    }
}

