/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.Metrics;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.BootstrapMethodsAttributeEditor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ExceptionsAttributeEditor;
import proguard.classfile.editor.InnerClassesAttributeEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.dexfile.converter.Dex2IRConverter;
import proguard.dexfile.converter.DexFix;
import proguard.dexfile.converter.IR2ProConverter;
import proguard.dexfile.ir.IrMethod;
import proguard.dexfile.ir.ts.AggTransformer;
import proguard.dexfile.ir.ts.CleanLabel;
import proguard.dexfile.ir.ts.ExceptionHandlerTrim;
import proguard.dexfile.ir.ts.Ir2JRegAssignTransformer;
import proguard.dexfile.ir.ts.MultiArrayTransformer;
import proguard.dexfile.ir.ts.NewTransformer;
import proguard.dexfile.ir.ts.RemoveConstantFromSSA;
import proguard.dexfile.ir.ts.RemoveLocalFromSSA;
import proguard.dexfile.ir.ts.TypeTransformer;
import proguard.dexfile.ir.ts.UnSSATransformer;
import proguard.dexfile.ir.ts.VoidInvokeTransformer;
import proguard.dexfile.ir.ts.ZeroTransformer;
import proguard.dexfile.reader.DexType;
import proguard.dexfile.reader.Field;
import proguard.dexfile.reader.Method;
import proguard.dexfile.reader.MethodHandle;
import proguard.dexfile.reader.Proto;
import proguard.dexfile.reader.Visibility;
import proguard.dexfile.reader.node.DexAnnotationNode;
import proguard.dexfile.reader.node.DexClassNode;
import proguard.dexfile.reader.node.DexFieldNode;
import proguard.dexfile.reader.node.DexFileNode;
import proguard.dexfile.reader.node.DexMethodNode;

public class Dex2Pro {
    private static final int MAX_PHI_LABELS = Integer.parseInt(System.getProperty("proguard.dexconversion.maxphilabels", "0"));
    private static final int MAX_CODE_LENGTH = Integer.parseInt(System.getProperty("proguard.dexconversion.maxcodelength", "10000"));
    private static final boolean SKIP_UNPARSEABLE_METHODS = System.getProperty("proguard.dexconversion.skip_unparseable_methods") != null;
    private static final int MAX_STATEMENTS = Integer.parseInt(System.getProperty("proguard.dexconversion.maxstatements", "0"));
    private boolean usePrimitiveArrayConstants = false;
    private static final int ACC_INTERFACE_ABSTRACT = 1536;
    private static final int NO_CODE_MASK = 9472;
    private static final CleanLabel T_cleanLabel = new CleanLabel();
    private static final Ir2JRegAssignTransformer T_ir2jRegAssign = new Ir2JRegAssignTransformer();
    private static final NewTransformer T_new = new NewTransformer();
    private static final RemoveConstantFromSSA T_removeConst = new RemoveConstantFromSSA();
    private static final RemoveLocalFromSSA T_removeLocal = new RemoveLocalFromSSA();
    private static final ExceptionHandlerTrim T_trimEx = new ExceptionHandlerTrim();
    private static final TypeTransformer T_type = new TypeTransformer();
    private static final AggTransformer T_agg = new AggTransformer();
    private static final UnSSATransformer T_unssa = new UnSSATransformer();
    private static final ZeroTransformer T_zero = new ZeroTransformer();
    private static final VoidInvokeTransformer T_voidInvoke = new VoidInvokeTransformer();
    private static final MultiArrayTransformer T_multiArray = new MultiArrayTransformer();
    private static final Comparator<InnerClassNode> INNER_CLASS_NODE_COMPARATOR = Comparator.comparing(o -> InnerClassNode.access$800(o));

    private static int clearClassAccess(boolean isInner, int access) {
        if ((access & 0x200) == 0) {
            access |= 0x20;
        }
        if (isInner && ((access &= 0xFFFFFFF5) & 4) != 0) {
            access &= 0xFFFFFFFB;
            access |= 1;
        }
        access &= 0xFFFDFFFF;
        return access &= 0xFFFFEFFF;
    }

    private static int clearInnerAccess(int access) {
        if (0 != ((access &= 0xFFFFFFDF) & 2)) {
            access &= 0xFFFFFFFA;
        } else if (0 != (access & 4)) {
            access &= 0xFFFFFFFE;
        }
        return access &= 0xFFFFEFFF;
    }

    private static String toInternalName(DexType type) {
        return Dex2Pro.toInternalName(type.desc);
    }

    private static String toInternalName(String desc) {
        return ClassUtil.internalClassNameFromClassType((String)desc);
    }

    private static void convertAnnotations(List<DexAnnotationNode> anns, ProgramClass programClass, ConstantPoolEditor constantPoolEditor) {
        Dex2Pro.convertAnnotations(anns, constantPoolEditor, new AttributesEditor(programClass, false));
    }

    private static void convertAnnotations(List<DexAnnotationNode> anns, ProgramClass programClass, ConstantPoolEditor constantPoolEditor, ProgramField programField) {
        Dex2Pro.convertAnnotations(anns, constantPoolEditor, new AttributesEditor(programClass, (ProgramMember)programField, false));
    }

    private static void convertAnnotations(List<DexAnnotationNode> anns, ProgramClass programClass, ConstantPoolEditor constantPoolEditor, ProgramMethod programMethod) {
        Dex2Pro.convertAnnotations(anns, constantPoolEditor, new AttributesEditor(programClass, (ProgramMember)programMethod, false));
    }

    private static void convertAnnotations(List<DexAnnotationNode> anns, ConstantPoolEditor constantPoolEditor, AttributesEditor attributesEditor) {
        Dex2Pro.convertAnnotations(Visibility.BUILD, anns, constantPoolEditor, attributesEditor);
        Dex2Pro.convertAnnotations(Visibility.RUNTIME, anns, constantPoolEditor, attributesEditor);
    }

    private static void convertAnnotations(Visibility visibility, List<DexAnnotationNode> anns, ConstantPoolEditor constantPoolEditor, AttributesEditor attributesEditor) {
        if (!(anns = anns.stream().filter(ann -> ann.visibility == visibility).collect(Collectors.toList())).isEmpty()) {
            Annotation[] annotations = new Annotation[anns.size()];
            for (int index = 0; index < anns.size(); ++index) {
                DexAnnotationNode dexAnnotationNode = anns.get(index);
                annotations[index] = Dex2Pro.convertAnnotation(dexAnnotationNode, constantPoolEditor);
            }
            RuntimeInvisibleAnnotationsAttribute annotationsAttribute = visibility == Visibility.BUILD ? new RuntimeInvisibleAnnotationsAttribute(constantPoolEditor.addUtf8Constant("RuntimeInvisibleAnnotations"), annotations.length, annotations) : new RuntimeVisibleAnnotationsAttribute(constantPoolEditor.addUtf8Constant("RuntimeVisibleAnnotations"), annotations.length, annotations);
            attributesEditor.addAttribute((Attribute)annotationsAttribute);
        }
    }

    private static void convertParameterAnnotations(List<DexAnnotationNode>[] anns, ProgramClass programClass, ConstantPoolEditor constantPoolEditor, ProgramMethod programMethod) {
        AttributesEditor attributesEditor = new AttributesEditor(programClass, (ProgramMember)programMethod, false);
        Dex2Pro.convertParameterAnnotations(Visibility.BUILD, anns, constantPoolEditor, attributesEditor);
        Dex2Pro.convertParameterAnnotations(Visibility.RUNTIME, anns, constantPoolEditor, attributesEditor);
    }

    private static void convertParameterAnnotations(Visibility visibility, List<DexAnnotationNode>[] anns, ConstantPoolEditor constantPoolEditor, AttributesEditor attributesEditor) {
        List[] filteredAnns = new List[anns.length];
        for (int index = 0; index < anns.length; ++index) {
            List<DexAnnotationNode> parameterAnns = anns[index];
            filteredAnns[index] = parameterAnns != null ? parameterAnns.stream().filter(ann -> ann.visibility == visibility).collect(Collectors.toList()) : Collections.emptyList();
        }
        if (Dex2Pro.hasAnnotations(filteredAnns)) {
            int[] annotationsCount = new int[filteredAnns.length];
            Annotation[][] annotations = new Annotation[filteredAnns.length][];
            for (int parameterIndex = 0; parameterIndex < filteredAnns.length; ++parameterIndex) {
                List dexAnnotationNodes = filteredAnns[parameterIndex];
                annotationsCount[parameterIndex] = dexAnnotationNodes.size();
                annotations[parameterIndex] = new Annotation[dexAnnotationNodes.size()];
                for (int index = 0; index < dexAnnotationNodes.size(); ++index) {
                    annotations[parameterIndex][index] = Dex2Pro.convertAnnotation((DexAnnotationNode)dexAnnotationNodes.get(index), constantPoolEditor);
                }
            }
            RuntimeInvisibleParameterAnnotationsAttribute annotationsAttribute = visibility == Visibility.BUILD ? new RuntimeInvisibleParameterAnnotationsAttribute(constantPoolEditor.addUtf8Constant("RuntimeInvisibleParameterAnnotations"), annotations.length, annotationsCount, (Annotation[][])annotations) : new RuntimeVisibleParameterAnnotationsAttribute(constantPoolEditor.addUtf8Constant("RuntimeVisibleParameterAnnotations"), annotations.length, annotationsCount, (Annotation[][])annotations);
            attributesEditor.addAttribute((Attribute)annotationsAttribute);
        }
    }

    private static boolean hasAnnotations(List<DexAnnotationNode>[] anns) {
        for (List<DexAnnotationNode> ann : anns) {
            if (ann.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static Annotation convertAnnotation(DexAnnotationNode dexAnnotationNode, ConstantPoolEditor constantPoolEditor) {
        ElementValue[] elementValues = Dex2Pro.convertElementValues(dexAnnotationNode.items, constantPoolEditor);
        return new Annotation(constantPoolEditor.addUtf8Constant(dexAnnotationNode.type), elementValues.length, elementValues);
    }

    private static ElementValue[] convertElementValues(List<DexAnnotationNode.Item> items, ConstantPoolEditor cpe) {
        ElementValue[] elementValues = new ElementValue[items.size()];
        for (int index = 0; index < items.size(); ++index) {
            DexAnnotationNode.Item item = items.get(index);
            elementValues[index] = Dex2Pro.convertElementValue(item.name, item.value, cpe);
        }
        return elementValues;
    }

    private static ElementValue convertElementValue(String elementName, Object o, ConstantPoolEditor cpe) {
        return Dex2Pro.convertElementValue(cpe.addUtf8Constant(elementName), o, cpe);
    }

    private static ElementValue convertElementValue(int elementNameIndex, Object o, ConstantPoolEditor cpe) {
        if (o instanceof Boolean) {
            return new ConstantElementValue('Z', elementNameIndex, cpe.addIntegerConstant((Boolean)o != false ? 1 : 0));
        }
        if (o instanceof Byte) {
            return new ConstantElementValue('B', elementNameIndex, cpe.addIntegerConstant(((Byte)o).intValue()));
        }
        if (o instanceof Short) {
            return new ConstantElementValue('S', elementNameIndex, cpe.addIntegerConstant(((Short)o).intValue()));
        }
        if (o instanceof Character) {
            return new ConstantElementValue('C', elementNameIndex, cpe.addIntegerConstant((int)((Character)o).charValue()));
        }
        if (o instanceof Integer) {
            return new ConstantElementValue('I', elementNameIndex, cpe.addIntegerConstant(((Integer)o).intValue()));
        }
        if (o instanceof Long) {
            return new ConstantElementValue('J', elementNameIndex, cpe.addLongConstant(((Long)o).longValue()));
        }
        if (o instanceof Float) {
            return new ConstantElementValue('F', elementNameIndex, cpe.addFloatConstant(((Float)o).floatValue()));
        }
        if (o instanceof Double) {
            return new ConstantElementValue('D', elementNameIndex, cpe.addDoubleConstant(((Double)o).doubleValue()));
        }
        if (o instanceof String) {
            return new ConstantElementValue('s', elementNameIndex, cpe.addUtf8Constant((String)o));
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            ElementValue[] values = new ElementValue[array.length];
            for (int index = 0; index < array.length; ++index) {
                values[index] = Dex2Pro.convertElementValue(0, array[index], cpe);
            }
            return new ArrayElementValue(elementNameIndex, values.length, values);
        }
        if (o instanceof DexAnnotationNode) {
            DexAnnotationNode ann = (DexAnnotationNode)o;
            return new AnnotationElementValue(elementNameIndex, Dex2Pro.convertAnnotation(ann, cpe));
        }
        if (o instanceof Field) {
            Field f = (Field)o;
            return new EnumConstantElementValue(elementNameIndex, cpe.addUtf8Constant(f.getType()), cpe.addUtf8Constant(f.getName()));
        }
        if (o instanceof DexType) {
            return new ClassElementValue(elementNameIndex, cpe.addUtf8Constant(((DexType)o).desc));
        }
        if (o instanceof Method) {
            System.err.println("WARN: ignored method annotation value");
        } else if (o == null) {
            System.err.println("WARN: ignored null annotation value");
        }
        throw new UnsupportedOperationException("Unsupported element value " + (o == null ? "null class" : o.getClass().getName()) + " [" + o + "]");
    }

    private static Map<String, Clz> collectClzInfo(DexFileNode fileNode) {
        LinkedHashMap<String, Clz> classes = new LinkedHashMap<String, Clz>();
        for (DexClassNode classNode : fileNode.clzs) {
            Clz clz = Dex2Pro.get(classes, classNode.className);
            clz.access = clz.access & 0xFFFFF9FF | classNode.access;
            if (classNode.anns == null) continue;
            block13: for (DexAnnotationNode ann : classNode.anns) {
                if (ann.visibility != Visibility.SYSTEM) continue;
                switch (ann.type) {
                    case "Ldalvik/annotation/EnclosingClass;": {
                        DexType type = (DexType)Dex2Pro.findAnnotationAttribute(ann, "value");
                        Clz enclosingClass = Dex2Pro.get(classes, Objects.requireNonNull(type).desc);
                        clz.enclosingClass = enclosingClass;
                        enclosingClass.addInner(clz);
                        break;
                    }
                    case "Ldalvik/annotation/EnclosingMethod;": {
                        Method m = (Method)Dex2Pro.findAnnotationAttribute(ann, "value");
                        Clz enclosingClass = Dex2Pro.get(classes, ((Method)Objects.requireNonNull(m)).getOwner());
                        clz.enclosingClass = enclosingClass;
                        clz.enclosingMethod = m;
                        enclosingClass.addInner(clz);
                        break;
                    }
                    case "Ldalvik/annotation/InnerClass;": {
                        for (DexAnnotationNode.Item it : ann.items) {
                            if ("accessFlags".equals(it.name)) {
                                Clz clz2 = clz;
                                clz2.access = clz2.access | (Integer)it.value & 0xFFFFF9FF;
                                continue;
                            }
                            if (!"name".equals(it.name)) continue;
                            clz.innerName = (String)it.value;
                        }
                        continue block13;
                    }
                    case "Ldalvik/annotation/MemberClasses;": {
                        Object[] ts;
                        for (Object v : ts = (Object[])Dex2Pro.findAnnotationAttribute(ann, "value")) {
                            DexType type = (DexType)v;
                            Clz inner = Dex2Pro.get(classes, type.desc);
                            clz.addInner(inner);
                            inner.enclosingClass = clz;
                        }
                        break;
                    }
                }
            }
        }
        return classes;
    }

    private static boolean isJavaIdentifier(String str) {
        if (str.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Dex2Pro usePrimitiveArrayConstants(boolean usePrimitiveArrayConstants) {
        this.usePrimitiveArrayConstants = usePrimitiveArrayConstants;
        return this;
    }

    public void convertDex(DexFileNode fileNode, ClassVisitor classVisitor) {
        if (fileNode.clzs != null) {
            Map<String, Clz> classes = Dex2Pro.collectClzInfo(fileNode);
            for (DexClassNode classNode : fileNode.clzs) {
                this.convertClass(fileNode, classNode, classVisitor, classes);
            }
        }
    }

    private void convertClass(DexFileNode dfn, DexClassNode classNode, ClassVisitor classVisitor, Map<String, Clz> classes) {
        this.convertClass(dfn.dexVersion, classNode, classVisitor, classes);
    }

    private void convertClass(int dexVersion, DexClassNode classNode, ClassVisitor classVisitor, Map<String, Clz> classes) {
        DexFix.fixStaticFinalFieldValue(classNode);
        Clz clzInfo = classes.get(classNode.className);
        int access = classNode.access;
        boolean isInnerClass = false;
        if (clzInfo != null && (clzInfo.enclosingClass != null || clzInfo.enclosingMethod != null)) {
            if (classNode.anns != null && classNode.anns.stream().noneMatch(x -> x.type.equals("Ldalvik/annotation/EnclosingMethod;"))) {
                isInnerClass = true;
            } else if (clzInfo.enclosingClass != null) {
                clzInfo.enclosingClass.inners.remove(clzInfo);
            }
        }
        access = Dex2Pro.clearClassAccess(isInnerClass, access);
        int version = dexVersion >= 0x303337 ? 0x340000 : 0x320000;
        ClassBuilder classBuilder = new ClassBuilder(version, access, Dex2Pro.toInternalName(classNode.className), classNode.superClass == null ? null : Dex2Pro.toInternalName(classNode.superClass));
        ProgramClass programClass = classBuilder.getProgramClass();
        ConstantPoolEditor constantPoolEditor = classBuilder.getConstantPoolEditor();
        Object interfaceInterNames = null;
        if (classNode.interfaceNames != null) {
            for (int i = 0; i < classNode.interfaceNames.length; ++i) {
                classBuilder.addInterface(Dex2Pro.toInternalName(classNode.interfaceNames[i]));
            }
        }
        if (classNode.anns != null) {
            for (DexAnnotationNode ann : classNode.anns) {
                Object[] strs;
                if (ann.visibility != Visibility.SYSTEM || !"Ldalvik/annotation/Signature;".equals(ann.type) || (strs = (Object[])Dex2Pro.findAnnotationAttribute(ann, "value")) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (Object str : strs) {
                    sb.append(str);
                }
                String signature = sb.toString();
                new AttributesEditor(programClass, false).addAttribute((Attribute)new SignatureAttribute(constantPoolEditor.addUtf8Constant("Signature"), constantPoolEditor.addUtf8Constant(signature)));
            }
        }
        if (clzInfo != null) {
            AttributesEditor attributesEditor = new AttributesEditor(programClass, false);
            ArrayList<InnerClassNode> innerClassNodes = new ArrayList<InnerClassNode>(5);
            if (isInnerClass) {
                Method enclosingMethod = clzInfo.enclosingMethod;
                if (enclosingMethod != null || clzInfo.innerName == null) {
                    EnclosingMethodAttribute enclosingMethodAttribute = new EnclosingMethodAttribute(constantPoolEditor.addUtf8Constant("EnclosingMethod"), constantPoolEditor.addClassConstant(Dex2Pro.toInternalName(clzInfo.enclosingClass.name), null), enclosingMethod == null ? 0 : constantPoolEditor.addNameAndTypeConstant(enclosingMethod.getName(), enclosingMethod.getDesc()));
                    attributesEditor.addAttribute((Attribute)enclosingMethodAttribute);
                }
                Dex2Pro.searchEnclosing(clzInfo, innerClassNodes);
            }
            Dex2Pro.searchInnerClass(clzInfo, innerClassNodes, classNode.className);
            if (!innerClassNodes.isEmpty()) {
                InnerClassesAttribute innerClassesAttribute = new InnerClassesAttribute(constantPoolEditor.addUtf8Constant("InnerClasses"), 0, new InnerClassesInfo[0]);
                InnerClassesAttributeEditor innerClassesAttributeEditor = new InnerClassesAttributeEditor(innerClassesAttribute);
                Collections.sort(innerClassNodes, INNER_CLASS_NODE_COMPARATOR);
                for (InnerClassNode icn : innerClassNodes) {
                    if (icn.innerName != null && !Dex2Pro.isJavaIdentifier(icn.innerName)) {
                        Metrics.increaseCount((Metrics.MetricType)Metrics.MetricType.DEX2PRO_INVALID_INNER_CLASS);
                        icn.innerName = null;
                        icn.outerName = null;
                    }
                    int innerClassIndex = constantPoolEditor.addClassConstant(icn.name, null);
                    int outerClassIndex = icn.outerName == null ? 0 : constantPoolEditor.addClassConstant(icn.outerName, null);
                    int innerNameIndex = icn.innerName == null ? 0 : constantPoolEditor.addUtf8Constant(icn.innerName);
                    int innerClassAccessFlags = icn.access;
                    InnerClassesInfo innerClassesInfo = new InnerClassesInfo(innerClassIndex, outerClassIndex, innerNameIndex, innerClassAccessFlags);
                    innerClassesAttributeEditor.addInnerClassesInfo(innerClassesInfo);
                }
                attributesEditor.addAttribute((Attribute)innerClassesAttribute);
            }
        }
        if (classNode.source != null) {
            new AttributesEditor(programClass, false).addAttribute((Attribute)new SourceFileAttribute(constantPoolEditor.addUtf8Constant("SourceFile"), constantPoolEditor.addUtf8Constant(classNode.source)));
        }
        if (classNode.anns != null) {
            Dex2Pro.convertAnnotations(classNode.anns, programClass, constantPoolEditor);
        }
        if (classNode.fields != null) {
            for (DexFieldNode fieldNode : classNode.fields) {
                this.convertField(classNode, fieldNode, classBuilder);
            }
        }
        if (classNode.methods != null) {
            for (DexMethodNode methodNode : classNode.methods) {
                this.convertMethod(classNode, methodNode, classBuilder);
            }
        }
        classVisitor.visitProgramClass(programClass);
    }

    private void convertCode(IrMethod irMethod, CompactCodeAttributeComposer composer) {
        this.optimize(irMethod);
        this.ir2j(irMethod, composer);
    }

    private boolean shouldSkipMethod(IrMethod method) {
        if (MAX_PHI_LABELS > 0 && method.phiLabels != null && method.phiLabels.size() > MAX_PHI_LABELS) {
            return true;
        }
        return MAX_STATEMENTS > 0 && method.stmts.getSize() > MAX_STATEMENTS;
    }

    private void convertField(DexClassNode classNode, DexFieldNode fieldNode, ClassBuilder classBuilder) {
        Object cst;
        ProgramClass programClass = classBuilder.getProgramClass();
        ProgramField programField = classBuilder.addAndReturnField(fieldNode.access & 0xFFFDFFFF, fieldNode.field.getName(), fieldNode.field.getType());
        ConstantPoolEditor constantPoolEditor = classBuilder.getConstantPoolEditor();
        if (fieldNode.anns != null) {
            for (DexAnnotationNode ann : fieldNode.anns) {
                Object[] strs;
                if (ann.visibility != Visibility.SYSTEM || !"Ldalvik/annotation/Signature;".equals(ann.type) || (strs = (Object[])Dex2Pro.findAnnotationAttribute(ann, "value")) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (Object str : strs) {
                    sb.append(str);
                }
                String signature = sb.toString();
                new AttributesEditor(programClass, (ProgramMember)programField, false).addAttribute((Attribute)new SignatureAttribute(constantPoolEditor.addUtf8Constant("Signature"), constantPoolEditor.addUtf8Constant(signature)));
            }
        }
        if ((cst = fieldNode.cst) != null) {
            int constantValueIndex = Dex2Pro.convertConstantValue(constantPoolEditor, cst);
            int attributeNameIndex = constantPoolEditor.addUtf8Constant("ConstantValue");
            ConstantValueAttribute attribute = new ConstantValueAttribute(attributeNameIndex, constantValueIndex);
            AttributesEditor editor = new AttributesEditor(programClass, (ProgramMember)programField, false);
            editor.addAttribute((Attribute)attribute);
        }
        if (fieldNode.anns != null) {
            Dex2Pro.convertAnnotations(fieldNode.anns, programClass, constantPoolEditor, programField);
        }
    }

    static int convertBootstrapMethod(ProgramClass programClass, ConstantPoolEditor constantPoolEditor, MethodHandle mh, Object[] args) {
        AttributesEditor attributesEditor = new AttributesEditor(programClass, false);
        BootstrapMethodsAttribute bootstrapMethodsAttribute = (BootstrapMethodsAttribute)attributesEditor.findAttribute("BootstrapMethods");
        if (bootstrapMethodsAttribute == null) {
            bootstrapMethodsAttribute = new BootstrapMethodsAttribute(constantPoolEditor.addUtf8Constant("BootstrapMethods"), 0, new BootstrapMethodInfo[0]);
            attributesEditor.addAttribute((Attribute)bootstrapMethodsAttribute);
        }
        int methodHandleIndex = Dex2Pro.convertMethodHandle(constantPoolEditor, mh);
        int[] methodArguments = Dex2Pro.convertConstantValues(constantPoolEditor, args);
        BootstrapMethodInfo bootstrapMethodInfo = new BootstrapMethodInfo(methodHandleIndex, methodArguments.length, methodArguments);
        return new BootstrapMethodsAttributeEditor(bootstrapMethodsAttribute).addBootstrapMethodInfo(bootstrapMethodInfo);
    }

    private static int[] convertConstantValues(ConstantPoolEditor constantPoolEditor, Object[] v) {
        int[] inddices = new int[v.length];
        for (int i = 0; i < v.length; ++i) {
            inddices[i] = Dex2Pro.convertConstantValue(constantPoolEditor, v[i]);
        }
        return inddices;
    }

    private static int convertConstantValue(ConstantPoolEditor constantPoolEditor, Object ele) {
        if (ele instanceof Boolean) {
            return constantPoolEditor.addIntegerConstant((Boolean)ele != false ? 1 : 0);
        }
        if (ele instanceof Character) {
            return constantPoolEditor.addIntegerConstant((int)((Character)ele).charValue());
        }
        if (ele instanceof Byte || ele instanceof Short || ele instanceof Integer) {
            return constantPoolEditor.addIntegerConstant(((Number)ele).intValue());
        }
        if (ele instanceof Long) {
            return constantPoolEditor.addLongConstant(((Long)ele).longValue());
        }
        if (ele instanceof Float) {
            return constantPoolEditor.addFloatConstant(((Float)ele).floatValue());
        }
        if (ele instanceof Double) {
            return constantPoolEditor.addDoubleConstant(((Double)ele).doubleValue());
        }
        if (ele instanceof String) {
            return constantPoolEditor.addStringConstant((String)ele);
        }
        if (ele instanceof DexType) {
            return constantPoolEditor.addMethodTypeConstant(((DexType)ele).desc, null);
        }
        if (ele instanceof Proto) {
            return constantPoolEditor.addMethodTypeConstant(((Proto)ele).getDesc(), null);
        }
        if (ele instanceof MethodHandle) {
            return Dex2Pro.convertMethodHandle(constantPoolEditor, (MethodHandle)ele);
        }
        throw new UnsupportedOperationException("Unsupported constant " + ele.getClass().getName() + " [" + ele + "]");
    }

    private static int convertMethodHandle(ConstantPoolEditor constantPoolEditor, MethodHandle mh) {
        switch (mh.getType()) {
            case 3: {
                return constantPoolEditor.addMethodHandleConstant(1, constantPoolEditor.addFieldrefConstant(Dex2Pro.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType(), null, null));
            }
            case 2: {
                return constantPoolEditor.addMethodHandleConstant(3, constantPoolEditor.addFieldrefConstant(Dex2Pro.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType(), null, null));
            }
            case 1: {
                return constantPoolEditor.addMethodHandleConstant(2, constantPoolEditor.addFieldrefConstant(Dex2Pro.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType(), null, null));
            }
            case 0: {
                return constantPoolEditor.addMethodHandleConstant(4, constantPoolEditor.addFieldrefConstant(Dex2Pro.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType(), null, null));
            }
            case 5: {
                return constantPoolEditor.addMethodHandleConstant(5, constantPoolEditor.addMethodrefConstant(Dex2Pro.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc(), null, null));
            }
            case 4: {
                return constantPoolEditor.addMethodHandleConstant(6, constantPoolEditor.addMethodrefConstant(Dex2Pro.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc(), null, null));
            }
            case 6: 
            case 7: {
                return constantPoolEditor.addMethodHandleConstant(7, constantPoolEditor.addMethodrefConstant(Dex2Pro.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc(), null, null));
            }
            case 8: {
                return constantPoolEditor.addMethodHandleConstant(9, constantPoolEditor.addInterfaceMethodrefConstant(Dex2Pro.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc(), null, null));
            }
        }
        throw new UnsupportedOperationException("Unsupported method handle type " + mh.getType());
    }

    private void convertMethod(DexClassNode classNode, DexMethodNode methodNode, ClassBuilder classBuilder) {
        ProgramMethod programMethod;
        int flags = methodNode.access & 0xFFFCFFFF;
        String name = methodNode.method.getName();
        String desc = methodNode.method.getDesc();
        ProgramClass programClass = classBuilder.getProgramClass();
        try {
            IrMethod irMethod;
            programMethod = methodNode.codeNode == null ? classBuilder.addAndReturnMethod(flags, name, desc) : (this.shouldSkipMethod(irMethod = this.dex2ir(methodNode)) ? classBuilder.addAndReturnMethod(flags, name, desc) : classBuilder.addAndReturnMethod(flags, name, desc, MAX_CODE_LENGTH, code -> this.convertCode(irMethod, code)));
        }
        catch (Exception e) {
            if (SKIP_UNPARSEABLE_METHODS) {
                programMethod = classBuilder.addAndReturnMethod(flags, name, desc);
                Metrics.increaseCount((Metrics.MetricType)Metrics.MetricType.DEX2PRO_UNPARSEABLE_METHOD_SKIPPED);
            }
            throw e;
        }
        ConstantPoolEditor constantPoolEditor = classBuilder.getConstantPoolEditor();
        if (methodNode.anns != null) {
            block10: for (DexAnnotationNode dexAnnotationNode : methodNode.anns) {
                if (dexAnnotationNode.visibility != Visibility.SYSTEM) continue;
                switch (dexAnnotationNode.type) {
                    case "Ldalvik/annotation/Throws;": {
                        ExceptionsAttributeEditor strs = (ExceptionsAttributeEditor)Dex2Pro.findAnnotationAttribute(dexAnnotationNode, "value");
                        if (strs == null) continue block10;
                        ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute(constantPoolEditor.addUtf8Constant("Exceptions"), 0, new int[((Object[])strs).length]);
                        ExceptionsAttributeEditor exceptionsAttributeEditor = new ExceptionsAttributeEditor(exceptionsAttribute);
                        ExceptionsAttributeEditor exceptionsAttributeEditor2 = strs;
                        int n = ((ExceptionsAttributeEditor)exceptionsAttributeEditor2).length;
                        for (int i = 0; i < n; ++i) {
                            ExceptionsAttributeEditor str = exceptionsAttributeEditor2[i];
                            DexType type = (DexType)str;
                            exceptionsAttributeEditor.addException(constantPoolEditor.addClassConstant(Dex2Pro.toInternalName(type), null));
                        }
                        new AttributesEditor(programClass, (ProgramMember)programMethod, false).addAttribute((Attribute)exceptionsAttribute);
                        break;
                    }
                    case "Ldalvik/annotation/Signature;": {
                        ExceptionsAttributeEditor strs = (Object[])Dex2Pro.findAnnotationAttribute(dexAnnotationNode, "value");
                        if (strs == null) break;
                        StringBuilder sb = new StringBuilder();
                        for (ExceptionsAttributeEditor str : strs) {
                            sb.append(str);
                        }
                        String signature = sb.toString();
                        new AttributesEditor(programClass, (ProgramMember)programMethod, false).addAttribute((Attribute)new SignatureAttribute(constantPoolEditor.addUtf8Constant("Signature"), constantPoolEditor.addUtf8Constant(signature)));
                    }
                }
            }
        }
        if (0 != (classNode.access & 0x2000)) {
            Object defaultValue = null;
            if (classNode.anns != null) {
                for (DexAnnotationNode ann : classNode.anns) {
                    if (ann.visibility != Visibility.SYSTEM || !ann.type.equals("Ldalvik/annotation/AnnotationDefault;")) continue;
                    DexAnnotationNode node = (DexAnnotationNode)Dex2Pro.findAnnotationAttribute(ann, "value");
                    if (node == null) break;
                    defaultValue = Dex2Pro.findAnnotationAttribute(node, methodNode.method.getName());
                    break;
                }
            }
            if (defaultValue != null) {
                AnnotationDefaultAttribute annotationDefaultAttribute = new AnnotationDefaultAttribute(constantPoolEditor.addUtf8Constant("AnnotationDefault"), Dex2Pro.convertElementValue(0, defaultValue, constantPoolEditor));
                new AttributesEditor(programClass, (ProgramMember)programMethod, false).addAttribute((Attribute)annotationDefaultAttribute);
            }
        }
        if (methodNode.anns != null) {
            Dex2Pro.convertAnnotations(methodNode.anns, programClass, constantPoolEditor, programMethod);
        }
        if (methodNode.parameterAnns != null) {
            Dex2Pro.convertParameterAnnotations(methodNode.parameterAnns, programClass, constantPoolEditor, programMethod);
        }
    }

    private IrMethod dex2ir(DexMethodNode methodNode) {
        return new Dex2IRConverter().convert(0 != (methodNode.access & 8), methodNode.method, methodNode.codeNode);
    }

    private static Object findAnnotationAttribute(DexAnnotationNode ann, String name) {
        for (DexAnnotationNode.Item item : ann.items) {
            if (!item.name.equals(name)) continue;
            return item.value;
        }
        return null;
    }

    private static Clz get(Map<String, Clz> classes, String name) {
        Clz clz = classes.get(name);
        if (clz == null) {
            clz = new Clz(name);
            classes.put(name, clz);
        }
        return clz;
    }

    private void ir2j(IrMethod irMethod, CompactCodeAttributeComposer composer) {
        new IR2ProConverter().optimizeSynchronized(false).usePrimitiveArrayConstants(this.usePrimitiveArrayConstants).ir(irMethod).code(composer).convert();
    }

    private void optimize(IrMethod irMethod) {
        T_cleanLabel.transform(irMethod);
        T_removeLocal.transform(irMethod);
        T_removeConst.transform(irMethod);
        T_zero.transform(irMethod);
        T_new.transform(irMethod);
        T_agg.transform(irMethod);
        T_multiArray.transform(irMethod);
        T_voidInvoke.transform(irMethod);
        T_type.transform(irMethod);
        T_unssa.transform(irMethod);
        T_ir2jRegAssign.transform(irMethod);
        T_trimEx.transform(irMethod);
    }

    private static void searchEnclosing(Clz clz, List<InnerClassNode> innerClassNodes) {
        Clz enclosingClass;
        LinkedHashSet<Clz> visitedClz = new LinkedHashSet<Clz>();
        Clz p = clz;
        while (p != null && visitedClz.add(p) && (enclosingClass = p.enclosingClass) != null && !enclosingClass.equals(clz)) {
            String outerName = p.enclosingMethod != null || p.innerName == null ? null : Dex2Pro.toInternalName(enclosingClass.name);
            innerClassNodes.add(new InnerClassNode(Dex2Pro.toInternalName(p.name), outerName, p.innerName, Dex2Pro.clearInnerAccess(p.access)));
            p = p.enclosingClass;
        }
    }

    private static void searchInnerClass(Clz clz, List<InnerClassNode> innerClassNodes, String className) {
        if (clz.inners != null) {
            for (Clz inner : clz.inners) {
                String outerName = inner.enclosingMethod != null || inner.innerName == null ? null : Dex2Pro.toInternalName(className);
                innerClassNodes.add(new InnerClassNode(Dex2Pro.toInternalName(inner.name), outerName, inner.innerName, Dex2Pro.clearInnerAccess(inner.access)));
            }
        }
    }

    private static class InnerClassNode {
        private String name;
        private String outerName;
        private String innerName;
        private int access;

        public InnerClassNode(String name, String outerName, String innerName, int access) {
            this.name = name;
            this.outerName = outerName;
            this.innerName = innerName;
            this.access = access;
        }
    }

    private static class Clz {
        private int access;
        private Clz enclosingClass;
        private Method enclosingMethod;
        private String innerName;
        private Set<Clz> inners = null;
        private final String name;

        private Clz(String name) {
            this.name = name;
        }

        void addInner(Clz clz) {
            if (this.inners == null) {
                this.inners = new LinkedHashSet<Clz>();
            }
            this.inners.add(clz);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Clz)) {
                return false;
            }
            Clz clz = (Clz)o;
            return Objects.equals(this.name, clz.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "" + this.name;
        }
    }
}

