/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.converter;

import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.util.ClassUtil;
import proguard.dexfile.converter.Dex2Pro;
import proguard.dexfile.ir.IrMethod;
import proguard.dexfile.ir.Trap;
import proguard.dexfile.ir.expr.ArrayExpr;
import proguard.dexfile.ir.expr.CastExpr;
import proguard.dexfile.ir.expr.Constant;
import proguard.dexfile.ir.expr.Exprs;
import proguard.dexfile.ir.expr.FieldExpr;
import proguard.dexfile.ir.expr.FilledArrayExpr;
import proguard.dexfile.ir.expr.InvokeCustomExpr;
import proguard.dexfile.ir.expr.InvokeExpr;
import proguard.dexfile.ir.expr.InvokeNewExpr;
import proguard.dexfile.ir.expr.InvokePolymorphicExpr;
import proguard.dexfile.ir.expr.Local;
import proguard.dexfile.ir.expr.NewExpr;
import proguard.dexfile.ir.expr.NewMutiArrayExpr;
import proguard.dexfile.ir.expr.StaticFieldExpr;
import proguard.dexfile.ir.expr.TypeExpr;
import proguard.dexfile.ir.expr.UnopExpr;
import proguard.dexfile.ir.expr.Value;
import proguard.dexfile.ir.stmt.GotoStmt;
import proguard.dexfile.ir.stmt.IfStmt;
import proguard.dexfile.ir.stmt.LabelStmt;
import proguard.dexfile.ir.stmt.LookupSwitchStmt;
import proguard.dexfile.ir.stmt.Stmt;
import proguard.dexfile.ir.stmt.TableSwitchStmt;
import proguard.dexfile.ir.stmt.UnopStmt;
import proguard.dexfile.reader.DexType;
import proguard.dexfile.reader.Method;
import proguard.dexfile.reader.Proto;

public class IR2ProConverter {
    private static final int MAX_STATEMENT_DEPTH = Integer.parseInt(System.getProperty("proguard.dexconversion.maxstatementdepth", "0"));
    private boolean optimizeSynchronized = false;
    private boolean usePrimitiveArrayConstants = false;
    private int statementDepthCounter = 0;
    IrMethod ir;
    CompactCodeAttributeComposer code;

    public IR2ProConverter usePrimitiveArrayConstants(boolean usePrimitiveArrayConstants) {
        this.usePrimitiveArrayConstants = usePrimitiveArrayConstants;
        return this;
    }

    public IR2ProConverter optimizeSynchronized(boolean optimizeSynchronized) {
        this.optimizeSynchronized = optimizeSynchronized;
        return this;
    }

    public IR2ProConverter ir(IrMethod ir) {
        this.ir = ir;
        return this;
    }

    public IR2ProConverter code(CompactCodeAttributeComposer code) {
        this.code = code;
        return this;
    }

    public void convert() {
        this.mapLabelStmt(this.ir, this.code);
        try {
            this.reBuildInstructions(this.ir, this.code);
        }
        catch (StatementDepthException e) {
            this.code.reset();
            this.code.beginCodeFragment(10);
            return;
        }
        this.reBuildTryCatchBlocks(this.ir, this.code);
    }

    private void mapLabelStmt(IrMethod ir, CompactCodeAttributeComposer code) {
        for (Stmt p : ir.stmts) {
            if (p.st != Stmt.ST.LABEL) continue;
            LabelStmt labelStmt = (LabelStmt)p;
            labelStmt.tag = code.createLabel();
        }
    }

    private void reBuildTryCatchBlocks(IrMethod ir, CompactCodeAttributeComposer code) {
        for (Trap trap : ir.traps) {
            boolean needAdd = false;
            for (Stmt p = trap.start.getNext(); p != null && p != trap.end; p = p.getNext()) {
                if (p.st == Stmt.ST.LABEL) continue;
                needAdd = true;
                break;
            }
            if (!needAdd) continue;
            for (int i = 0; i < trap.handlers.length; ++i) {
                String type = trap.types[i];
                code.catch_((CompactCodeAttributeComposer.Label)trap.start.tag, (CompactCodeAttributeComposer.Label)trap.end.tag, (CompactCodeAttributeComposer.Label)trap.handlers[i].tag, type == null ? null : IR2ProConverter.toInternal(type), null);
            }
        }
    }

    static String toInternal(String n) {
        return ClassUtil.internalClassTypeFromType((String)n);
    }

    private CompactCodeAttributeComposer reBuildInstructions(IrMethod ir, CompactCodeAttributeComposer code) {
        int maxLocalIndex = 0;
        for (Local local : ir.locals) {
            maxLocalIndex = Math.max(maxLocalIndex, local._ls_index);
        }
        LinkedHashMap<String, Integer> lockMap = new LinkedHashMap<String, Integer>();
        int[] mutableMaxLocalIndex = new int[]{maxLocalIndex};
        for (Stmt st : ir.stmts) {
            this.statementDepthCounter = 0;
            this.reBuildInstructions(ir, st, lockMap, mutableMaxLocalIndex, code);
        }
        return code;
    }

    private CompactCodeAttributeComposer reBuildInstructions(IrMethod ir, Stmt st, Map<String, Integer> lockMap, int[] mutableMaxLocalIndex, CompactCodeAttributeComposer code) {
        switch (st.st) {
            case LABEL: {
                LabelStmt labelStmt = (LabelStmt)st;
                if (labelStmt.lineNumber >= 0) {
                    code.line(labelStmt.lineNumber);
                }
                return code.label((CompactCodeAttributeComposer.Label)labelStmt.tag);
            }
            case ASSIGN: {
                Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                Value v1 = e2.op1;
                Value v2 = e2.op2;
                switch (v1.vt) {
                    case LOCAL: {
                        Local local = (Local)v1;
                        int i = local._ls_index;
                        boolean skipOrg = false;
                        if (v2.vt == Value.VT.LOCAL && i == ((Local)v2)._ls_index) {
                            skipOrg = true;
                        } else if (v1.valueType.charAt(0) == 'I') {
                            int increment;
                            if (v2.vt == Value.VT.ADD) {
                                int increment2;
                                if (IR2ProConverter.isLocalWithIndex(v2.getOp1(), i) && v2.getOp2().vt == Value.VT.CONSTANT) {
                                    int increment3 = (Integer)((Constant)v2.getOp2()).value;
                                    if (increment3 >= Short.MIN_VALUE && increment3 <= Short.MAX_VALUE) {
                                        code.iinc(i, increment3);
                                        skipOrg = true;
                                    }
                                } else if (IR2ProConverter.isLocalWithIndex(v2.getOp2(), i) && v2.getOp1().vt == Value.VT.CONSTANT && (increment2 = ((Integer)((Constant)v2.getOp1()).value).intValue()) >= Short.MIN_VALUE && increment2 <= Short.MAX_VALUE) {
                                    code.iinc(i, increment2);
                                    skipOrg = true;
                                }
                            } else if (v2.vt == Value.VT.SUB && IR2ProConverter.isLocalWithIndex(v2.getOp1(), i) && v2.getOp2().vt == Value.VT.CONSTANT && (increment = -((Integer)((Constant)v2.getOp2()).value).intValue()) >= Short.MIN_VALUE && increment <= Short.MAX_VALUE) {
                                code.iinc(i, increment);
                                skipOrg = true;
                            }
                        }
                        if (!skipOrg) {
                            this.accept(v2, code);
                            if (i >= 0) {
                                return this.xstore(i, v1, code);
                            }
                            if (!v1.valueType.equals("V")) {
                                switch (v1.valueType.charAt(0)) {
                                    case 'D': 
                                    case 'J': {
                                        return code.pop2();
                                    }
                                }
                                return code.pop();
                            }
                        }
                        return code;
                    }
                    case STATIC_FIELD: {
                        StaticFieldExpr fe = (StaticFieldExpr)v1;
                        this.accept(v2, code);
                        this.insertI2x(v2.valueType, fe.type, code);
                        return code.putstatic(IR2ProConverter.toInternal(fe.owner), fe.name, fe.type);
                    }
                    case FIELD: {
                        FieldExpr fe = (FieldExpr)v1;
                        this.accept(fe.op, code);
                        this.accept(v2, code);
                        this.insertI2x(v2.valueType, fe.type, code);
                        return code.putfield(IR2ProConverter.toInternal(fe.owner), fe.name, fe.type);
                    }
                    case ARRAY: {
                        ArrayExpr ae = (ArrayExpr)v1;
                        this.accept(ae.op1, code);
                        this.accept(ae.op2, code);
                        this.accept(v2, code);
                        String tp1 = ae.op1.valueType;
                        String tp2 = ae.valueType;
                        if (tp1.charAt(0) == '[') {
                            String arrayElementType = tp1.substring(1);
                            this.insertI2x(v2.valueType, arrayElementType, code);
                            return this.xastore(arrayElementType, code);
                        }
                        return this.xastore(tp2, code);
                    }
                }
                throw new RuntimeException(v1.vt.toString());
            }
            case IDENTITY: {
                Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                if (e2.op2.vt == Value.VT.EXCEPTION_REF) {
                    int index = ((Local)e2.op1)._ls_index;
                    if (index >= 0) {
                        return code.astore(index);
                    }
                    return code.pop();
                }
                return code;
            }
            case FILL_ARRAY_DATA: {
                Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                if (e2.getOp2().vt == Value.VT.CONSTANT) {
                    String elementType;
                    Object arrayData = ((Constant)e2.getOp2()).value;
                    int arraySize = Array.getLength(arrayData);
                    String arrayValueType = e2.getOp1().valueType;
                    String string = elementType = arrayValueType.charAt(0) == '[' ? arrayValueType.substring(1) : "I";
                    if (!this.usePrimitiveArrayConstants || arraySize < 512) {
                        this.accept(e2.getOp1(), code);
                        for (int i = 0; i < arraySize; ++i) {
                            code.dup().ldc(i);
                            this.pushConstant(Array.get(arrayData, i), code);
                            this.xastore(elementType, code);
                        }
                        return code.pop();
                    }
                    if (arrayData instanceof short[] && elementType.equals("C")) {
                        char[] charArray = new char[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            short digit = (Short)Array.get(arrayData, i);
                            charArray[i] = (char)digit;
                        }
                        code.ldc((Object)charArray);
                    } else {
                        code.ldc(arrayData);
                    }
                    code.iconst_0();
                    this.accept(e2.getOp1(), code);
                    code.iconst_0();
                    code.pushInt(arraySize);
                    code.invokestatic("java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    return code;
                }
                FilledArrayExpr filledArrayExpr = (FilledArrayExpr)e2.getOp2();
                int arraySize = filledArrayExpr.ops.length;
                String arrayValueType = e2.getOp1().valueType;
                String elementType = arrayValueType.charAt(0) == '[' ? arrayValueType.substring(1) : "I";
                this.accept(e2.getOp1(), code);
                for (int i = 0; i < arraySize; ++i) {
                    code.dup().ldc(i);
                    this.accept(filledArrayExpr.ops[i], code);
                    this.xastore(elementType, code);
                }
                return code.pop();
            }
            case GOTO: {
                return code.goto_((CompactCodeAttributeComposer.Label)((GotoStmt)st).target.tag);
            }
            case IF: {
                return this.reBuildJumpInstructions((IfStmt)st, code);
            }
            case LOCK: {
                Value v = ((UnopStmt)st).op;
                this.accept(v, code);
                if (this.optimizeSynchronized) {
                    switch (v.vt) {
                        case LOCAL: 
                        case CONSTANT: {
                            String key = v.vt == Value.VT.LOCAL ? "L" + ((Local)v)._ls_index : "C" + ((Constant)v).value;
                            Integer integer = lockMap.get(key);
                            int nIndex = integer != null ? integer : mutableMaxLocalIndex[0] + 1;
                            code.dup();
                            this.xstore(nIndex, v, code);
                            lockMap.put(key, nIndex);
                            break;
                        }
                        default: {
                            throw new RuntimeException(v.vt.toString());
                        }
                    }
                }
                return code.monitorenter();
            }
            case UNLOCK: {
                Value v = ((UnopStmt)st).op;
                if (this.optimizeSynchronized) {
                    switch (v.vt) {
                        case LOCAL: 
                        case CONSTANT: {
                            String key = v.vt == Value.VT.LOCAL ? "L" + ((Local)v)._ls_index : "C" + ((Constant)v).value;
                            Integer integer = lockMap.get(key);
                            return integer != null ? this.xload((int)integer, v, code) : this.accept(v, code);
                        }
                    }
                    return this.accept(v, code);
                }
                this.accept(v, code);
                return code.monitorexit();
            }
            case NOP: {
                return code;
            }
            case RETURN: {
                Value v = ((UnopStmt)st).op;
                this.accept(v, code);
                this.insertI2x(v.valueType, ir.ret, code);
                return this.xreturn(v, code);
            }
            case RETURN_VOID: {
                return code.return_();
            }
            case LOOKUP_SWITCH: {
                LookupSwitchStmt lss = (LookupSwitchStmt)st;
                this.accept(lss.op, code);
                CompactCodeAttributeComposer.Label[] targets = new CompactCodeAttributeComposer.Label[lss.targets.length];
                for (int i = 0; i < targets.length; ++i) {
                    targets[i] = (CompactCodeAttributeComposer.Label)lss.targets[i].tag;
                }
                return code.lookupswitch((CompactCodeAttributeComposer.Label)lss.defaultTarget.tag, lss.lookupValues, targets);
            }
            case TABLE_SWITCH: {
                TableSwitchStmt tss = (TableSwitchStmt)st;
                this.accept(tss.op, code);
                CompactCodeAttributeComposer.Label[] targets = new CompactCodeAttributeComposer.Label[tss.targets.length];
                for (int i = 0; i < targets.length; ++i) {
                    targets[i] = (CompactCodeAttributeComposer.Label)tss.targets[i].tag;
                }
                return code.tableswitch((CompactCodeAttributeComposer.Label)tss.defaultTarget.tag, tss.lowIndex, tss.lowIndex + targets.length - 1, targets);
            }
            case THROW: {
                this.accept(((UnopStmt)st).op, code);
                return code.athrow();
            }
            case VOID_INVOKE: {
                Value op = st.getOp();
                this.accept(op, code);
                String ret = op.valueType;
                if (op.vt == Value.VT.INVOKE_NEW) {
                    return code.pop();
                }
                if (!"V".equals(ret)) {
                    switch (ret.charAt(0)) {
                        case 'D': 
                        case 'J': {
                            return code.pop2();
                        }
                    }
                    return code.pop();
                }
                return code;
            }
        }
        throw new RuntimeException(st.st.toString());
    }

    private static boolean isLocalWithIndex(Value v, int i) {
        return v.vt == Value.VT.LOCAL && ((Local)v)._ls_index == i;
    }

    private CompactCodeAttributeComposer insertI2x(String tos, String expect, CompactCodeAttributeComposer code) {
        switch (expect.charAt(0)) {
            case 'B': {
                switch (tos.charAt(0)) {
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        return code.i2b();
                    }
                }
            }
            case 'S': {
                switch (tos.charAt(0)) {
                    case 'C': 
                    case 'I': {
                        return code.i2s();
                    }
                }
            }
            case 'C': {
                switch (tos.charAt(0)) {
                    case 'I': {
                        return code.i2c();
                    }
                }
            }
        }
        return code;
    }

    static boolean isZeroOrNull(Value v1) {
        if (v1.vt == Value.VT.CONSTANT) {
            Object v = ((Constant)v1).value;
            return Integer.valueOf(0).equals(v) || Constant.Null.equals(v);
        }
        return false;
    }

    private CompactCodeAttributeComposer reBuildJumpInstructions(IfStmt st, CompactCodeAttributeComposer code) {
        CompactCodeAttributeComposer.Label target = (CompactCodeAttributeComposer.Label)st.target.tag;
        Value v = st.op;
        Value v1 = v.getOp1();
        Value v2 = v.getOp2();
        String type = v1.valueType;
        boolean isZeroOrNullV2 = IR2ProConverter.isZeroOrNull(v2);
        switch (type.charAt(0)) {
            case 'L': 
            case '[': {
                if (IR2ProConverter.isZeroOrNull(v1) || isZeroOrNullV2) {
                    if (isZeroOrNullV2) {
                        this.accept(v1, code);
                    } else {
                        this.accept(v2, code);
                    }
                    return v.vt == Value.VT.EQ ? code.ifnull(target) : code.ifnonnull(target);
                }
                this.accept(v1, code);
                this.accept(v2, code);
                return v.vt == Value.VT.EQ ? code.ifacmpeq(target) : code.ifacmpne(target);
            }
        }
        if (IR2ProConverter.isZeroOrNull(v1) || isZeroOrNullV2) {
            if (isZeroOrNullV2) {
                this.accept(v1, code);
            } else {
                this.accept(v2, code);
            }
            switch (v.vt) {
                case NE: {
                    return code.ifne(target);
                }
                case EQ: {
                    return code.ifeq(target);
                }
                case GE: {
                    return isZeroOrNullV2 ? code.ifge(target) : code.ifle(target);
                }
                case GT: {
                    return isZeroOrNullV2 ? code.ifgt(target) : code.iflt(target);
                }
                case LE: {
                    return isZeroOrNullV2 ? code.ifle(target) : code.ifge(target);
                }
                case LT: {
                    return isZeroOrNullV2 ? code.iflt(target) : code.ifgt(target);
                }
            }
            throw new RuntimeException(v.vt.toString());
        }
        this.accept(v1, code);
        this.accept(v2, code);
        switch (v.vt) {
            case NE: {
                return code.ificmpne(target);
            }
            case EQ: {
                return code.ificmpeq(target);
            }
            case GE: {
                return code.ificmpge(target);
            }
            case GT: {
                return code.ificmpgt(target);
            }
            case LE: {
                return code.ificmple(target);
            }
            case LT: {
                return code.ificmplt(target);
            }
        }
        throw new RuntimeException(v1.vt.toString());
    }

    private CompactCodeAttributeComposer accept(Value value, CompactCodeAttributeComposer code) {
        if (MAX_STATEMENT_DEPTH > 0 && this.statementDepthCounter > MAX_STATEMENT_DEPTH) {
            throw new StatementDepthException();
        }
        ++this.statementDepthCounter;
        switch (value.et) {
            case E0: {
                switch (value.vt) {
                    case LOCAL: {
                        return this.xload(((Local)value)._ls_index, value, code);
                    }
                    case CONSTANT: {
                        Constant cst = (Constant)value;
                        if (cst.value.equals(Constant.Null)) {
                            return code.aconst_null();
                        }
                        if (cst.value instanceof DexType) {
                            String descriptor = ((DexType)cst.value).desc;
                            if (ClassUtil.isInternalPrimitiveType((String)descriptor)) {
                                return code.getstatic(ClassUtil.internalNumericClassNameFromPrimitiveType((char)descriptor.charAt(0)), "TYPE", "Ljava/lang/Class;");
                            }
                            return code.ldc(IR2ProConverter.toInternal(descriptor), (Clazz)null);
                        }
                        return this.pushConstant(cst.value, code);
                    }
                    case NEW: {
                        return code.new_(IR2ProConverter.toInternal(((NewExpr)value).type));
                    }
                    case STATIC_FIELD: {
                        StaticFieldExpr sfe = (StaticFieldExpr)value;
                        return code.getstatic(IR2ProConverter.toInternal(sfe.owner), sfe.name, sfe.type);
                    }
                }
                throw new RuntimeException(value.vt.toString());
            }
            case E1: {
                return this.reBuildE1Expression((Value.E1Expr)value, code);
            }
            case E2: {
                return this.reBuildE2Expression((Value.E2Expr)value, code);
            }
            case En: {
                return this.reBuildEnExpression((Value.EnExpr)value, code);
            }
        }
        throw new RuntimeException(value.et.toString());
    }

    private CompactCodeAttributeComposer pushConstant(Object cst, CompactCodeAttributeComposer code) {
        if (cst == null) {
            return code.aconst_null();
        }
        if (cst instanceof Boolean) {
            boolean value = (Boolean)cst;
            return code.iconst(value ? 1 : 0);
        }
        if (cst instanceof Byte) {
            byte value = (Byte)cst;
            return code.pushInt((int)value);
        }
        if (cst instanceof Short) {
            short value = (Short)cst;
            return code.pushInt((int)value);
        }
        if (cst instanceof Character) {
            char value = ((Character)cst).charValue();
            return code.pushInt((int)value);
        }
        if (cst instanceof Integer) {
            int value = (Integer)cst;
            if (value <= Short.MAX_VALUE && value >= Short.MIN_VALUE) {
                return code.pushInt(value);
            }
            return code.ldc(value);
        }
        if (cst instanceof Long) {
            long value = (Long)cst;
            if (value == 0L || value == 1L) {
                return code.lconst((int)value);
            }
            return code.ldc2_w(value);
        }
        if (cst instanceof Float) {
            float value = ((Float)cst).floatValue();
            if (value == 0.0f || value == 1.0f || value == 2.0f) {
                return code.fconst((int)value);
            }
            return code.ldc(value);
        }
        if (cst instanceof Double) {
            double value = (Double)cst;
            if (value == 0.0 || value == 1.0) {
                return code.dconst((int)value);
            }
            return code.ldc2_w(value);
        }
        if (cst instanceof String) {
            return code.ldc((String)cst);
        }
        throw new UnsupportedOperationException("Unsupported constant " + cst.getClass().getName() + " [" + cst + "]");
    }

    private CompactCodeAttributeComposer reBuildEnExpression(Value.EnExpr value, CompactCodeAttributeComposer code) {
        if (value.vt == Value.VT.FILLED_ARRAY) {
            FilledArrayExpr fae = (FilledArrayExpr)value;
            if (this.isConstantPrimitiveArray(fae)) {
                code.ldc(IR2ProConverter.primitiveArray(fae));
            } else {
                this.reBuildE1Expression(Exprs.nNewArray(fae.type, Exprs.nInt(fae.ops.length)), code);
                String tp1 = fae.valueType;
                String elementType = tp1.charAt(0) == '[' ? tp1.substring(1) : null;
                for (int i = 0; i < fae.ops.length; ++i) {
                    if (fae.ops[i] == null) continue;
                    code.dup().ldc(i);
                    this.accept(fae.ops[i], code);
                    String tp2 = fae.ops[i].valueType;
                    if (elementType != null) {
                        this.insertI2x(tp2, elementType, code);
                    }
                    this.xastore(elementType != null ? elementType : "I", code);
                }
            }
            return code;
        }
        switch (value.vt) {
            case NEW_MULTI_ARRAY: {
                for (Value vb : value.ops) {
                    this.accept(vb, code);
                }
                NewMutiArrayExpr nmae = (NewMutiArrayExpr)value;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nmae.dimension; ++i) {
                    sb.append('[');
                }
                sb.append(nmae.baseType);
                return code.multianewarray(sb.toString(), null, value.ops.length);
            }
            case INVOKE_NEW: {
                code.new_(IR2ProConverter.toInternal(((InvokeNewExpr)value).getClassName())).dup();
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_INTERFACE: 
            case INVOKE_SPECIAL: 
            case INVOKE_STATIC: {
                InvokeExpr ie = (InvokeExpr)value;
                int i = 0;
                if (value.vt != Value.VT.INVOKE_STATIC && value.vt != Value.VT.INVOKE_NEW) {
                    i = 1;
                    this.accept(value.ops[0], code);
                }
                int j = 0;
                while (i < value.ops.length) {
                    Value vb = value.ops[i];
                    this.accept(vb, code);
                    this.insertI2x(vb.valueType, ie.getArgs()[j], code);
                    ++i;
                    ++j;
                }
                Proto p = ie.getProto();
                if (ie.vt == Value.VT.INVOKE_NEW) {
                    p = new Proto(p.getParameterTypes(), "V");
                }
                String className = IR2ProConverter.toInternal(ie.getOwner());
                String methodName = ie.getName();
                String methodDescriptor = p.getDesc();
                switch (value.vt) {
                    case INVOKE_VIRTUAL: {
                        return code.invokevirtual(className, methodName, methodDescriptor);
                    }
                    case INVOKE_INTERFACE: {
                        return code.invokeinterface(className, methodName, methodDescriptor);
                    }
                    case INVOKE_NEW: 
                    case INVOKE_SPECIAL: {
                        return code.invokespecial(className, methodName, methodDescriptor);
                    }
                    case INVOKE_STATIC: {
                        return code.invokestatic(className, methodName, methodDescriptor);
                    }
                }
                throw new RuntimeException(value.vt.toString());
            }
            case INVOKE_CUSTOM: {
                int i;
                InvokeCustomExpr ice = (InvokeCustomExpr)value;
                String[] argTypes = ice.getProto().getParameterTypes();
                Value[] vbs = ice.getOps();
                if (argTypes.length == vbs.length) {
                    for (i = 0; i < vbs.length; ++i) {
                        Value vb = vbs[i];
                        this.accept(vb, code);
                        this.insertI2x(vb.valueType, argTypes[i], code);
                    }
                } else if (argTypes.length + 1 == vbs.length) {
                    this.accept(vbs[0], code);
                    for (i = 1; i < vbs.length; ++i) {
                        Value vb = vbs[i];
                        this.accept(vb, code);
                        this.insertI2x(vb.valueType, argTypes[i - 1], code);
                    }
                } else {
                    throw new RuntimeException();
                }
                int bootStrapMethodIndex = Dex2Pro.convertBootstrapMethod(code.getTargetClass(), code.getConstantPoolEditor(), ice.handle, ice.bsmArgs);
                return code.invokedynamic(bootStrapMethodIndex, ice.name, ice.proto.getDesc(), null);
            }
            case INVOKE_POLYMORPHIC: {
                InvokePolymorphicExpr ipe = (InvokePolymorphicExpr)value;
                Method m = ipe.method;
                String[] argTypes = ipe.getProto().getParameterTypes();
                Value[] vbs = ipe.getOps();
                this.accept(vbs[0], code);
                for (int i = 1; i < vbs.length; ++i) {
                    Value vb = vbs[i];
                    this.accept(vb, code);
                    this.insertI2x(vb.valueType, argTypes[i - 1], code);
                }
                return code.invokevirtual(IR2ProConverter.toInternal(m.getOwner()), m.getName(), ipe.getProto().getDesc());
            }
        }
        throw new RuntimeException(value.vt.toString());
    }

    private boolean isConstantPrimitiveArray(FilledArrayExpr fae) {
        if (!this.usePrimitiveArrayConstants) {
            return false;
        }
        if (fae.valueType.length() != 2) {
            return false;
        }
        for (int i = 0; i < fae.ops.length; ++i) {
            Value op = fae.ops[i];
            if (op != null && op.vt == Value.VT.CONSTANT) continue;
            return false;
        }
        return true;
    }

    private static Object primitiveArray(FilledArrayExpr fae) {
        char valueType = fae.valueType.charAt(1);
        Value[] values = fae.ops;
        int length = values.length;
        switch (valueType) {
            case 'Z': {
                boolean[] booleans = new boolean[length];
                for (int i = 0; i < length; ++i) {
                    booleans[i] = ((Number)((Constant)values[i]).value).byteValue() != 0;
                }
                return booleans;
            }
            case 'B': {
                byte[] bytes = new byte[length];
                for (int i = 0; i < length; ++i) {
                    bytes[i] = ((Number)((Constant)values[i]).value).byteValue();
                }
                return bytes;
            }
            case 'S': {
                short[] shorts = new short[length];
                for (int i = 0; i < length; ++i) {
                    shorts[i] = ((Number)((Constant)values[i]).value).shortValue();
                }
                return shorts;
            }
            case 'C': {
                char[] chars = new char[length];
                for (int i = 0; i < length; ++i) {
                    chars[i] = (char)((Number)((Constant)values[i]).value).shortValue();
                }
                return chars;
            }
            case 'I': {
                int[] ints = new int[length];
                for (int i = 0; i < length; ++i) {
                    ints[i] = ((Number)((Constant)values[i]).value).intValue();
                }
                return ints;
            }
            case 'F': {
                float[] floats = new float[length];
                for (int i = 0; i < length; ++i) {
                    floats[i] = ((Number)((Constant)values[i]).value).floatValue();
                }
                return floats;
            }
            case 'J': {
                long[] longs = new long[length];
                for (int i = 0; i < length; ++i) {
                    longs[i] = ((Number)((Constant)values[i]).value).longValue();
                }
                return longs;
            }
            case 'D': {
                double[] doubles = new double[length];
                for (int i = 0; i < length; ++i) {
                    doubles[i] = ((Number)((Constant)values[i]).value).doubleValue();
                }
                return doubles;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + valueType);
    }

    private static Object primitiveArray(String valueType, int length) {
        switch (valueType.charAt(1)) {
            case 'Z': {
                return new boolean[length];
            }
            case 'B': {
                return new byte[length];
            }
            case 'S': {
                return new short[length];
            }
            case 'C': {
                return new char[length];
            }
            case 'I': {
                return new int[length];
            }
            case 'F': {
                return new float[length];
            }
            case 'J': {
                return new long[length];
            }
            case 'D': {
                return new double[length];
            }
        }
        throw new IllegalArgumentException(valueType);
    }

    private CompactCodeAttributeComposer box(String provideType, String expectedType, CompactCodeAttributeComposer code) {
        if (provideType.equals(expectedType)) {
            return code;
        }
        if (expectedType.equals("V")) {
            switch (provideType.charAt(0)) {
                case 'D': 
                case 'J': {
                    return code.pop2();
                }
            }
            return code.pop();
        }
        char p = provideType.charAt(0);
        char e = expectedType.charAt(0);
        if (expectedType.equals("Ljava/lang/Object;") && (p == '[' || p == 'L')) {
            return code;
        }
        if (provideType.equals("Ljava/lang/Object;") && (e == '[' || e == 'L')) {
            return code.checkcast(IR2ProConverter.toInternal(expectedType));
        }
        switch (provideType + expectedType) {
            case "ZLjava/lang/Object;": 
            case "ZLjava/lang/Boolean;": {
                return code.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            }
            case "BLjava/lang/Object;": 
            case "BLjava/lang/Byte;": {
                return code.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            }
            case "SLjava/lang/Object;": 
            case "SLjava/lang/Short;": {
                return code.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            }
            case "CLjava/lang/Object;": 
            case "CLjava/lang/Character;": {
                return code.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            }
            case "ILjava/lang/Object;": 
            case "ILjava/lang/Integer;": {
                return code.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            }
            case "FLjava/lang/Object;": 
            case "FLjava/lang/Float;": {
                return code.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            }
            case "JLjava/lang/Object;": 
            case "JLjava/lang/Long;": {
                return code.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            }
            case "DLjava/lang/Object;": 
            case "DLjava/lang/Double;": {
                return code.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
            case "Ljava/lang/Object;Z": {
                code.checkcast("java/lang/Boolean");
            }
            case "Ljava/lang/Boolean;Z": {
                return code.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
            }
            case "Ljava/lang/Object;B": {
                code.checkcast("java/lang/Byte");
            }
            case "Ljava/lang/Byte;B": {
                return code.invokevirtual("java/lang/Byte", "byteValue", "()B");
            }
            case "Ljava/lang/Object;S": {
                code.checkcast("java/lang/Short");
            }
            case "Ljava/lang/Short;S": {
                return code.invokevirtual("java/lang/Short", "shortValue", "()S");
            }
            case "Ljava/lang/Object;C": {
                code.checkcast("java/lang/Character");
            }
            case "Ljava/lang/Character;C": {
                return code.invokevirtual("java/lang/Character", "charValue", "()C");
            }
            case "Ljava/lang/Object;I": {
                code.checkcast("java/lang/Integer");
            }
            case "Ljava/lang/Integer;I": {
                return code.invokevirtual("java/lang/Integer", "intValue", "()I");
            }
            case "Ljava/lang/Object;F": {
                code.checkcast("java/lang/Float");
            }
            case "Ljava/lang/Float;F": {
                return code.invokevirtual("java/lang/Float", "floatValue", "()F");
            }
            case "Ljava/lang/Object;J": {
                code.checkcast("java/lang/Long");
            }
            case "Ljava/lang/Long;J": {
                return code.invokevirtual("java/lang/Long", "longValue", "()J");
            }
            case "Ljava/lang/Object;D": {
                code.checkcast("java/lang/Double");
            }
            case "Ljava/lang/Double;D": {
                return code.invokevirtual("java/lang/Double", "doubleValue", "()D");
            }
        }
        throw new RuntimeException("i have trouble to auto convert from " + provideType + " to " + expectedType + " currently");
    }

    private CompactCodeAttributeComposer reBuildE1Expression(Value.E1Expr e1, CompactCodeAttributeComposer code) {
        this.accept(e1.getOp(), code);
        switch (e1.vt) {
            case STATIC_FIELD: {
                FieldExpr fe = (FieldExpr)e1;
                return code.getstatic(IR2ProConverter.toInternal(fe.owner), fe.name, fe.type);
            }
            case FIELD: {
                FieldExpr fe = (FieldExpr)e1;
                return code.getfield(IR2ProConverter.toInternal(fe.owner), fe.name, fe.type);
            }
            case NEW_ARRAY: {
                TypeExpr te = (TypeExpr)e1;
                switch (te.type.charAt(0)) {
                    case 'L': 
                    case '[': {
                        return code.anewarray(IR2ProConverter.toInternal(te.type), null);
                    }
                    case 'Z': {
                        return code.newarray(4);
                    }
                    case 'B': {
                        return code.newarray(8);
                    }
                    case 'S': {
                        return code.newarray(9);
                    }
                    case 'C': {
                        return code.newarray(5);
                    }
                    case 'I': {
                        return code.newarray(10);
                    }
                    case 'F': {
                        return code.newarray(6);
                    }
                    case 'J': {
                        return code.newarray(11);
                    }
                    case 'D': {
                        return code.newarray(7);
                    }
                }
                throw new RuntimeException(te.type);
            }
            case CHECK_CAST: {
                return code.checkcast(IR2ProConverter.toInternal(((TypeExpr)e1).type));
            }
            case INSTANCE_OF: {
                return code.instanceof_(IR2ProConverter.toInternal(((TypeExpr)e1).type), null);
            }
            case CAST: {
                return this.cast2(e1.op.valueType, ((CastExpr)e1).to, code);
            }
            case LENGTH: {
                return code.arraylength();
            }
            case NEG: {
                switch (((UnopExpr)e1).type.charAt(0)) {
                    case 'I': {
                        return code.ineg();
                    }
                    case 'F': {
                        return code.fneg();
                    }
                    case 'J': {
                        return code.lneg();
                    }
                    case 'D': {
                        return code.dneg();
                    }
                }
                throw new RuntimeException(((UnopExpr)e1).toString0());
            }
            case NOT: {
                switch (((UnopExpr)e1).type.charAt(0)) {
                    case 'I': {
                        return code.iconst_m1().ixor();
                    }
                    case 'J': {
                        return code.ldc2_w(-1L).lxor();
                    }
                }
                throw new RuntimeException(((UnopExpr)e1).toString0());
            }
        }
        throw new RuntimeException(e1.vt.toString());
    }

    private CompactCodeAttributeComposer reBuildE2Expression(Value.E2Expr e2, CompactCodeAttributeComposer code) {
        String type = e2.op2.valueType;
        this.accept(e2.op1, code);
        if ((e2.vt == Value.VT.ADD || e2.vt == Value.VT.SUB) && e2.op2.vt == Value.VT.CONSTANT) {
            Constant constant = (Constant)e2.op2;
            String t = constant.valueType;
            switch (t.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    int s = (Integer)constant.value;
                    if (s >= 0) break;
                    code.ldc(-s);
                    return e2.vt == Value.VT.ADD ? code.isub() : code.iadd();
                }
                case 'F': {
                    float s = ((Float)constant.value).floatValue();
                    if (!(s < 0.0f)) break;
                    code.ldc(-s);
                    return e2.vt == Value.VT.ADD ? code.fsub() : code.fadd();
                }
                case 'J': {
                    long s = (Long)constant.value;
                    if (s >= 0L) break;
                    code.ldc2_w(-s);
                    return e2.vt == Value.VT.ADD ? code.lsub() : code.ladd();
                }
                case 'D': {
                    double s = (Double)constant.value;
                    if (!(s < 0.0)) break;
                    code.ldc2_w(-s);
                    return e2.vt == Value.VT.ADD ? code.dsub() : code.dadd();
                }
            }
        }
        this.accept(e2.op2, code);
        String tp1 = e2.op1.valueType;
        switch (e2.vt) {
            case ARRAY: {
                String tp2 = e2.valueType;
                type = tp1.charAt(0) == '[' ? tp1.substring(1) : tp2;
                switch (type.charAt(0)) {
                    case 'L': 
                    case '[': {
                        return code.aaload();
                    }
                    case 'B': 
                    case 'Z': {
                        return code.baload();
                    }
                    case 'S': {
                        return code.saload();
                    }
                    case 'C': {
                        return code.caload();
                    }
                    case 'I': {
                        return code.iaload();
                    }
                    case 'F': {
                        return code.faload();
                    }
                    case 'J': {
                        return code.laload();
                    }
                    case 'D': {
                        return code.daload();
                    }
                }
                throw new RuntimeException(type);
            }
            case ADD: {
                switch (type.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return code.iadd();
                    }
                    case 'F': {
                        return code.fadd();
                    }
                    case 'J': {
                        return code.ladd();
                    }
                    case 'D': {
                        return code.dadd();
                    }
                }
                throw new RuntimeException(type);
            }
            case SUB: {
                switch (type.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return code.isub();
                    }
                    case 'F': {
                        return code.fsub();
                    }
                    case 'J': {
                        return code.lsub();
                    }
                    case 'D': {
                        return code.dsub();
                    }
                }
                throw new RuntimeException(type);
            }
            case IDIV: {
                return code.idiv();
            }
            case LDIV: {
                return code.ldiv();
            }
            case FDIV: {
                return code.fdiv();
            }
            case DDIV: {
                return code.ddiv();
            }
            case MUL: {
                switch (type.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return code.imul();
                    }
                    case 'F': {
                        return code.fmul();
                    }
                    case 'J': {
                        return code.lmul();
                    }
                    case 'D': {
                        return code.dmul();
                    }
                }
                throw new RuntimeException(type);
            }
            case REM: {
                switch (type.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return code.irem();
                    }
                    case 'F': {
                        return code.frem();
                    }
                    case 'J': {
                        return code.lrem();
                    }
                    case 'D': {
                        return code.drem();
                    }
                }
                throw new RuntimeException(type);
            }
            case AND: {
                switch (type.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return code.iand();
                    }
                    case 'J': {
                        return code.land();
                    }
                }
                throw new RuntimeException(type);
            }
            case OR: {
                switch (type.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return code.ior();
                    }
                    case 'J': {
                        return code.lor();
                    }
                }
                throw new RuntimeException(type);
            }
            case XOR: {
                switch (type.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return code.ixor();
                    }
                    case 'J': {
                        return code.lxor();
                    }
                }
                throw new RuntimeException(type);
            }
            case SHL: {
                switch (tp1.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        return code.ishl();
                    }
                    case 'J': {
                        return code.lshl();
                    }
                }
                throw new RuntimeException(tp1);
            }
            case SHR: {
                switch (tp1.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        return code.ishr();
                    }
                    case 'J': {
                        return code.lshr();
                    }
                }
                throw new RuntimeException(tp1);
            }
            case USHR: {
                switch (tp1.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        return code.iushr();
                    }
                    case 'J': {
                        return code.lushr();
                    }
                }
                throw new RuntimeException(tp1);
            }
            case LCMP: {
                return code.lcmp();
            }
            case FCMPG: {
                return code.fcmpg();
            }
            case DCMPG: {
                return code.dcmpg();
            }
            case FCMPL: {
                return code.fcmpl();
            }
            case DCMPL: {
                return code.dcmpl();
            }
        }
        throw new RuntimeException(e2.vt.toString());
    }

    private CompactCodeAttributeComposer cast2(String t1, String t2, CompactCodeAttributeComposer code) {
        if (t1.equals(t2)) {
            return code;
        }
        switch (t1.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                switch (t2.charAt(0)) {
                    case 'F': {
                        return code.i2f();
                    }
                    case 'J': {
                        return code.i2l();
                    }
                    case 'D': {
                        return code.i2d();
                    }
                    case 'C': {
                        return code.i2c();
                    }
                    case 'B': {
                        return code.i2b();
                    }
                    case 'S': {
                        return code.i2s();
                    }
                }
                throw new RuntimeException(t2);
            }
            case 'J': {
                switch (t2.charAt(0)) {
                    case 'I': {
                        return code.l2i();
                    }
                    case 'F': {
                        return code.l2f();
                    }
                    case 'D': {
                        return code.l2d();
                    }
                }
                throw new RuntimeException(t2);
            }
            case 'D': {
                switch (t2.charAt(0)) {
                    case 'I': {
                        return code.d2i();
                    }
                    case 'F': {
                        return code.d2f();
                    }
                    case 'J': {
                        return code.d2l();
                    }
                }
                throw new RuntimeException(t2);
            }
            case 'F': {
                switch (t2.charAt(0)) {
                    case 'I': {
                        return code.f2i();
                    }
                    case 'J': {
                        return code.f2l();
                    }
                    case 'D': {
                        return code.f2d();
                    }
                }
                throw new RuntimeException(t2);
            }
        }
        throw new RuntimeException(t1);
    }

    private CompactCodeAttributeComposer xstore(int var, Value v, CompactCodeAttributeComposer code) {
        return this.xstore(var, v.valueType, code);
    }

    private CompactCodeAttributeComposer xstore(int var, String v, CompactCodeAttributeComposer code) {
        switch (v.charAt(0)) {
            case 'L': 
            case '[': {
                return code.astore(var);
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return code.istore(var);
            }
            case 'F': {
                return code.fstore(var);
            }
            case 'J': {
                return code.lstore(var);
            }
            case 'D': {
                return code.dstore(var);
            }
        }
        throw new RuntimeException(v);
    }

    private CompactCodeAttributeComposer xload(int var, Value v, CompactCodeAttributeComposer code) {
        return this.xload(var, v.valueType, code);
    }

    private CompactCodeAttributeComposer xload(int var, String v, CompactCodeAttributeComposer code) {
        switch (v.charAt(0)) {
            case 'L': 
            case '[': {
                return code.aload(var);
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return code.iload(var);
            }
            case 'F': {
                return code.fload(var);
            }
            case 'J': {
                return code.lload(var);
            }
            case 'D': {
                return code.dload(var);
            }
        }
        throw new RuntimeException(v);
    }

    private CompactCodeAttributeComposer xastore(Value v, CompactCodeAttributeComposer code) {
        return this.xastore(v.valueType, code);
    }

    private CompactCodeAttributeComposer xastore(String v, CompactCodeAttributeComposer code) {
        switch (v.charAt(0)) {
            case 'L': 
            case '[': {
                return code.aastore();
            }
            case 'B': 
            case 'Z': {
                return code.bastore();
            }
            case 'S': {
                return code.sastore();
            }
            case 'C': {
                return code.castore();
            }
            case 'I': {
                return code.iastore();
            }
            case 'F': {
                return code.fastore();
            }
            case 'J': {
                return code.lastore();
            }
            case 'D': {
                return code.dastore();
            }
        }
        throw new RuntimeException(v);
    }

    private CompactCodeAttributeComposer xreturn(Value v, CompactCodeAttributeComposer code) {
        return this.xreturn(v.valueType, code);
    }

    private CompactCodeAttributeComposer xreturn(String v, CompactCodeAttributeComposer code) {
        switch (v.charAt(0)) {
            case 'L': 
            case '[': {
                return code.areturn();
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return code.ireturn();
            }
            case 'F': {
                return code.freturn();
            }
            case 'J': {
                return code.lreturn();
            }
            case 'D': {
                return code.dreturn();
            }
        }
        throw new RuntimeException(v);
    }

    private static class StatementDepthException
    extends RuntimeException {
        private StatementDepthException() {
        }
    }
}

