/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir;

import java.util.ArrayList;
import java.util.List;
import proguard.dexfile.ir.LabelAndLocalMapper;
import proguard.dexfile.ir.LocalVar;
import proguard.dexfile.ir.Trap;
import proguard.dexfile.ir.Util;
import proguard.dexfile.ir.expr.Local;
import proguard.dexfile.ir.stmt.LabelStmt;
import proguard.dexfile.ir.stmt.StmtList;

public class IrMethod {
    public boolean isStatic;
    public String[] args;
    public List<Local> locals = new ArrayList<Local>();
    public String name;
    public String owner;
    public String ret;
    public StmtList stmts = new StmtList();
    public List<Trap> traps = new ArrayList<Trap>();
    public List<LocalVar> vars = new ArrayList<LocalVar>();
    public List<LabelStmt> phiLabels;

    public IrMethod clone() {
        IrMethod n = new IrMethod();
        LabelAndLocalMapper mapper = new LabelAndLocalMapper();
        n.name = this.name;
        n.args = this.args;
        n.isStatic = this.isStatic;
        n.owner = this.owner;
        n.ret = this.ret;
        n.stmts = this.stmts.clone(mapper);
        for (Trap trap : this.traps) {
            n.traps.add(trap.clone(mapper));
        }
        for (LocalVar localVar : this.vars) {
            n.vars.add(localVar.clone(mapper));
        }
        if (this.phiLabels != null) {
            ArrayList<LabelStmt> nPhiLabels = new ArrayList<LabelStmt>(this.phiLabels.size());
            for (LabelStmt labelStmt : this.phiLabels) {
                nPhiLabels.add(labelStmt.clone(mapper));
            }
            n.phiLabels = nPhiLabels;
        }
        for (Local local : this.locals) {
            n.locals.add((Local)local.clone(mapper));
        }
        return n;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("// ").append(this.owner).append("\n");
        if (this.isStatic) {
            sb.append(" static ");
        }
        sb.append(this.ret == null ? null : Util.toShortClassName(this.ret)).append(' ').append(this.name).append('(');
        if (this.args != null) {
            boolean first = true;
            for (String arg : this.args) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(Util.toShortClassName(arg));
            }
        }
        sb.append(") {\n\n").append(this.stmts).append("\n");
        if (this.traps.size() > 0 || this.vars.size() > 0) {
            sb.append("=============\n");
            for (Trap trap : this.traps) {
                sb.append(trap).append('\n');
            }
            for (LocalVar var : this.vars) {
                sb.append(var).append('\n');
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

