/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.expr;

import java.lang.reflect.Array;
import proguard.dexfile.ir.LabelAndLocalMapper;
import proguard.dexfile.ir.Util;
import proguard.dexfile.ir.expr.Value;
import proguard.dexfile.reader.DexType;

public class Constant
extends Value.E0Expr {
    public static final Object Null = new Object();
    public Object value;

    public Constant(Object value) {
        super(Value.VT.CONSTANT);
        this.value = value;
    }

    @Override
    public Value clone() {
        return new Constant(this.value);
    }

    @Override
    public Value clone(LabelAndLocalMapper mapper) {
        return new Constant(this.value);
    }

    @Override
    public String toString0() {
        if (Null == this.value) {
            return "null";
        }
        if (this.value == null) {
            return "NULL";
        }
        if (this.value instanceof Number) {
            if (this.value instanceof Float) {
                return this.value.toString() + "F";
            }
            if (this.value instanceof Long) {
                return this.value.toString() + "L";
            }
            return this.value.toString();
        }
        if (this.value instanceof String) {
            StringBuffer buf = new StringBuffer();
            Util.appendString(buf, (String)this.value);
            return buf.toString();
        }
        if (this.value instanceof DexType) {
            return Util.toShortClassName(((DexType)this.value).desc) + ".class";
        }
        if (this.value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int size = Array.getLength(this.value);
            for (int i = 0; i < size; ++i) {
                sb.append(Array.get(this.value, i)).append(",");
            }
            if (size > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
            return sb.toString();
        }
        return "" + this.value;
    }
}

