/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.expr;

import proguard.dexfile.ir.LabelAndLocalMapper;
import proguard.dexfile.ir.Util;
import proguard.dexfile.ir.expr.AbstractInvokeExpr;
import proguard.dexfile.ir.expr.Value;
import proguard.dexfile.reader.Method;
import proguard.dexfile.reader.Proto;

public class InvokeExpr
extends AbstractInvokeExpr {
    public Method method;

    @Override
    protected void releaseMemory() {
        this.method = null;
        super.releaseMemory();
    }

    @Override
    public Proto getProto() {
        return this.method == null ? null : this.method.getProto();
    }

    public InvokeExpr(Value.VT type, Value[] args, String ownerType, String methodName, String[] argmentTypes, String returnType) {
        this(type, args, new Method(ownerType, methodName, argmentTypes, returnType));
    }

    public InvokeExpr(Value.VT type, Value[] args, Method method) {
        super(type, args);
        this.method = method;
    }

    @Override
    public InvokeExpr clone() {
        return new InvokeExpr(this.vt, this.cloneOps(), this.method);
    }

    @Override
    public InvokeExpr clone(LabelAndLocalMapper mapper) {
        return new InvokeExpr(this.vt, this.cloneOps(mapper), this.method);
    }

    @Override
    public String toString0() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (this.vt == Value.VT.INVOKE_NEW) {
            sb.append("new ").append(Util.toShortClassName(this.getOwner()));
        } else if (this.vt == Value.VT.INVOKE_STATIC) {
            sb.append(Util.toShortClassName(this.getOwner())).append('.').append(this.getName());
        } else {
            sb.append(this.ops[i++]).append('.').append(this.getName());
        }
        sb.append('(');
        boolean first = true;
        while (i < this.ops.length) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.ops[i]);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    public String getOwner() {
        return this.method == null ? null : this.method.getOwner();
    }

    public String getRet() {
        return this.method == null ? null : this.method.getReturnType();
    }

    public String getName() {
        return this.method == null ? null : this.method.getName();
    }

    public String[] getArgs() {
        return this.method == null ? null : this.method.getParameterTypes();
    }
}

