/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.expr;

import proguard.dexfile.ir.LabelAndLocalMapper;
import proguard.dexfile.ir.Util;
import proguard.dexfile.ir.expr.Value;

public class NewMutiArrayExpr
extends Value.EnExpr {
    public String baseType;
    public int dimension;

    public NewMutiArrayExpr(String base, int dimension, Value[] sizes) {
        super(Value.VT.NEW_MULTI_ARRAY, sizes);
        this.baseType = base;
        this.dimension = dimension;
    }

    @Override
    protected void releaseMemory() {
        this.baseType = null;
        super.releaseMemory();
    }

    @Override
    public Value clone() {
        return new NewMutiArrayExpr(this.baseType, this.dimension, this.cloneOps());
    }

    @Override
    public Value clone(LabelAndLocalMapper mapper) {
        return new NewMutiArrayExpr(this.baseType, this.dimension, this.cloneOps(mapper));
    }

    @Override
    public String toString0() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ").append(Util.toShortClassName(this.baseType));
        for (Value op : this.ops) {
            sb.append('[').append(op).append(']');
        }
        for (int i = this.ops.length; i < this.dimension; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

