/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.ts;

import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import proguard.dexfile.ir.ET;
import proguard.dexfile.ir.IrMethod;
import proguard.dexfile.ir.Trap;
import proguard.dexfile.ir.Util;
import proguard.dexfile.ir.expr.Constant;
import proguard.dexfile.ir.expr.Local;
import proguard.dexfile.ir.expr.Value;
import proguard.dexfile.ir.stmt.AssignStmt;
import proguard.dexfile.ir.stmt.BaseSwitchStmt;
import proguard.dexfile.ir.stmt.JumpStmt;
import proguard.dexfile.ir.stmt.LabelStmt;
import proguard.dexfile.ir.stmt.NopStmt;
import proguard.dexfile.ir.stmt.Stmt;
import proguard.dexfile.ir.stmt.StmtList;
import proguard.dexfile.ir.stmt.Stmts;
import proguard.dexfile.reader.DexType;

public class Cfg {
    public static int[] countLocalReads(IrMethod method) {
        int size = Cfg.reIndexLocal(method);
        final int[] readCounts = new int[size];
        Cfg.travel(method.stmts, new TravelCallBack(){

            @Override
            public Value onAssign(Local v, AssignStmt as) {
                return v;
            }

            @Override
            public Value onUse(Local v) {
                int n = v._ls_index;
                readCounts[n] = readCounts[n] + 1;
                return v;
            }
        }, true);
        return readCounts;
    }

    public static void reIndexLocalAndLabel(IrMethod irMethod) {
        Cfg.reIndexLocal(irMethod);
        Cfg.reIndexLabel(irMethod);
    }

    private static void reIndexLabel(IrMethod irMethod) {
        int i = 0;
        for (Stmt stmt : irMethod.stmts) {
            if (stmt.st != Stmt.ST.LABEL) continue;
            ((LabelStmt)stmt).displayName = "L" + i++;
        }
    }

    public static boolean notThrow(Stmt s) {
        return !Cfg.isThrow(s);
    }

    public static boolean isThrow(Stmt s) {
        Stmt.ST st = s.st;
        if (st.canThrow()) {
            return true;
        }
        if (st.mayThrow()) {
            ET et = s.et;
            if (et == ET.E1) {
                return Cfg.isThrow(s.getOp());
            }
            if (et == ET.E2) {
                return Cfg.isThrow(s.getOp1()) || Cfg.isThrow(s.getOp2());
            }
            throw new RuntimeException();
        }
        return false;
    }

    private static boolean isThrow(Value op) {
        Value.VT vt = op.vt;
        if (vt.canThrow()) {
            return true;
        }
        if (vt.mayThrow()) {
            switch (op.et) {
                case E1: {
                    return Cfg.isThrow(op.getOp());
                }
                case E2: {
                    return Cfg.isThrow(op.getOp1()) || Cfg.isThrow(op.getOp2());
                }
                case E0: {
                    return op instanceof Constant && ((Constant)op).value instanceof DexType;
                }
            }
            throw new RuntimeException();
        }
        return false;
    }

    public static void createCfgWithoutEx(IrMethod jm) {
        for (Stmt st : jm.stmts) {
            st.frame = null;
            st.exceptionHandlers = null;
            if (st._cfg_froms == null) {
                st._cfg_froms = new TreeSet<Stmt>(jm.stmts);
                continue;
            }
            st._cfg_froms.clear();
        }
        for (Stmt st : jm.stmts) {
            if (st.st.canBranch()) {
                Cfg.link(st, ((JumpStmt)((Object)st)).getTarget());
            }
            if (st.st.canContinue()) {
                Cfg.link(st, st.getNext());
            }
            if (!st.st.canSwitch()) continue;
            BaseSwitchStmt bss = (BaseSwitchStmt)st;
            Cfg.link(st, bss.defaultTarget);
            for (LabelStmt target : bss.targets) {
                Cfg.link(st, target);
            }
        }
    }

    public static void createCFG(IrMethod jm) {
        Cfg.createCfgWithoutEx(jm);
        for (Trap t : jm.traps) {
            for (Stmt s = t.start; s != t.end; s = s.getNext()) {
                if (!Cfg.isThrow(s)) continue;
                Set<LabelStmt> hs = s.exceptionHandlers;
                if (hs == null) {
                    s.exceptionHandlers = hs = new TreeSet<Stmt>(jm.stmts);
                }
                for (LabelStmt handler : t.handlers) {
                    Cfg.link(s, handler);
                    hs.add(handler);
                }
            }
        }
    }

    public static void dfsVisit(IrMethod method, DfsVisitor visitor) {
        for (Stmt st : method.stmts) {
            st.visited = false;
        }
        Stack<Stmt> stack = new Stack<Stmt>();
        stack.add(method.stmts.getFirst());
        while (!stack.isEmpty()) {
            Stmt target;
            Stmt currentStmt = (Stmt)stack.pop();
            if (currentStmt.visited) continue;
            currentStmt.visited = true;
            if (currentStmt.exceptionHandlers != null) {
                for (LabelStmt labelStmt : currentStmt.exceptionHandlers) {
                    stack.push(labelStmt);
                }
            }
            if (visitor != null) {
                visitor.onVisit(currentStmt);
            }
            if (currentStmt.st.canSwitch()) {
                BaseSwitchStmt bs = (BaseSwitchStmt)currentStmt;
                Collections.addAll(stack, bs.targets);
                LabelStmt target2 = bs.defaultTarget;
                stack.add(target2);
            }
            if (currentStmt.st.canBranch()) {
                target = ((JumpStmt)((Object)currentStmt)).getTarget();
                stack.add(target);
            }
            if (!currentStmt.st.canContinue()) continue;
            target = currentStmt.getNext();
            stack.add(target);
        }
    }

    public static <T> void dfs(StmtList stmts, FrameVisitor<T> sv) {
        if (stmts.getSize() == 0) {
            return;
        }
        for (Stmt st : stmts) {
            st.visited = false;
            st.frame = null;
        }
        Stack<Stmt> stack = new Stack<Stmt>();
        Stmt first = stmts.getFirst();
        NopStmt nop = null;
        if (first.st == Stmt.ST.LABEL && first._cfg_froms.size() > 0) {
            nop = Stmts.nNop();
            first._cfg_froms.add(nop);
        }
        stack.add(first);
        first.frame = sv.initFirstFrame(first);
        int counter = 0;
        while (!stack.isEmpty()) {
            Stmt target;
            if (counter % 100 == 0 && Util.irTransformMemoryLimit > 0L && Util.isMemoryLimitReached(Util.irTransformMemoryLimit)) {
                throw new RuntimeException("Memory Limit Reached");
            }
            ++counter;
            Stmt currentStmt = (Stmt)stack.pop();
            if (currentStmt == null || currentStmt.visited) continue;
            currentStmt.visited = true;
            Object beforeExecFrame = currentStmt.frame;
            if (currentStmt.exceptionHandlers != null) {
                for (LabelStmt labelStmt : currentStmt.exceptionHandlers) {
                    labelStmt.frame = sv.merge(beforeExecFrame, labelStmt.frame, currentStmt, labelStmt);
                    stack.push(labelStmt);
                }
            }
            Object afterExecFrame = sv.exec(beforeExecFrame, currentStmt);
            if (currentStmt.st.canSwitch()) {
                BaseSwitchStmt bs = (BaseSwitchStmt)currentStmt;
                for (LabelStmt target2 : bs.targets) {
                    target2.frame = sv.merge(afterExecFrame, target2.frame, currentStmt, target2);
                    stack.push(target2);
                }
                LabelStmt target3 = bs.defaultTarget;
                target3.frame = sv.merge(afterExecFrame, target3.frame, currentStmt, target3);
                stack.push(target3);
            }
            if (currentStmt.st.canBranch()) {
                target = ((JumpStmt)((Object)currentStmt)).getTarget();
                target.frame = sv.merge(afterExecFrame, target.frame, currentStmt, target);
                stack.push(target);
            }
            if (!currentStmt.st.canContinue()) continue;
            target = currentStmt.getNext();
            target.frame = sv.merge(afterExecFrame, target.frame, currentStmt, target);
            stack.push(target);
        }
        if (nop != null) {
            first._cfg_froms.remove(nop);
        }
    }

    private static void link(Stmt from, Stmt to) {
        if (to == null) {
            return;
        }
        to._cfg_froms.add(from);
    }

    public static Value travelMod(Value value, OnUseCallBack callback) {
        switch (value.et) {
            case E0: {
                if (value.vt != Value.VT.LOCAL) break;
                return callback.onUse((Local)value);
            }
            case E1: {
                value.setOp(Cfg.travelMod(value.getOp(), callback));
                break;
            }
            case E2: {
                value.setOp1(Cfg.travelMod(value.getOp1(), callback));
                value.setOp2(Cfg.travelMod(value.getOp2(), callback));
                break;
            }
            case En: {
                Value[] ops = value.getOps();
                for (int i = 0; i < ops.length; ++i) {
                    ops[i] = Cfg.travelMod(ops[i], callback);
                }
                break;
            }
        }
        return value;
    }

    public static void travel(Value value, OnUseCallBack callback) {
        switch (value.et) {
            case E0: {
                if (value.vt != Value.VT.LOCAL) break;
                callback.onUse((Local)value);
                break;
            }
            case E1: {
                Cfg.travel(value.getOp(), callback);
                break;
            }
            case E2: {
                Cfg.travel(value.getOp1(), callback);
                Cfg.travel(value.getOp2(), callback);
                break;
            }
            case En: {
                Value[] ops;
                for (Value op : ops = value.getOps()) {
                    Cfg.travel(op, callback);
                }
                break;
            }
        }
    }

    public static void travelMod(Stmt p, TravelCallBack callback, boolean travelPhi) {
        switch (p.et) {
            case E1: {
                p.setOp(Cfg.travelMod(p.getOp(), callback));
                break;
            }
            case E2: {
                Value e2op1 = p.getOp1();
                if (e2op1.vt == Value.VT.LOCAL && (p.st == Stmt.ST.ASSIGN || p.st == Stmt.ST.IDENTITY)) {
                    p.setOp2(Cfg.travelMod(p.getOp2(), callback));
                    p.setOp1(callback.onAssign((Local)e2op1, (AssignStmt)p));
                    break;
                }
                p.setOp1(Cfg.travelMod(p.getOp1(), callback));
                p.setOp2(Cfg.travelMod(p.getOp2(), callback));
                break;
            }
            case E0: 
            case En: {
                if (!travelPhi || p.st != Stmt.ST.LABEL) break;
                LabelStmt labelStmt = (LabelStmt)p;
                if (labelStmt.phis == null) break;
                for (AssignStmt phi : labelStmt.phis) {
                    Cfg.travelMod(phi, callback, false);
                }
                break;
            }
        }
    }

    public static void travel(Stmt p, TravelCallBack callback, boolean travelPhi) {
        switch (p.et) {
            case E1: {
                Cfg.travel(p.getOp(), callback);
                break;
            }
            case E2: {
                Value e2op1 = p.getOp1();
                if (e2op1.vt == Value.VT.LOCAL && (p.st == Stmt.ST.ASSIGN || p.st == Stmt.ST.IDENTITY)) {
                    Cfg.travel(p.getOp2(), callback);
                    callback.onAssign((Local)e2op1, (AssignStmt)p);
                    break;
                }
                Cfg.travel(p.getOp1(), callback);
                Cfg.travel(p.getOp2(), callback);
                break;
            }
            case E0: 
            case En: {
                if (!travelPhi || p.st != Stmt.ST.LABEL) break;
                LabelStmt labelStmt = (LabelStmt)p;
                if (labelStmt.phis == null) break;
                for (AssignStmt phi : labelStmt.phis) {
                    Cfg.travel(phi, callback, false);
                }
                break;
            }
        }
    }

    public static void travel(StmtList stmts, TravelCallBack callback, boolean travelPhi) {
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            Cfg.travel(p, callback, travelPhi);
        }
    }

    public static void travelMod(StmtList stmts, TravelCallBack callback, boolean travelPhi) {
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            Cfg.travelMod(p, callback, travelPhi);
        }
    }

    public static int reIndexLocal(IrMethod method) {
        int i = 0;
        for (Local local : method.locals) {
            local._ls_index = i++;
        }
        return i;
    }

    public static void collectTos(Stmt stmt, Set<Stmt> tos) {
        if (stmt.st.canBranch()) {
            tos.add(((JumpStmt)((Object)stmt)).getTarget());
        }
        if (stmt.st.canContinue()) {
            tos.add(stmt.getNext());
        }
        if (stmt.st.canSwitch()) {
            BaseSwitchStmt bss = (BaseSwitchStmt)stmt;
            tos.add(bss.defaultTarget);
            Collections.addAll(tos, bss.targets);
        }
        if (stmt.exceptionHandlers != null) {
            tos.addAll(stmt.exceptionHandlers);
        }
    }

    public static interface TravelCallBack
    extends OnUseCallBack,
    OnAssignCallBack {
    }

    public static interface OnAssignCallBack {
        public Value onAssign(Local var1, AssignStmt var2);
    }

    public static interface OnUseCallBack {
        public Value onUse(Local var1);
    }

    public static interface DfsVisitor {
        public void onVisit(Stmt var1);
    }

    public static interface FrameVisitor<T> {
        public T merge(T var1, T var2, Stmt var3, Stmt var4);

        public T initFirstFrame(Stmt var1);

        public T exec(T var1, Stmt var2);
    }
}

