/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.ts;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import proguard.dexfile.ir.IrMethod;
import proguard.dexfile.ir.LocalVar;
import proguard.dexfile.ir.Trap;
import proguard.dexfile.ir.stmt.BaseSwitchStmt;
import proguard.dexfile.ir.stmt.JumpStmt;
import proguard.dexfile.ir.stmt.LabelStmt;
import proguard.dexfile.ir.stmt.Stmt;
import proguard.dexfile.ir.stmt.StmtList;
import proguard.dexfile.ir.ts.Transformer;

public class CleanLabel
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        LinkedHashSet<LabelStmt> uselabels = new LinkedHashSet<LabelStmt>();
        this.addTrap(irMethod.traps, uselabels);
        this.addVars(irMethod.vars, uselabels);
        this.addStmt(irMethod.stmts, uselabels);
        if (irMethod.phiLabels != null) {
            uselabels.addAll(irMethod.phiLabels);
        }
        this.addLineNumber(irMethod.stmts, uselabels);
        this.rmUnused(irMethod.stmts, uselabels);
    }

    private void addVars(List<LocalVar> vars, Set<LabelStmt> uselabels) {
        if (vars != null) {
            for (LocalVar var : vars) {
                uselabels.add(var.start);
                uselabels.add(var.end);
            }
        }
    }

    private void rmUnused(StmtList stmts, Set<LabelStmt> uselabels) {
        Stmt p = stmts.getFirst();
        while (p != null) {
            if (p.st == Stmt.ST.LABEL && !uselabels.contains(p)) {
                Stmt q = p.getNext();
                stmts.remove(p);
                p = q;
                continue;
            }
            p = p.getNext();
        }
    }

    private void addStmt(StmtList stmts, Set<LabelStmt> labels) {
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            if (p instanceof JumpStmt) {
                labels.add(((JumpStmt)((Object)p)).getTarget());
                continue;
            }
            if (p instanceof BaseSwitchStmt) {
                BaseSwitchStmt stmt = (BaseSwitchStmt)p;
                labels.add(stmt.defaultTarget);
                labels.addAll(Arrays.asList(stmt.targets));
                continue;
            }
            if (!(p instanceof LabelStmt) || ((LabelStmt)p).lineNumber < 0) continue;
            labels.add((LabelStmt)p);
        }
    }

    private void addTrap(List<Trap> traps, Set<LabelStmt> labels) {
        if (traps != null) {
            for (Trap trap : traps) {
                labels.add(trap.start);
                labels.add(trap.end);
                labels.addAll(Arrays.asList(trap.handlers));
            }
        }
    }

    private void addLineNumber(StmtList stmts, Set<LabelStmt> uselabels) {
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            if (!(p instanceof LabelStmt) || ((LabelStmt)p).lineNumber == -1) continue;
            uselabels.add((LabelStmt)p);
        }
    }
}

