/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.ts;

import java.util.ArrayList;
import java.util.List;
import proguard.dexfile.ir.IrMethod;
import proguard.dexfile.ir.LabelAndLocalMapper;
import proguard.dexfile.ir.Trap;
import proguard.dexfile.ir.Util;
import proguard.dexfile.ir.stmt.LabelStmt;
import proguard.dexfile.ir.stmt.Stmt;
import proguard.dexfile.ir.stmt.Stmts;
import proguard.dexfile.ir.ts.Cfg;
import proguard.dexfile.ir.ts.Transformer;

public class ExceptionHandlerTrim
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        List<Trap> trips = irMethod.traps;
        irMethod.traps = new ArrayList<Trap>();
        LabelAndLocalMapper map = new LabelAndLocalMapper(){

            @Override
            public LabelStmt map(LabelStmt label) {
                return label;
            }
        };
        int counter = 0;
        for (Trap trap : trips) {
            if (counter % 100 == 0 && Util.irTransformMemoryLimit > 0L && Util.isMemoryLimitReached(Util.irTransformMemoryLimit)) {
                throw new RuntimeException("Memory Limit Reached");
            }
            ++counter;
            Trap ntrap = trap.clone(map);
            boolean status = false;
            for (Stmt p = trap.start.getNext(); p != trap.end; p = p.getNext()) {
                Stmt pre;
                if (!Cfg.notThrow(p)) {
                    if (status) continue;
                    pre = p.getPre();
                    if (pre == null || pre.st != Stmt.ST.LABEL) {
                        pre = Stmts.nLabel();
                        irMethod.stmts.insertBefore(p, pre);
                    }
                    ntrap.start = (LabelStmt)pre;
                    status = true;
                    continue;
                }
                if (!status) continue;
                pre = p.getPre();
                if (pre == null || pre.st != Stmt.ST.LABEL) {
                    pre = Stmts.nLabel();
                    irMethod.stmts.insertBefore(p, pre);
                }
                ntrap.end = (LabelStmt)pre;
                irMethod.traps.add(ntrap);
                status = false;
                ntrap = trap.clone(map);
            }
            if (!status) continue;
            ntrap.end = trap.end;
            irMethod.traps.add(ntrap);
            status = false;
        }
    }
}

