/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.ts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import proguard.dexfile.ir.IrMethod;
import proguard.dexfile.ir.expr.Constant;
import proguard.dexfile.ir.expr.Exprs;
import proguard.dexfile.ir.expr.Local;
import proguard.dexfile.ir.expr.Value;
import proguard.dexfile.ir.stmt.AssignStmt;
import proguard.dexfile.ir.stmt.LabelStmt;
import proguard.dexfile.ir.stmt.Stmt;
import proguard.dexfile.ir.stmt.UnopStmt;
import proguard.dexfile.ir.ts.Cfg;
import proguard.dexfile.ir.ts.RemoveLocalFromSSA;
import proguard.dexfile.ir.ts.StatedTransformer;

public class RemoveConstantFromSSA
extends StatedTransformer {
    public static final Comparator<Local> LOCAL_COMPARATOR = Comparator.comparingInt(local -> local._ls_index);

    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean changed = false;
        ArrayList<AssignStmt> assignStmtList = new ArrayList<AssignStmt>();
        Set<Local> usedByLock = RemoveConstantFromSSA.getLocalsUsedByLock(method);
        LinkedHashMap<Local, Object> cstMap = new LinkedHashMap<Local, Object>();
        for (Stmt p = method.stmts.getFirst(); p != null; p = p.getNext()) {
            if (p.st != Stmt.ST.ASSIGN) continue;
            AssignStmt as = (AssignStmt)p;
            if (as.getOp1().vt != Value.VT.LOCAL || usedByLock.contains(as.getOp1())) continue;
            if (as.getOp2().vt == Value.VT.CONSTANT) {
                assignStmtList.add(as);
                cstMap.put((Local)as.getOp1(), ((Constant)as.getOp2()).value);
                continue;
            }
            if (as.getOp2().vt != Value.VT.LOCAL) continue;
            cstMap.put((Local)as.getOp1(), as.getOp2());
        }
        if (assignStmtList.size() == 0) {
            return false;
        }
        RemoveLocalFromSSA.fixReplace(cstMap);
        final LinkedHashMap<Local, Value> toReplace = new LinkedHashMap<Local, Value>();
        LinkedHashSet<Value> usedInPhi = new LinkedHashSet<Value>();
        List<LabelStmt> phiLabels = method.phiLabels;
        if (phiLabels != null) {
            boolean loopAgain = true;
            while (loopAgain) {
                loopAgain = false;
                usedInPhi.clear();
                Iterator<LabelStmt> it = phiLabels.iterator();
                while (it.hasNext()) {
                    LabelStmt labelStmt = it.next();
                    if (labelStmt.phis == null) continue;
                    Iterator<AssignStmt> it2 = labelStmt.phis.iterator();
                    while (it2.hasNext()) {
                        AssignStmt phi = it2.next();
                        Value[] vs = phi.getOp2().getOps();
                        Object sameCst = null;
                        boolean allEqual = true;
                        for (Value p : vs) {
                            Object cst = cstMap.get(p);
                            if (cst == null) {
                                allEqual = false;
                                break;
                            }
                            if (sameCst == null) {
                                sameCst = cst;
                                continue;
                            }
                            if (sameCst.equals(cst)) continue;
                            allEqual = false;
                            break;
                        }
                        if (allEqual) {
                            cstMap.put((Local)phi.getOp1(), sameCst);
                            if (sameCst instanceof Local) {
                                phi.setOp2((Value)sameCst);
                            } else {
                                phi.setOp2(Exprs.nConstant(sameCst));
                                assignStmtList.add(phi);
                            }
                            it2.remove();
                            method.stmts.insertAfter(labelStmt, phi);
                            changed = true;
                            loopAgain = true;
                            continue;
                        }
                        usedInPhi.addAll(Arrays.asList(phi.getOp2().getOps()));
                    }
                    if (labelStmt.phis.size() != 0) continue;
                    it.remove();
                }
            }
        }
        Iterator it = assignStmtList.iterator();
        while (it.hasNext()) {
            AssignStmt as = (AssignStmt)it.next();
            if (!usedInPhi.contains(as.getOp1())) {
                it.remove();
                method.stmts.remove(as);
                method.locals.remove(as.getOp1());
                changed = true;
            }
            toReplace.put((Local)as.getOp1(), as.getOp2());
        }
        Cfg.travelMod(method.stmts, new Cfg.TravelCallBack(){

            @Override
            public Value onAssign(Local v, AssignStmt as) {
                return v;
            }

            @Override
            public Value onUse(Local v) {
                Value n = (Value)toReplace.get(v);
                return n == null ? v : n.clone();
            }
        }, false);
        return changed;
    }

    private static Set<Local> getLocalsUsedByLock(IrMethod method) {
        LinkedHashSet<Local> usedByLock = new LinkedHashSet<Local>();
        for (Stmt p = method.stmts.getFirst(); p != null; p = p.getNext()) {
            if (p.st != Stmt.ST.LOCK) continue;
            UnopStmt lockStmt = (UnopStmt)p;
            if (lockStmt.getOp().vt != Value.VT.LOCAL) continue;
            usedByLock.add((Local)lockStmt.getOp());
        }
        return usedByLock;
    }
}

