/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.ir.ts;

import java.util.ArrayList;
import java.util.List;
import proguard.dexfile.ir.IrMethod;
import proguard.dexfile.ir.expr.Constant;
import proguard.dexfile.ir.expr.Exprs;
import proguard.dexfile.ir.expr.Local;
import proguard.dexfile.ir.expr.Value;
import proguard.dexfile.ir.stmt.AssignStmt;
import proguard.dexfile.ir.stmt.LabelStmt;
import proguard.dexfile.ir.stmt.Stmt;
import proguard.dexfile.ir.stmt.Stmts;
import proguard.dexfile.ir.ts.StatedTransformer;

public class ZeroTransformer
extends StatedTransformer {
    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean changed = false;
        ArrayList<AssignStmt> assignStmtList = new ArrayList<AssignStmt>();
        for (Stmt p = method.stmts.getFirst(); p != null; p = p.getNext()) {
            int v;
            if (p.st != Stmt.ST.ASSIGN) continue;
            AssignStmt as = (AssignStmt)p;
            if (as.getOp1().vt != Value.VT.LOCAL || as.getOp2().vt != Value.VT.CONSTANT) continue;
            Constant cst = (Constant)as.getOp2();
            Object value = cst.value;
            if (!(value instanceof Number) || value instanceof Long || value instanceof Double || (v = ((Number)value).intValue()) != 0 && v != 1) continue;
            assignStmtList.add(as);
        }
        if (assignStmtList.size() == 0) {
            return false;
        }
        List<LabelStmt> phiLabels = method.phiLabels;
        if (phiLabels != null) {
            for (AssignStmt as : assignStmtList) {
                Local local = (Local)as.getOp1();
                boolean first = true;
                for (LabelStmt labelStmt : phiLabels) {
                    for (AssignStmt phi : labelStmt.phis) {
                        Value[] vs = phi.getOp2().getOps();
                        for (int i = 0; i < vs.length; ++i) {
                            Value v = vs[i];
                            if (v != local) continue;
                            if (first) {
                                first = false;
                                continue;
                            }
                            Local nLocal = Exprs.nLocal(-1);
                            method.locals.add(nLocal);
                            changed = true;
                            method.stmts.insertBefore(as, Stmts.nAssign(nLocal, as.getOp2().clone()));
                            vs[i] = nLocal;
                        }
                    }
                }
            }
        }
        return changed;
    }
}

