/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.reader;

import proguard.dexfile.reader.Field;
import proguard.dexfile.reader.Method;

public class MethodHandle {
    public static final int STATIC_PUT = 0;
    public static final int STATIC_GET = 1;
    public static final int INSTANCE_PUT = 2;
    public static final int INSTANCE_GET = 3;
    public static final int INVOKE_STATIC = 4;
    public static final int INVOKE_INSTANCE = 5;
    public static final int INVOKE_CONSTRUCTOR = 6;
    public static final int INVOKE_DIRECT = 7;
    public static final int INVOKE_INTERFACE = 8;
    private int type;
    private Field field;
    private Method method;

    public MethodHandle(int type, Field field) {
        this.type = type;
        this.field = field;
    }

    public MethodHandle(int type, Method method) {
        this.type = type;
        this.method = method;
    }

    public MethodHandle(int type, Field field, Method method) {
        this.type = type;
        this.field = field;
        this.method = method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodHandle that = (MethodHandle)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        return this.method != null ? this.method.equals(that.method) : that.method == null;
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        return result;
    }

    public int getType() {
        return this.type;
    }

    public Field getField() {
        return this.field;
    }

    public Method getMethod() {
        return this.method;
    }
}

