/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.reader.node;

import java.util.ArrayList;
import java.util.List;
import proguard.dexfile.reader.Field;
import proguard.dexfile.reader.Visibility;
import proguard.dexfile.reader.visitors.DexAnnotationAble;
import proguard.dexfile.reader.visitors.DexAnnotationVisitor;

public class DexAnnotationNode
extends DexAnnotationVisitor {
    public List<Item> items = new ArrayList<Item>(5);
    public String type;
    public Visibility visibility;

    public static void acceptAnnotationItem(DexAnnotationVisitor dav, String name, Object o) {
        if (o instanceof Object[]) {
            DexAnnotationVisitor arrayVisitor = dav.visitArray(name);
            if (arrayVisitor != null) {
                Object[] array;
                for (Object e : array = (Object[])o) {
                    DexAnnotationNode.acceptAnnotationItem(arrayVisitor, null, e);
                }
                arrayVisitor.visitEnd();
            }
        } else if (o instanceof DexAnnotationNode) {
            DexAnnotationNode ann = (DexAnnotationNode)o;
            DexAnnotationVisitor av = dav.visitAnnotation(name, ann.type);
            if (av != null) {
                for (Item item : ann.items) {
                    DexAnnotationNode.acceptAnnotationItem(av, item.name, item.value);
                }
                av.visitEnd();
            }
        } else if (o instanceof Field) {
            Field f = (Field)o;
            dav.visitEnum(name, f.getType(), f.getName());
        } else {
            dav.visit(name, o);
        }
    }

    public DexAnnotationNode(String type, Visibility visibility) {
        this.type = type;
        this.visibility = visibility;
    }

    public void accept(DexAnnotationAble av) {
        DexAnnotationVisitor av1 = av.visitAnnotation(this.type, this.visibility);
        if (av1 != null) {
            for (Item item : this.items) {
                DexAnnotationNode.acceptAnnotationItem(av1, item.name, item.value);
            }
            av1.visitEnd();
        }
    }

    @Override
    public void visit(String name, Object value) {
        this.items.add(new Item(name, value));
    }

    @Override
    public DexAnnotationVisitor visitAnnotation(String name, String desc) {
        DexAnnotationNode annotation = new DexAnnotationNode(desc, Visibility.RUNTIME);
        this.items.add(new Item(name, annotation));
        return annotation;
    }

    @Override
    public DexAnnotationVisitor visitArray(final String name) {
        return new AV(){

            @Override
            public void visitEnd() {
                DexAnnotationNode.this.items.add(new Item(name, this.objs.toArray()));
                super.visitEnd();
            }
        };
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.items.add(new Item(name, new Field(desc, value, desc)));
    }

    public static class Item {
        public String name;
        public Object value;

        public Item(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    private static abstract class AV
    extends DexAnnotationVisitor {
        List<Object> objs = new ArrayList<Object>();

        private AV() {
        }

        @Override
        public void visit(String name, Object value) {
            this.objs.add(value);
        }

        @Override
        public DexAnnotationVisitor visitAnnotation(String name, String desc) {
            DexAnnotationNode annotation = new DexAnnotationNode(desc, Visibility.RUNTIME);
            this.objs.add(annotation);
            return annotation;
        }

        @Override
        public DexAnnotationVisitor visitArray(String name) {
            return new AV(){

                @Override
                public void visitEnd() {
                    objs.add(this.objs.toArray());
                    super.visitEnd();
                }
            };
        }

        @Override
        public void visitEnd() {
            this.objs = null;
            super.visitEnd();
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.objs.add(new Field(null, value, desc));
        }
    }
}

