/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.reader.node;

import java.util.ArrayList;
import java.util.List;
import proguard.dexfile.reader.DexLabel;
import proguard.dexfile.reader.Field;
import proguard.dexfile.reader.Method;
import proguard.dexfile.reader.MethodHandle;
import proguard.dexfile.reader.Op;
import proguard.dexfile.reader.Proto;
import proguard.dexfile.reader.node.DexDebugNode;
import proguard.dexfile.reader.node.TryCatchNode;
import proguard.dexfile.reader.node.insn.ConstStmtNode;
import proguard.dexfile.reader.node.insn.DexLabelStmtNode;
import proguard.dexfile.reader.node.insn.DexStmtNode;
import proguard.dexfile.reader.node.insn.FieldStmtNode;
import proguard.dexfile.reader.node.insn.FillArrayDataStmtNode;
import proguard.dexfile.reader.node.insn.FilledNewArrayStmtNode;
import proguard.dexfile.reader.node.insn.JumpStmtNode;
import proguard.dexfile.reader.node.insn.MethodCustomStmtNode;
import proguard.dexfile.reader.node.insn.MethodPolymorphicStmtNode;
import proguard.dexfile.reader.node.insn.MethodStmtNode;
import proguard.dexfile.reader.node.insn.PackedSwitchStmtNode;
import proguard.dexfile.reader.node.insn.SparseSwitchStmtNode;
import proguard.dexfile.reader.node.insn.Stmt0RNode;
import proguard.dexfile.reader.node.insn.Stmt1RNode;
import proguard.dexfile.reader.node.insn.Stmt2R1NNode;
import proguard.dexfile.reader.node.insn.Stmt2RNode;
import proguard.dexfile.reader.node.insn.Stmt3RNode;
import proguard.dexfile.reader.node.insn.TypeStmtNode;
import proguard.dexfile.reader.visitors.DexCodeVisitor;
import proguard.dexfile.reader.visitors.DexDebugVisitor;
import proguard.dexfile.reader.visitors.DexMethodVisitor;

public class DexCodeNode
extends DexCodeVisitor {
    public List<DexStmtNode> stmts = new ArrayList<DexStmtNode>();
    public List<TryCatchNode> tryStmts = null;
    public DexDebugNode debugNode;
    public int totalRegister = -1;

    public DexCodeNode() {
    }

    public DexCodeNode(DexCodeVisitor visitor) {
        super(visitor);
    }

    public void accept(DexCodeVisitor v) {
        DexDebugVisitor ddv;
        if (this.tryStmts != null) {
            for (TryCatchNode tryCatchNode : this.tryStmts) {
                tryCatchNode.accept(v);
            }
        }
        if (this.debugNode != null && (ddv = v.visitDebug()) != null) {
            this.debugNode.accept(ddv);
            ddv.visitEnd();
        }
        if (this.totalRegister >= 0) {
            v.visitRegister(this.totalRegister);
        }
        for (DexStmtNode dexStmtNode : this.stmts) {
            dexStmtNode.accept(v);
        }
    }

    public void accept(DexMethodVisitor v) {
        DexCodeVisitor cv = v.visitCode();
        if (cv != null) {
            this.accept(cv);
            cv.visitEnd();
        }
    }

    protected void add(DexStmtNode stmt) {
        this.stmts.add(stmt);
    }

    @Override
    public void visitConstStmt(Op op, int ra, Object value) {
        this.add(new ConstStmtNode(op, ra, value));
    }

    @Override
    public void visitFillArrayDataStmt(Op op, int ra, Object array) {
        this.add(new FillArrayDataStmtNode(op, ra, array));
    }

    @Override
    public void visitFieldStmt(Op op, int a, int b, Field field) {
        this.add(new FieldStmtNode(op, a, b, field));
    }

    @Override
    public void visitFilledNewArrayStmt(Op op, int[] args, String type) {
        this.add(new FilledNewArrayStmtNode(op, args, type));
    }

    @Override
    public void visitJumpStmt(Op op, int a, int b, DexLabel label) {
        this.add(new JumpStmtNode(op, a, b, label));
    }

    @Override
    public void visitLabel(DexLabel label) {
        this.add(new DexLabelStmtNode(label));
    }

    @Override
    public void visitMethodStmt(Op op, int[] args, Method method) {
        this.add(new MethodStmtNode(op, args, method));
    }

    @Override
    public void visitMethodStmt(Op op, int[] args, String name, Proto proto, MethodHandle bsm, Object ... bsmArgs) {
        this.add(new MethodCustomStmtNode(op, args, name, proto, bsm, bsmArgs));
    }

    @Override
    public void visitMethodStmt(Op op, int[] args, Method bsm, Proto proto) {
        this.add(new MethodPolymorphicStmtNode(op, args, bsm, proto));
    }

    @Override
    public void visitPackedSwitchStmt(Op op, int aA, int first_case, DexLabel[] labels) {
        this.add(new PackedSwitchStmtNode(op, aA, first_case, labels));
    }

    @Override
    public void visitRegister(int total) {
        this.totalRegister = total;
    }

    @Override
    public void visitSparseSwitchStmt(Op op, int ra, int[] cases, DexLabel[] labels) {
        this.add(new SparseSwitchStmtNode(op, ra, cases, labels));
    }

    @Override
    public void visitStmt0R(Op op) {
        this.add(new Stmt0RNode(op));
    }

    @Override
    public void visitStmt1R(Op op, int reg) {
        this.add(new Stmt1RNode(op, reg));
    }

    @Override
    public void visitStmt2R(Op op, int a, int b) {
        this.add(new Stmt2RNode(op, a, b));
    }

    @Override
    public void visitStmt2R1N(Op op, int distReg, int srcReg, int content) {
        this.add(new Stmt2R1NNode(op, distReg, srcReg, content));
    }

    @Override
    public void visitStmt3R(Op op, int a, int b, int c) {
        this.add(new Stmt3RNode(op, a, b, c));
    }

    @Override
    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel[] handler, String[] type) {
        if (this.tryStmts == null) {
            this.tryStmts = new ArrayList<TryCatchNode>(3);
        }
        this.tryStmts.add(new TryCatchNode(start, end, handler, type));
    }

    @Override
    public void visitTypeStmt(Op op, int a, int b, String type) {
        this.add(new TypeStmtNode(op, a, b, type));
    }

    @Override
    public DexDebugVisitor visitDebug() {
        DexDebugNode dexDebugNode;
        this.debugNode = dexDebugNode = new DexDebugNode();
        return dexDebugNode;
    }
}

