/*
 * Decompiled with CFR 0.152.
 */
package proguard.dexfile.reader.node.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import proguard.dexfile.reader.Method;
import proguard.dexfile.reader.Op;
import proguard.dexfile.reader.Proto;
import proguard.dexfile.reader.node.analysis.DvmInterpreter;
import proguard.dexfile.reader.node.insn.AbstractMethodStmtNode;
import proguard.dexfile.reader.node.insn.ConstStmtNode;
import proguard.dexfile.reader.node.insn.DexStmtNode;
import proguard.dexfile.reader.node.insn.FieldStmtNode;
import proguard.dexfile.reader.node.insn.FillArrayDataStmtNode;
import proguard.dexfile.reader.node.insn.FilledNewArrayStmtNode;
import proguard.dexfile.reader.node.insn.JumpStmtNode;
import proguard.dexfile.reader.node.insn.MethodCustomStmtNode;
import proguard.dexfile.reader.node.insn.MethodPolymorphicStmtNode;
import proguard.dexfile.reader.node.insn.MethodStmtNode;
import proguard.dexfile.reader.node.insn.PackedSwitchStmtNode;
import proguard.dexfile.reader.node.insn.SparseSwitchStmtNode;
import proguard.dexfile.reader.node.insn.Stmt1RNode;
import proguard.dexfile.reader.node.insn.Stmt2R1NNode;
import proguard.dexfile.reader.node.insn.Stmt2RNode;
import proguard.dexfile.reader.node.insn.Stmt3RNode;
import proguard.dexfile.reader.node.insn.TypeStmtNode;

public class DvmFrame<V> {
    public V[] values;
    public V tmp;

    public DvmFrame(int totalRegister) {
        this.values = new Object[totalRegister];
    }

    public void setReg(int i, V v) {
        if (i > this.values.length || i < 0) {
            return;
        }
        this.values[i] = v;
    }

    public DvmFrame<V> init(DvmFrame<? extends V> src) {
        this.tmp = src.tmp;
        System.arraycopy(src.values, 0, this.values, 0, this.values.length);
        return this;
    }

    public void execute(DexStmtNode insn, DvmInterpreter<V> interpreter) {
        if (insn.op == null) {
            return;
        }
        switch (insn.op) {
            case CONST: 
            case CONST_4: 
            case CONST_16: 
            case CONST_HIGH16: 
            case CONST_WIDE: 
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE_HIGH16: 
            case CONST_STRING: 
            case CONST_STRING_JUMBO: 
            case CONST_CLASS: {
                this.setReg(((ConstStmtNode)insn).a, interpreter.newOperation(insn));
                this.setTmp(null);
                break;
            }
            case SGET: 
            case SGET_BOOLEAN: 
            case SGET_BYTE: 
            case SGET_CHAR: 
            case SGET_OBJECT: 
            case SGET_SHORT: 
            case SGET_WIDE: {
                this.setReg(((FieldStmtNode)insn).a, interpreter.newOperation(insn));
                this.setTmp(null);
                break;
            }
            case NEW_INSTANCE: {
                this.setReg(((TypeStmtNode)insn).a, interpreter.newOperation(insn));
                this.setTmp(null);
                break;
            }
            case MOVE: 
            case MOVE_16: 
            case MOVE_FROM16: 
            case MOVE_OBJECT: 
            case MOVE_OBJECT_16: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: {
                Stmt2RNode stmt2RNode = (Stmt2RNode)insn;
                this.setReg(stmt2RNode.a, interpreter.copyOperation(insn, this.getReg(stmt2RNode.b)));
                this.setTmp(null);
                break;
            }
            case MOVE_RESULT: 
            case MOVE_RESULT_WIDE: 
            case MOVE_RESULT_OBJECT: 
            case MOVE_EXCEPTION: {
                this.setReg(((Stmt1RNode)insn).a, interpreter.copyOperation(insn, this.getTmp()));
                this.setTmp(null);
                break;
            }
            case NOT_INT: 
            case NOT_LONG: 
            case NEG_DOUBLE: 
            case NEG_FLOAT: 
            case NEG_INT: 
            case NEG_LONG: 
            case INT_TO_BYTE: 
            case INT_TO_CHAR: 
            case INT_TO_DOUBLE: 
            case INT_TO_FLOAT: 
            case INT_TO_LONG: 
            case INT_TO_SHORT: 
            case FLOAT_TO_DOUBLE: 
            case FLOAT_TO_INT: 
            case FLOAT_TO_LONG: 
            case DOUBLE_TO_FLOAT: 
            case DOUBLE_TO_INT: 
            case DOUBLE_TO_LONG: 
            case LONG_TO_DOUBLE: 
            case LONG_TO_FLOAT: 
            case LONG_TO_INT: 
            case ARRAY_LENGTH: {
                Stmt2RNode stmt2RNode1 = (Stmt2RNode)insn;
                this.setReg(stmt2RNode1.a, interpreter.unaryOperation(insn, this.getReg(stmt2RNode1.b)));
                this.setTmp(null);
                break;
            }
            case IF_EQZ: 
            case IF_GEZ: 
            case IF_GTZ: 
            case IF_LEZ: 
            case IF_LTZ: 
            case IF_NEZ: {
                interpreter.unaryOperation(insn, this.getReg(((JumpStmtNode)insn).a));
                this.setTmp(null);
                break;
            }
            case SPARSE_SWITCH: {
                interpreter.unaryOperation(insn, this.getReg(((SparseSwitchStmtNode)insn).a));
                this.setTmp(null);
                break;
            }
            case PACKED_SWITCH: {
                interpreter.unaryOperation(insn, this.getReg(((PackedSwitchStmtNode)insn).a));
                this.setTmp(null);
                break;
            }
            case SPUT: 
            case SPUT_BOOLEAN: 
            case SPUT_BYTE: 
            case SPUT_CHAR: 
            case SPUT_OBJECT: 
            case SPUT_SHORT: 
            case SPUT_WIDE: {
                interpreter.unaryOperation(insn, this.getReg(((FieldStmtNode)insn).a));
                this.setTmp(null);
                break;
            }
            case IGET: 
            case IGET_BOOLEAN: 
            case IGET_BYTE: 
            case IGET_CHAR: 
            case IGET_OBJECT: 
            case IGET_SHORT: 
            case IGET_WIDE: {
                FieldStmtNode fieldStmtNode = (FieldStmtNode)insn;
                this.setReg(fieldStmtNode.a, interpreter.unaryOperation(insn, this.getReg(fieldStmtNode.b)));
                this.setTmp(null);
                break;
            }
            case NEW_ARRAY: 
            case INSTANCE_OF: {
                TypeStmtNode typeStmtNode = (TypeStmtNode)insn;
                this.setReg(typeStmtNode.a, interpreter.unaryOperation(insn, this.getReg(typeStmtNode.b)));
                this.setTmp(null);
                break;
            }
            case CHECK_CAST: {
                TypeStmtNode typeStmtNode = (TypeStmtNode)insn;
                this.setReg(typeStmtNode.a, interpreter.unaryOperation(insn, this.getReg(typeStmtNode.a)));
                this.setTmp(null);
                break;
            }
            case MONITOR_ENTER: 
            case MONITOR_EXIT: 
            case THROW: {
                interpreter.unaryOperation(insn, this.getReg(((Stmt1RNode)insn).a));
                this.setTmp(null);
                break;
            }
            case RETURN: 
            case RETURN_WIDE: 
            case RETURN_OBJECT: {
                interpreter.returnOperation(insn, this.getReg(((Stmt1RNode)insn).a));
                this.setTmp(null);
                break;
            }
            case AGET: 
            case AGET_BOOLEAN: 
            case AGET_BYTE: 
            case AGET_CHAR: 
            case AGET_OBJECT: 
            case AGET_SHORT: 
            case AGET_WIDE: 
            case CMP_LONG: 
            case CMPG_DOUBLE: 
            case CMPG_FLOAT: 
            case CMPL_DOUBLE: 
            case CMPL_FLOAT: 
            case ADD_DOUBLE: 
            case ADD_FLOAT: 
            case ADD_INT: 
            case ADD_LONG: 
            case SUB_DOUBLE: 
            case SUB_FLOAT: 
            case SUB_INT: 
            case SUB_LONG: 
            case MUL_DOUBLE: 
            case MUL_FLOAT: 
            case MUL_INT: 
            case MUL_LONG: 
            case DIV_DOUBLE: 
            case DIV_FLOAT: 
            case DIV_INT: 
            case DIV_LONG: 
            case REM_DOUBLE: 
            case REM_FLOAT: 
            case REM_INT: 
            case REM_LONG: 
            case AND_INT: 
            case AND_LONG: 
            case OR_INT: 
            case OR_LONG: 
            case XOR_INT: 
            case XOR_LONG: 
            case SHL_INT: 
            case SHL_LONG: 
            case SHR_INT: 
            case SHR_LONG: 
            case USHR_INT: 
            case USHR_LONG: {
                Stmt3RNode stmt3RNode = (Stmt3RNode)insn;
                this.setReg(stmt3RNode.a, interpreter.binaryOperation(insn, this.getReg(stmt3RNode.b), this.getReg(stmt3RNode.c)));
                this.setTmp(null);
                break;
            }
            case IF_EQ: 
            case IF_GE: 
            case IF_GT: 
            case IF_LE: 
            case IF_LT: 
            case IF_NE: {
                JumpStmtNode jumpStmtNode = (JumpStmtNode)insn;
                interpreter.binaryOperation(insn, this.getReg(jumpStmtNode.a), this.getReg(jumpStmtNode.b));
                this.setTmp(null);
                break;
            }
            case IPUT: 
            case IPUT_BOOLEAN: 
            case IPUT_BYTE: 
            case IPUT_CHAR: 
            case IPUT_OBJECT: 
            case IPUT_SHORT: 
            case IPUT_WIDE: {
                FieldStmtNode fieldStmtNode1 = (FieldStmtNode)insn;
                interpreter.binaryOperation(insn, this.getReg(fieldStmtNode1.b), this.getReg(fieldStmtNode1.a));
                this.setTmp(null);
                break;
            }
            case APUT: 
            case APUT_BOOLEAN: 
            case APUT_BYTE: 
            case APUT_CHAR: 
            case APUT_OBJECT: 
            case APUT_SHORT: 
            case APUT_WIDE: {
                Stmt3RNode stmt3RNode1 = (Stmt3RNode)insn;
                interpreter.ternaryOperation(insn, this.getReg(stmt3RNode1.b), this.getReg(stmt3RNode1.c), this.getReg(stmt3RNode1.a));
                this.setTmp(null);
                break;
            }
            case INVOKE_VIRTUAL_RANGE: 
            case INVOKE_VIRTUAL: 
            case INVOKE_SUPER_RANGE: 
            case INVOKE_DIRECT_RANGE: 
            case INVOKE_SUPER: 
            case INVOKE_DIRECT: 
            case INVOKE_STATIC_RANGE: 
            case INVOKE_STATIC: 
            case INVOKE_INTERFACE_RANGE: 
            case INVOKE_INTERFACE: 
            case INVOKE_CUSTOM: 
            case INVOKE_CUSTOM_RANGE: 
            case INVOKE_POLYMORPHIC: 
            case INVOKE_POLYMORPHIC_RANGE: {
                ArrayList<V> v;
                boolean isRange;
                int i = 0;
                AbstractMethodStmtNode methodStmtNode = (AbstractMethodStmtNode)insn;
                Proto proto = methodStmtNode.getProto();
                boolean isStatic = false;
                boolean bl = isRange = insn.op == Op.INVOKE_VIRTUAL_RANGE || insn.op == Op.INVOKE_SUPER_RANGE || insn.op == Op.INVOKE_DIRECT_RANGE || insn.op == Op.INVOKE_STATIC_RANGE || insn.op == Op.INVOKE_INTERFACE_RANGE || insn.op == Op.INVOKE_CUSTOM_RANGE || insn.op == Op.INVOKE_POLYMORPHIC_RANGE;
                if (insn.op == Op.INVOKE_STATIC || insn.op == Op.INVOKE_STATIC_RANGE) {
                    isStatic = true;
                } else if (insn.op == Op.INVOKE_CUSTOM || insn.op == Op.INVOKE_CUSTOM_RANGE) {
                    isStatic = true;
                }
                if (isStatic) {
                    v = new ArrayList<V>(proto.getParameterTypes().length);
                } else {
                    v = new ArrayList(proto.getParameterTypes().length + 1);
                    v.add(this.getReg(methodStmtNode.args[i++]));
                }
                if (methodStmtNode.args.length != DvmFrame.descriptorLength(proto.getParameterTypes()) + (isStatic ? 0 : 1)) {
                    System.err.println("WARNING: Illegal bytecode: Mismatch between argument count and method signature.");
                    System.err.println("         This may be the result of defining a function with more than 255 parameters.");
                    System.err.println("         For invocation of " + this.getMethodName(methodStmtNode));
                    System.err.println("         This is a bug in your input, and will cause a crash at runtime.");
                }
                int startReg = isRange ? methodStmtNode.args[0] : 0;
                for (String type : proto.getParameterTypes()) {
                    v.add(this.getReg(isRange ? startReg + i : methodStmtNode.args[i]));
                    char t = type.charAt(0);
                    if (t == 'J' || t == 'D') {
                        i += 2;
                        continue;
                    }
                    ++i;
                }
                this.setTmp(interpreter.naryOperation(insn, v));
                break;
            }
            case FILLED_NEW_ARRAY: 
            case FILLED_NEW_ARRAY_RANGE: {
                FilledNewArrayStmtNode filledNewArrayStmtNode = (FilledNewArrayStmtNode)insn;
                ArrayList<V> v = new ArrayList<V>(filledNewArrayStmtNode.args.length);
                for (int i = 0; i < filledNewArrayStmtNode.args.length; ++i) {
                    v.add(this.getReg(filledNewArrayStmtNode.args[i]));
                }
                this.setTmp(interpreter.naryOperation(insn, v));
                break;
            }
            case ADD_DOUBLE_2ADDR: 
            case ADD_FLOAT_2ADDR: 
            case ADD_INT_2ADDR: 
            case ADD_LONG_2ADDR: 
            case SUB_DOUBLE_2ADDR: 
            case SUB_FLOAT_2ADDR: 
            case SUB_INT_2ADDR: 
            case SUB_LONG_2ADDR: 
            case MUL_DOUBLE_2ADDR: 
            case MUL_FLOAT_2ADDR: 
            case MUL_INT_2ADDR: 
            case MUL_LONG_2ADDR: 
            case DIV_DOUBLE_2ADDR: 
            case DIV_FLOAT_2ADDR: 
            case DIV_INT_2ADDR: 
            case DIV_LONG_2ADDR: 
            case REM_DOUBLE_2ADDR: 
            case REM_FLOAT_2ADDR: 
            case REM_INT_2ADDR: 
            case REM_LONG_2ADDR: 
            case AND_INT_2ADDR: 
            case AND_LONG_2ADDR: 
            case OR_INT_2ADDR: 
            case OR_LONG_2ADDR: 
            case XOR_INT_2ADDR: 
            case XOR_LONG_2ADDR: 
            case SHL_INT_2ADDR: 
            case SHL_LONG_2ADDR: 
            case SHR_INT_2ADDR: 
            case SHR_LONG_2ADDR: 
            case USHR_INT_2ADDR: 
            case USHR_LONG_2ADDR: {
                Stmt2RNode stmt2RNode2 = (Stmt2RNode)insn;
                this.setReg(stmt2RNode2.a, interpreter.binaryOperation(insn, this.getReg(stmt2RNode2.a), this.getReg(stmt2RNode2.b)));
                this.setTmp(null);
                break;
            }
            case ADD_INT_LIT16: 
            case ADD_INT_LIT8: 
            case RSUB_INT_LIT8: 
            case RSUB_INT: 
            case MUL_INT_LIT8: 
            case MUL_INT_LIT16: 
            case DIV_INT_LIT16: 
            case DIV_INT_LIT8: 
            case REM_INT_LIT16: 
            case REM_INT_LIT8: 
            case AND_INT_LIT16: 
            case AND_INT_LIT8: 
            case OR_INT_LIT16: 
            case OR_INT_LIT8: 
            case XOR_INT_LIT16: 
            case XOR_INT_LIT8: 
            case SHL_INT_LIT8: 
            case SHR_INT_LIT8: 
            case USHR_INT_LIT8: {
                Stmt2R1NNode stmt2R1NNode = (Stmt2R1NNode)insn;
                this.setReg(stmt2R1NNode.distReg, interpreter.unaryOperation(insn, this.getReg(stmt2R1NNode.srcReg)));
                this.setTmp(null);
                break;
            }
            case FILL_ARRAY_DATA: {
                interpreter.unaryOperation(insn, this.getReg(((FillArrayDataStmtNode)insn).ra));
                this.setTmp(null);
                break;
            }
            case GOTO: 
            case GOTO_16: 
            case GOTO_32: 
            case RETURN_VOID: 
            case BAD_OP: {
                this.setTmp(null);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public V getTmp() {
        return this.tmp;
    }

    public void setTmp(V v) {
        this.tmp = v;
    }

    public V getReg(int b) {
        if (b > this.values.length || b < 0) {
            return null;
        }
        return this.values[b];
    }

    public int getTotalRegisters() {
        return this.values.length;
    }

    private String getMethodName(AbstractMethodStmtNode methodStmtNode) {
        if (methodStmtNode instanceof MethodStmtNode) {
            Method method = ((MethodStmtNode)methodStmtNode).method;
            return method.getOwner() + "->" + method.getName();
        }
        if (methodStmtNode instanceof MethodCustomStmtNode) {
            Method method = ((MethodCustomStmtNode)methodStmtNode).bsm.getMethod();
            return method.getOwner() + "->" + method.getName();
        }
        if (methodStmtNode instanceof MethodPolymorphicStmtNode) {
            Method method = ((MethodPolymorphicStmtNode)methodStmtNode).method;
            return method.getOwner() + "->" + method.getName();
        }
        return "Unknown method";
    }

    public static int descriptorLength(String[] types) {
        return Arrays.stream(types).mapToInt(s -> s.charAt(0) == 'J' || s.charAt(0) == 'D' ? 2 : 1).sum();
    }
}

