/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.io.ProgramClassWriter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.ClassPath;
import proguard.io.ClassPathEntry;

public class D8ClassConverter
implements ClassVisitor {
    private final D8DexFile dexFile;

    public D8ClassConverter(D8DexFile dexFile) {
        this.dexFile = dexFile;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitProgramClass(ProgramClass programClass) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            programClass.accept((ClassVisitor)new ProgramClassWriter((DataOutput)new DataOutputStream(byteArrayOutputStream)));
            byte[] classData = byteArrayOutputStream.toByteArray();
            D8DexFile d8DexFile = this.dexFile;
            synchronized (d8DexFile) {
                this.dexFile.addProgramClassData(classData);
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected error while converting:");
            System.err.println("  Class       = [" + programClass.getName() + "]");
            e.printStackTrace();
            System.err.println("Not converting this class");
        }
    }

    private static class InMemoryDexConsumer
    implements DexIndexedConsumer {
        private byte[] data;

        private InMemoryDexConsumer() {
        }

        public void accept(int fileIndex, ByteDataView data, Set<String> descriptors, DiagnosticsHandler handler) {
            this.data = data.copyByteData();
        }

        public void finished(DiagnosticsHandler handler) {
        }
    }

    public static class D8DexFile {
        private final InMemoryDexConsumer consumer;
        private final D8Command.Builder androidAppBuilder;
        private final int minSdkVersion;
        private final boolean debuggable;

        public D8DexFile(ClassPath libraryJars, int minSdkVersion, boolean debuggable) {
            this.minSdkVersion = minSdkVersion;
            this.debuggable = debuggable;
            this.consumer = new InMemoryDexConsumer();
            this.androidAppBuilder = D8Command.builder();
            if (libraryJars != null) {
                for (int index = 0; index < libraryJars.size(); ++index) {
                    ClassPathEntry classPathEntry = libraryJars.get(index);
                    if ((!Files.exists(classPathEntry.getFile().toPath(), new LinkOption[0]) || !classPathEntry.isDex()) && !D8DexFile.isArchive(classPathEntry)) continue;
                    this.androidAppBuilder.addLibraryFiles(new Path[]{classPathEntry.getFile().toPath()});
                }
            }
        }

        public static boolean isArchive(ClassPathEntry path) {
            return path.isApk() || path.isJar() || path.isAar() || path.isZip();
        }

        public void addProgramClassData(byte[] data) {
            this.androidAppBuilder.addClassProgramData(data, Origin.unknown());
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            try {
                D8.run((D8Command)((D8Command)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)this.androidAppBuilder.setMinApiLevel(this.minSdkVersion)).setDisableDesugaring(true)).setMode(this.debuggable ? CompilationMode.DEBUG : CompilationMode.RELEASE)).setProgramConsumer((ProgramConsumer)this.consumer)).setIntermediate(false).build()));
                outputStream.write(this.consumer.data);
                outputStream.flush();
            }
            catch (CompilationFailedException e) {
                throw new IOException(e);
            }
        }
    }
}

