/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.dexfile.converter.Dex2Pro;
import proguard.dexfile.reader.DexException;
import proguard.dexfile.reader.DexFileReader;
import proguard.dexfile.reader.node.DexFileNode;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.FileSource;
import proguard.io.JarReader;
import proguard.io.NameFilteredDataEntryReader;

public class DexClassReader
implements DataEntryReader {
    private final boolean readCode;
    private final ClassVisitor classVisitor;
    private final boolean usePrimitiveArrayConstants;

    public DexClassReader(boolean readCode, ClassVisitor classVisitor) {
        this(readCode, false, classVisitor);
    }

    public DexClassReader(boolean readCode, boolean usePrimitiveArrayConstants, ClassVisitor classVisitor) {
        this.readCode = readCode;
        this.usePrimitiveArrayConstants = usePrimitiveArrayConstants;
        this.classVisitor = classVisitor;
    }

    public void read(DataEntry dataEntry) throws IOException {
        try (InputStream inputStream = dataEntry.getInputStream();){
            DexFileNode fileNode = new DexFileNode();
            int readerConfig = this.readCode ? 0 : 133;
            new DexFileReader(inputStream).accept(fileNode, readerConfig);
            new Dex2Pro().usePrimitiveArrayConstants(this.usePrimitiveArrayConstants).convertDex(fileNode, this.classVisitor);
        }
        catch (DexException e) {
            throw new IOException("Dex file conversion failed: " + e.getMessage(), e);
        }
    }

    public static void main(String[] args) throws Exception {
        String fileName = args.length > 0 ? args[0] : "classes.dex";
        DexClassReader reader = new DexClassReader(true, (ClassVisitor)new ClassPrinter());
        if (!fileName.endsWith(".dex")) {
            reader = new JarReader((DataEntryReader)new NameFilteredDataEntryReader("**.dex", (DataEntryReader)reader));
        }
        new FileSource(new File(fileName)).pumpDataEntries((DataEntryReader)reader);
    }
}

