/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.UniqueClassFilter;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;
import proguard.util.StringMatcher;

public abstract class DexDataEntryWriter
implements DataEntryWriter {
    private final ClassPool classPool;
    private final StringMatcher classNameFilter;
    protected final String dexFileName;
    private final boolean forceDex;
    private final DataEntryReader extraDexDataEntryVisitor;
    protected final DataEntryWriter dexDataEntryWriter;
    protected final DataEntryWriter otherDataEntryWriter;
    private DataEntry currentDexEntry;
    private ClassVisitor currentClassConverter;

    public DexDataEntryWriter(ClassPool classPool, StringMatcher classNameFilter, String dexFileName, boolean forceDex, DataEntryReader extraDexDataEntryVisitor, DataEntryWriter dexDataEntryWriter, DataEntryWriter otherDataEntryWriter) {
        this.classPool = classPool;
        this.classNameFilter = classNameFilter;
        this.dexFileName = dexFileName;
        this.forceDex = forceDex;
        this.extraDexDataEntryVisitor = extraDexDataEntryVisitor;
        this.dexDataEntryWriter = dexDataEntryWriter;
        this.otherDataEntryWriter = otherDataEntryWriter;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        return this.dexDataEntryWriter.createDirectory(dataEntry);
    }

    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dexDataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        String name = dataEntry.getName();
        if (name.endsWith(".class")) {
            String className = name.substring(0, name.length() - ".class".length());
            if (this.classNameFilter == null || this.classNameFilter.matches(className)) {
                this.writeClass(className, dataEntry);
            }
            return new FilterOutputStream(null);
        }
        if (this.forceDex) {
            this.setUp(dataEntry);
        }
        return this.otherDataEntryWriter.createOutputStream(dataEntry);
    }

    public void close() throws IOException {
        this.finish();
        this.dexDataEntryWriter.close();
        this.otherDataEntryWriter.close();
    }

    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "DexDataEntryWriter");
        this.dexDataEntryWriter.println(pw, prefix + "  ");
        this.otherDataEntryWriter.println(pw, prefix + "  ");
    }

    private void writeClass(String className, DataEntry dataEntry) {
        Clazz clazz = this.classPool.getClass(className);
        if (clazz != null) {
            this.setUp(dataEntry);
            clazz.accept(this.currentClassConverter);
        }
    }

    private void setUp(DataEntry dataEntry) {
        if (this.currentDexEntry == null) {
            this.currentDexEntry = new DexDataEntry(dataEntry, this.dexFileName);
            this.currentClassConverter = new UniqueClassFilter(this.createClassConverter());
        }
    }

    private void finishIfNecessary(DataEntry dataEntry) throws IOException {
        if (this.currentDexEntry != null && !this.dexDataEntryWriter.sameOutputStream(this.currentDexEntry, (DataEntry)new DexDataEntry(dataEntry, this.dexFileName))) {
            this.finish();
        }
    }

    private void finish() throws IOException {
        if (this.currentDexEntry != null) {
            OutputStream outputStream = this.dexDataEntryWriter.createOutputStream(this.currentDexEntry);
            if (this.extraDexDataEntryVisitor != null) {
                this.extraDexDataEntryVisitor.read(this.currentDexEntry);
            }
            if (outputStream != null) {
                this.writeDex(outputStream);
            }
            this.currentDexEntry = null;
            this.currentClassConverter = null;
        }
    }

    abstract ClassVisitor createClassConverter();

    protected abstract void writeDex(OutputStream var1) throws IOException;

    private static class DexDataEntry
    extends RenamedDataEntry {
        public DexDataEntry(DataEntry dataEntry, String name) {
            super(dataEntry, name);
        }

        public String getOriginalName() {
            return this.getName();
        }
    }
}

