/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.util.HashSet;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassFeatureNameCollector;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.ClassPath;
import proguard.io.D8BasedDexDataEntryWriter;
import proguard.io.DataEntryClassInfoFilter;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.NameFilteredDataEntryWriter;
import proguard.io.NonClosingDataEntryWriter;
import proguard.util.ClassPoolFeatureNameFunction;
import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.StringFunction;
import proguard.util.StringMatcher;
import proguard.util.SuffixRemovingStringFunction;
import proguard.util.TransformedStringMatcher;

public class DexDataEntryWriterFactory {
    private final ClassPool programClassPool;
    private final int multiDexCount;
    private final boolean appBundle;
    private final ClassPath libraryJars;
    private final int minSdkVersion;
    private final boolean debuggable;
    private final DataEntryReader extraDexDataEntryVisitor;

    public DexDataEntryWriterFactory(ClassPool programClassPool, ClassPath libraryJars, boolean appBundle, int multiDexCount, int minSdkVersion, boolean debuggable, DataEntryReader extraDexDataEntryVisitor) {
        this.programClassPool = programClassPool;
        this.libraryJars = libraryJars;
        this.appBundle = appBundle;
        this.multiDexCount = multiDexCount;
        this.minSdkVersion = minSdkVersion;
        this.debuggable = debuggable;
        this.extraDexDataEntryVisitor = extraDexDataEntryVisitor;
    }

    public DataEntryWriter wrapInDexWriter(DataEntryWriter dexWriter) {
        return this.wrapInDexWriter(dexWriter, dexWriter);
    }

    private DataEntryWriter wrapInDexWriter(DataEntryWriter dexWriter, DataEntryWriter otherWriter) {
        HashSet featureNames = new HashSet();
        this.programClassPool.classesAccept((ClassVisitor)new ClassFeatureNameCollector(featureNames));
        if (featureNames.isEmpty()) {
            otherWriter = this.wrapInDexWriter(this.appBundle ? "base/dex/" : "", this.appBundle ? "base/root/" : "", dexWriter, otherWriter);
        } else {
            otherWriter = this.wrapInDexWriter("base/dex/", "base/root/", dexWriter, otherWriter);
            dexWriter = new NonClosingDataEntryWriter(dexWriter);
            for (String featureName : featureNames) {
                otherWriter = this.wrapInFeatureDexWriter(featureName, dexWriter, otherWriter);
            }
        }
        return otherWriter;
    }

    private DataEntryWriter wrapInFeatureDexWriter(String featureName, DataEntryWriter dexWriter, DataEntryWriter otherWriter) {
        return new NameFilteredDataEntryWriter((StringMatcher)new TransformedStringMatcher((StringFunction)new SuffixRemovingStringFunction(".class"), (StringMatcher)new TransformedStringMatcher((StringFunction)new ClassPoolFeatureNameFunction(this.programClassPool, "base"), (StringMatcher)new FixedStringMatcher(featureName, (StringMatcher)new EmptyStringMatcher()))), this.wrapInDexWriter(featureName + "/dex/", featureName + "/root/", dexWriter, otherWriter), otherWriter);
    }

    private DataEntryWriter wrapInDexWriter(String dexFilePrefix, String extraDexFilePrefix, DataEntryWriter dexWriter, DataEntryWriter otherWriter) {
        otherWriter = this.wrapInSimpleDexWriter(dexFilePrefix, dexWriter, otherWriter);
        dexWriter = new NonClosingDataEntryWriter(otherWriter);
        for (int index = this.multiDexCount; index > 0; --index) {
            otherWriter = this.wrapInMultiDexWriter(dexFilePrefix, dexWriter, otherWriter, index);
        }
        return otherWriter;
    }

    private DataEntryWriter wrapInSimpleDexWriter(String dexFilePrefix, DataEntryWriter dexWriter, DataEntryWriter otherWriter) {
        String dexFileName = dexFilePrefix + "classes.dex";
        return this.createDataEntryWriter(null, dexFileName, true, dexWriter, otherWriter);
    }

    private DataEntryWriter wrapInMultiDexWriter(String dexFilePrefix, DataEntryWriter dexWriter, DataEntryWriter otherWriter, int index) {
        String dexBaseName = "classes" + (index + 1) + ".dex";
        String dexFileName = dexFilePrefix + dexBaseName;
        return new FilteredDataEntryWriter((DataEntryFilter)new DataEntryClassInfoFilter(this.programClassPool, (Object)dexBaseName), this.createDataEntryWriter(null, dexFileName, false, dexWriter, otherWriter), otherWriter);
    }

    private DataEntryWriter createDataEntryWriter(StringMatcher classNameFilter, String dexFileName, boolean forceDex, DataEntryWriter dexWriter, DataEntryWriter otherWriter) {
        return new D8BasedDexDataEntryWriter(this.programClassPool, classNameFilter, this.libraryJars, dexFileName, forceDex, this.minSdkVersion, this.debuggable, this.extraDexDataEntryVisitor, dexWriter, otherWriter);
    }
}

