/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.editor.SubclassAdder;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;

public class ClassSubHierarchyInitializer
implements ClassPoolVisitor,
ClassVisitor {
    private Map<Clazz, Set<Clazz>> subClassesMap = new HashMap<Clazz, Set<Clazz>>();

    @Override
    public void visitClassPool(ClassPool classPool) {
        classPool.classesAccept(new MySubclassCollector());
        classPool.classesAccept(new MySubclassSetter());
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ReferencedClassVisitor subClassCollector = new ReferencedClassVisitor(new SubclassAdder(programClass));
        programClass.superClassConstantAccept(subClassCollector);
        programClass.interfaceConstantsAccept(subClassCollector);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        SubclassAdder subClassCollector = new SubclassAdder(libraryClass);
        libraryClass.superClassAccept(subClassCollector);
        libraryClass.interfacesAccept(subClassCollector);
    }

    private class MySubclassSetter
    implements ClassVisitor {
        private MySubclassSetter() {
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            Set subClasses = (Set)ClassSubHierarchyInitializer.this.subClassesMap.get(programClass);
            if (subClasses != null) {
                Clazz[] subClassesArray = subClasses.toArray(new Clazz[subClasses.size()]);
                programClass.subClasses = subClassesArray;
                programClass.subClassCount = subClassesArray.length;
            }
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            Set subClasses = (Set)ClassSubHierarchyInitializer.this.subClassesMap.get(libraryClass);
            if (subClasses != null) {
                Clazz[] subClassesArray = subClasses.toArray(new Clazz[subClasses.size()]);
                libraryClass.subClasses = subClassesArray;
                libraryClass.subClassCount = subClassesArray.length;
            }
        }
    }

    private class MySubclassAdder
    implements ClassVisitor {
        private final Clazz subClass;

        public MySubclassAdder(Clazz subClass) {
            this.subClass = subClass;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            Set subClasses = ClassSubHierarchyInitializer.this.subClassesMap.computeIfAbsent(clazz, newClass -> new LinkedHashSet());
            subClasses.add(this.subClass);
        }
    }

    private class MySubclassCollector
    implements ClassVisitor {
        private MySubclassCollector() {
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            ReferencedClassVisitor subClassCollector = new ReferencedClassVisitor(new MySubclassAdder(programClass));
            programClass.superClassConstantAccept(subClassCollector);
            programClass.interfaceConstantsAccept(subClassCollector);
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            MySubclassAdder subClassCollector = new MySubclassAdder(libraryClass);
            libraryClass.superClassAccept(subClassCollector);
            libraryClass.interfacesAccept(subClassCollector);
        }
    }
}

