/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ConstantValueFactory
implements ConstantVisitor {
    protected final ValueFactory valueFactory;
    protected Value value;

    public ConstantValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public Value constantValue(Clazz clazz, int constantIndex) {
        clazz.constantPoolEntryAccept(constantIndex, this);
        return this.value;
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.value = this.valueFactory.createIntegerValue(integerConstant.getValue());
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.value = this.valueFactory.createLongValue(longConstant.getValue());
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.value = this.valueFactory.createFloatValue(floatConstant.getValue());
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.value = this.valueFactory.createDoubleValue(doubleConstant.getValue());
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        this.value = this.valueFactory.createArrayReferenceValue("" + primitiveArrayConstant.getPrimitiveType(), null, this.valueFactory.createIntegerValue(primitiveArrayConstant.getLength()));
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.value = this.valueFactory.createReferenceValue("java/lang/String", stringConstant.javaLangStringClass, false, false);
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        String type = ClassUtil.internalMethodReturnType(dynamicConstant.getType(clazz));
        Clazz[] referencedClasses = dynamicConstant.referencedClasses;
        Clazz referencedClass = referencedClasses != null && referencedClasses.length > 0 && ClassUtil.isInternalClassType(type) ? referencedClasses[referencedClasses.length - 1] : null;
        this.value = this.valueFactory.createValue(type, referencedClass, true, true);
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.value = this.valueFactory.createReferenceValue("java/lang/invoke/MethodHandle", methodHandleConstant.javaLangInvokeMethodHandleClass, false, false);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.value = this.valueFactory.createReferenceValue(classConstant.getName(clazz), classConstant.referencedClass, false, false);
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.value = this.valueFactory.createReferenceValue("java/lang/invoke/MethodType", methodTypeConstant.javaLangInvokeMethodTypeClass, false, false);
    }
}

