/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import proguard.io.DEROutputStream;

class PKCS7OutputStream {
    private static final int PKCS7_VERSION = 1;
    private static final int SIGNER_VERSION = 1;
    private static final byte[] DATA_CONTENT = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
    private static final byte[] SDATA_CONTENT = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 2};
    private static final byte[] SHA1_DIGEST_ALGORITHM_ID = new byte[]{43, 14, 3, 2, 26};
    private static final byte[] SHA256_DIGEST_ALGORITHM_ID = new byte[]{96, -122, 72, 1, 101, 3, 4, 2, 1};
    private static final byte[] SHA384_DIGEST_ALGORITHM_ID = new byte[]{96, -122, 72, 1, 101, 3, 4, 2, 2};
    private static final byte[] SHA512_DIGEST_ALGORITHM_ID = new byte[]{96, -122, 72, 1, 101, 3, 4, 2, 3};
    private static final byte[] RSA_ENCRYPTION_ALGORITHM_ID = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] DH_ENCRYPTION_ALGORITHM_ID = new byte[]{42, -122, 72, -122, -9, 13, 1, 3, 1};
    private static final byte[] DSA_ENCRYPTION_ALGORITHM_ID = new byte[]{42, -122, 72, -50, 56, 4, 1};
    private static final byte[] EC_ENCRYPTION_ALGORITHM_ID = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final byte[] COMMON_NAME_OBJECT_ID = new byte[]{85, 4, 3};
    private static final byte[] SURNAME_OBJECT_ID = new byte[]{85, 4, 4};
    private static final byte[] SERIAL_NUMBER_OBJECT_ID = new byte[]{85, 4, 5};
    private static final byte[] COUNTRY_NAME_OBJECT_ID = new byte[]{85, 4, 6};
    private static final byte[] LOCALITY_NAME_OBJECT_ID = new byte[]{85, 4, 7};
    private static final byte[] STATE_NAME_OBJECT_ID = new byte[]{85, 4, 8};
    private static final byte[] STREET_ADDRESS_OBJECT_ID = new byte[]{85, 4, 9};
    private static final byte[] ORGANIZATION_NAME_OBJECT_ID = new byte[]{85, 4, 10};
    private static final byte[] UNIT_NAME_OBJECT_ID = new byte[]{85, 4, 11};
    private static final byte[] TITLE_OBJECT_ID = new byte[]{85, 4, 12};
    private static final byte[] GIVEN_NAME_OBJECT_ID = new byte[]{85, 4, 42};
    private static final byte[] EMAIL_ADDRESS_OBJECT_ID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    private static final String COMMON_NAME_ATTRIBUTE = "CN";
    private static final String SURNAME_ATTRIBUTE = "SN";
    private static final String SERIAL_NUMBER_ATTRIBUTE = "SERIALNUMBER";
    private static final String COUNTRY_NAME_ATTRIBUTE = "C";
    private static final String LOCALITY_NAME_ATTRIBUTE = "L";
    private static final String STATE_NAME_ATTRIBUTE = "ST";
    private static final String STREET_ADDRESS_ATTRIBUTE = "STREET";
    private static final String ORGANIZATION_NAME_ATTRIBUTE = "O";
    private static final String UNIT_NAME_ATTRIBUTE = "OU";
    private static final String TITLE_ATTRIBUTE = "T";
    private static final String GIVEN_NAME_ATTRIBUTE = "GN";
    private static final String EMAIL_ADDRESS_ATTRIBUTE = "EMAILADDRESS";
    private final DEROutputStream derOutputStream;

    public PKCS7OutputStream(DEROutputStream derOutputStream) {
        this.derOutputStream = derOutputStream;
    }

    public void writeSignature(X509Certificate certificate, String digestAlgorithm, String encryptionAlgorithm, byte[] digitalSignatureBytes) throws IOException, CertificateEncodingException {
        this.derOutputStream.startSequence();
        this.derOutputStream.writeObjectIdentifier(SDATA_CONTENT);
        this.derOutputStream.startImplicit();
        this.derOutputStream.startSequence();
        this.derOutputStream.writeInteger(1);
        this.derOutputStream.startSet();
        this.writeNullAttribute(this.encodedDigestAlgorithmOid(digestAlgorithm));
        this.derOutputStream.endSet();
        this.derOutputStream.startSequence();
        this.derOutputStream.writeObjectIdentifier(DATA_CONTENT);
        this.derOutputStream.endSequence();
        this.derOutputStream.writeImplicit(certificate.getEncoded());
        this.writeSignerSingleton(certificate, digestAlgorithm, encryptionAlgorithm, digitalSignatureBytes);
        this.derOutputStream.endSequence();
        this.derOutputStream.endImplicit();
        this.derOutputStream.endSequence();
    }

    public void flush() throws IOException {
        this.derOutputStream.flush();
    }

    public void close() throws IOException {
        this.derOutputStream.close();
    }

    private void writeSignerSingleton(X509Certificate certificate, String digestAlgorithm, String encryptionAlgorithm, byte[] digitalSignatureBytes) throws IOException {
        this.derOutputStream.startSet();
        this.writeSigner(certificate, digestAlgorithm, encryptionAlgorithm, digitalSignatureBytes);
        this.derOutputStream.endSet();
    }

    private void writeSigner(X509Certificate certificate, String digestAlgorithm, String encryptionAlgorithm, byte[] digitalSignatureBytes) throws IOException {
        this.derOutputStream.startSequence();
        this.derOutputStream.writeInteger(1);
        this.writeSignerCertificateInfo(certificate);
        this.writeNullAttribute(this.encodedDigestAlgorithmOid(digestAlgorithm));
        this.writeNullAttribute(this.encodedEncryptionAlgorithmOid(encryptionAlgorithm));
        this.derOutputStream.writeOctetString(digitalSignatureBytes);
        this.derOutputStream.endSequence();
    }

    private void writeSignerCertificateInfo(X509Certificate certificate) throws IOException {
        int commaIndex;
        this.derOutputStream.startSequence();
        this.derOutputStream.startSequence();
        String distinguishedName = certificate.getIssuerDN().getName();
        int endIndex = distinguishedName.length();
        do {
            String attributeValue;
            boolean quoted = distinguishedName.charAt(endIndex - 1) == '\"';
            int commaEndIndex = quoted ? distinguishedName.lastIndexOf(34, endIndex - 2) : endIndex - 1;
            commaIndex = distinguishedName.lastIndexOf(44, commaEndIndex);
            String attribute = distinguishedName.substring(commaIndex + 1, endIndex);
            int equalsIndex = attribute.indexOf(61);
            String attributeName = attribute.substring(0, equalsIndex).trim();
            String string = attributeValue = quoted ? attribute.substring(equalsIndex + 2, attribute.length() - 1) : this.trimSpaces(attribute.substring(equalsIndex + 1));
            if (attributeName.equals(COMMON_NAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(COMMON_NAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(SURNAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(SURNAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(SERIAL_NUMBER_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(SERIAL_NUMBER_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(COUNTRY_NAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(COUNTRY_NAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(LOCALITY_NAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(LOCALITY_NAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(STATE_NAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(STATE_NAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(STREET_ADDRESS_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(STREET_ADDRESS_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(ORGANIZATION_NAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(ORGANIZATION_NAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(UNIT_NAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(UNIT_NAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(TITLE_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(TITLE_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (attributeName.equals(GIVEN_NAME_ATTRIBUTE)) {
                this.writeStringAttributeSingleton(GIVEN_NAME_OBJECT_ID, attributeValue, false);
                continue;
            }
            if (!attributeName.equals(EMAIL_ADDRESS_ATTRIBUTE)) continue;
            this.writeStringAttributeSingleton(EMAIL_ADDRESS_OBJECT_ID, attributeValue, true);
        } while ((endIndex = commaIndex) > 0);
        this.derOutputStream.endSequence();
        this.derOutputStream.writeInteger(certificate.getSerialNumber());
        this.derOutputStream.endSequence();
    }

    private String trimSpaces(String string) {
        int endIndex;
        int startIndex;
        for (startIndex = 0; startIndex < string.length() && string.charAt(startIndex) == ' '; ++startIndex) {
        }
        for (endIndex = string.length(); endIndex >= startIndex && string.charAt(endIndex - 1) == ' '; --endIndex) {
        }
        return string.substring(startIndex, endIndex);
    }

    private void writeStringAttributeSingleton(byte[] attributeIdentifier, String attributeValue, boolean asIA5String) throws IOException {
        this.derOutputStream.startSet();
        this.writeStringAttribute(attributeIdentifier, attributeValue, asIA5String);
        this.derOutputStream.endSet();
    }

    private void writeStringAttribute(byte[] attributeIdentifier, String attributeValue, boolean asIA5String) throws IOException {
        this.derOutputStream.startSequence();
        this.derOutputStream.writeObjectIdentifier(attributeIdentifier);
        this.derOutputStream.writeString(attributeValue, asIA5String);
        this.derOutputStream.endSequence();
    }

    private void writeNullAttribute(byte[] attributeName) throws IOException {
        this.derOutputStream.startSequence();
        this.derOutputStream.writeObjectIdentifier(attributeName);
        this.derOutputStream.writeNull();
        this.derOutputStream.endSequence();
    }

    private byte[] encodedDigestAlgorithmOid(String digestAlgorithm) {
        return digestAlgorithm.equals("SHA") || digestAlgorithm.equals("SHA1") || digestAlgorithm.equals("SHA-1") ? SHA1_DIGEST_ALGORITHM_ID : (digestAlgorithm.equals("SHA256") || digestAlgorithm.equals("SHA-256") ? SHA256_DIGEST_ALGORITHM_ID : (digestAlgorithm.equals("SHA384") || digestAlgorithm.equals("SHA-384") ? SHA384_DIGEST_ALGORITHM_ID : (digestAlgorithm.equals("SHA512") || digestAlgorithm.equals("SHA-512") ? SHA512_DIGEST_ALGORITHM_ID : this.throwNewIllegalArgumentException("Unsupported digest algorithm [" + digestAlgorithm + "]"))));
    }

    private byte[] encodedEncryptionAlgorithmOid(String encryptionAlgorithm) {
        return encryptionAlgorithm.equals("RSA") ? RSA_ENCRYPTION_ALGORITHM_ID : (encryptionAlgorithm.equals("DH") || encryptionAlgorithm.equals("Diffie-Hellman") ? DH_ENCRYPTION_ALGORITHM_ID : (encryptionAlgorithm.equals("DSA") ? DSA_ENCRYPTION_ALGORITHM_ID : (encryptionAlgorithm.equals("EC") ? EC_ENCRYPTION_ALGORITHM_ID : this.throwNewIllegalArgumentException("Unsupported encryption algorithm [" + encryptionAlgorithm + "]"))));
    }

    private byte[] throwNewIllegalArgumentException(String message) {
        throw new IllegalArgumentException(message);
    }

    public static void main(String[] args) {
        String inputCertificateFileName = args[0];
        String outputCertificateFileName = args[1];
        try {
            System.out.println("Reading [" + inputCertificateFileName + "]");
            FileInputStream inputStream = new FileInputStream(inputCertificateFileName);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(inputStream);
            int counter = 0;
            for (X509Certificate x509Certificate : certificates) {
                System.out.println("IssuerDN:   " + x509Certificate.getIssuerDN());
                System.out.println("SigAlgName: " + x509Certificate.getSigAlgName());
                System.out.println("Signature:  " + Arrays.toString(x509Certificate.getSignature()));
                String fileName = counter == 0 ? outputCertificateFileName : outputCertificateFileName + counter;
                System.out.println("Writing [" + fileName + "]");
                FileOutputStream outputStream = new FileOutputStream(fileName);
                DEROutputStream derOutputStream = new DEROutputStream(outputStream);
                PKCS7OutputStream pkcs7OutputStream = new PKCS7OutputStream(derOutputStream);
                String sigAlgName = x509Certificate.getSigAlgName();
                int withIndex = sigAlgName.indexOf("with");
                String digestAlgorithm = withIndex < 0 ? "SHA1" : sigAlgName.substring(0, withIndex);
                String encryptionAlgorithm = withIndex < 0 ? "RSA" : sigAlgName.substring(withIndex + 4);
                pkcs7OutputStream.writeSignature(x509Certificate, digestAlgorithm, encryptionAlgorithm, new byte[x509Certificate.getSignature().length]);
                pkcs7OutputStream.close();
                System.out.println();
                ++counter;
            }
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

