/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.io;

import java.io.IOException;
import java.io.OutputStream;
import kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlinx.metadata.jvm.KmModule;
import kotlinx.metadata.jvm.KmModuleVisitor;
import kotlinx.metadata.jvm.KotlinModuleMetadata;
import proguard.classfile.util.ClassUtil;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;

public class KotlinModuleWriter
implements ResourceFileVisitor {
    private final OutputStream outputStream;

    public KotlinModuleWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        try {
            KotlinModuleMetadata.Writer writer = new KotlinModuleMetadata.Writer();
            KmModule kmModule = new KmModule();
            kotlinModule.modulePackagesAccept((module, modulePackage) -> kmModule.visitPackageParts(ClassUtil.externalClassName(modulePackage.fqName), modulePackage.fileFacadeNames, modulePackage.multiFileClassParts));
            kmModule.visitEnd();
            kmModule.accept((KmModuleVisitor)writer);
            byte[] transformedBytes = writer.write(JvmMetadataVersion.INSTANCE.toArray()).getBytes();
            this.outputStream.write(transformedBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing module file", e);
        }
    }
}

