/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.kotlin;

import java.util.ArrayList;
import java.util.List;
import kotlinx.metadata.InconsistentKotlinMetadataException;
import kotlinx.metadata.KmAnnotation;
import kotlinx.metadata.KmClassExtensionVisitor;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorExtensionVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmContractVisitor;
import kotlinx.metadata.KmEffectExpressionVisitor;
import kotlinx.metadata.KmEffectInvocationKind;
import kotlinx.metadata.KmEffectType;
import kotlinx.metadata.KmEffectVisitor;
import kotlinx.metadata.KmExtensionType;
import kotlinx.metadata.KmFunctionExtensionVisitor;
import kotlinx.metadata.KmFunctionVisitor;
import kotlinx.metadata.KmLambdaVisitor;
import kotlinx.metadata.KmPackageExtensionVisitor;
import kotlinx.metadata.KmPackageVisitor;
import kotlinx.metadata.KmPropertyExtensionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.KmTypeAliasVisitor;
import kotlinx.metadata.KmTypeExtensionVisitor;
import kotlinx.metadata.KmTypeParameterExtensionVisitor;
import kotlinx.metadata.KmTypeParameterVisitor;
import kotlinx.metadata.KmTypeVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.KmVariance;
import kotlinx.metadata.KmVersionRequirementLevel;
import kotlinx.metadata.KmVersionRequirementVersionKind;
import kotlinx.metadata.KmVersionRequirementVisitor;
import kotlinx.metadata.jvm.JvmClassExtensionVisitor;
import kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPackageExtensionVisitor;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeParameterExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.JvmFieldSignature;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataAnnotation;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataInitializer
implements AnnotationVisitor,
ElementValueVisitor,
ConstantVisitor {
    private int k;
    private int[] mv;
    private int[] bv;
    private String[] d1;
    private String[] d2;
    private int xi;
    private String xs;
    private String pn;
    private MetadataType currentType;
    private final WarningPrinter warningPrinter;

    public KotlinMetadataInitializer(WarningPrinter warningPrinter) {
        this.warningPrinter = warningPrinter;
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.k = -1;
        this.mv = null;
        this.bv = null;
        this.d1 = null;
        this.d2 = null;
        this.xi = 0;
        this.xs = null;
        this.pn = null;
        annotation.elementValuesAccept(clazz, this);
        KotlinClassMetadata md = KotlinClassMetadata.read((KotlinClassHeader)new KotlinClassHeader(Integer.valueOf(this.k), this.mv, this.bv, this.d1, this.d2, this.xs, this.pn, Integer.valueOf(this.xi)));
        if (md == null) {
            throw new UnsupportedOperationException("Encountered corrupt @kotlin/Metadata for class " + clazz.getName() + ".");
        }
        try {
            switch (this.k) {
                case 1: {
                    KotlinClassKindMetadata kotlinClassKindMetadata = new KotlinClassKindMetadata(this.mv, this.bv, this.xi, this.xs, this.pn);
                    ((KotlinClassMetadata.Class)md).accept((KmClassVisitor)new ClassReader(kotlinClassKindMetadata));
                    kotlinClassKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinClassKindMetadata));
                    break;
                }
                case 2: {
                    KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata = new KotlinFileFacadeKindMetadata(this.mv, this.bv, this.xi, this.xs, this.pn);
                    ((KotlinClassMetadata.FileFacade)md).accept((KmPackageVisitor)new PackageReader(kotlinFileFacadeKindMetadata));
                    kotlinFileFacadeKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinFileFacadeKindMetadata));
                    break;
                }
                case 3: {
                    KotlinClassMetadata.SyntheticClass smd = (KotlinClassMetadata.SyntheticClass)md;
                    KotlinSyntheticClassKindMetadata.Flavor flavor = smd.isLambda() ? KotlinSyntheticClassKindMetadata.Flavor.LAMBDA : (clazz.getName().endsWith("$DefaultImpls") ? KotlinSyntheticClassKindMetadata.Flavor.DEFAULT_IMPLS : (clazz.getName().endsWith("$WhenMappings") ? KotlinSyntheticClassKindMetadata.Flavor.WHEN_MAPPINGS : KotlinSyntheticClassKindMetadata.Flavor.REGULAR));
                    KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata = new KotlinSyntheticClassKindMetadata(this.mv, this.bv, this.xi, this.xs, this.pn, flavor);
                    if (smd.isLambda()) {
                        smd.accept((KmLambdaVisitor)new LambdaReader(kotlinSyntheticClassKindMetadata));
                    } else {
                        kotlinSyntheticClassKindMetadata.functions = KotlinMetadataInitializer.trimmed(new ArrayList(0));
                    }
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinSyntheticClassKindMetadata));
                    break;
                }
                case 4: {
                    clazz.accept(new SimpleKotlinMetadataSetter(new KotlinMultiFileFacadeKindMetadata(this.mv, this.bv, this.d1, this.xi, this.xs, this.pn)));
                    break;
                }
                case 5: {
                    KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata = new KotlinMultiFilePartKindMetadata(this.mv, this.bv, this.xi, this.xs, this.pn);
                    ((KotlinClassMetadata.MultiFileClassPart)md).accept((KmPackageVisitor)new PackageReader(kotlinMultiFilePartKindMetadata));
                    kotlinMultiFilePartKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinMultiFilePartKindMetadata));
                    break;
                }
                default: {
                    this.warningPrinter.print(clazz.getName(), "Unknown Kotlin class kind in class " + clazz.getName() + ". The metadata for this class will not be processed.");
                    break;
                }
            }
        }
        catch (InconsistentKotlinMetadataException e) {
            this.warningPrinter.print(clazz.getName(), "Encountered corrupt Kotlin metadata in class " + clazz.getName() + ". The metadata for this class will not be processed (" + e.getMessage() + ")");
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.currentType = MetadataType.valueOf(constantElementValue.getMethodName(clazz));
        clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        MetadataType arrayElementType = MetadataType.valueOf(arrayElementValue.getMethodName(clazz));
        switch (arrayElementType) {
            case mv: {
                this.mv = new int[arrayElementValue.u2elementValuesCount];
                break;
            }
            case bv: {
                this.bv = new int[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d1: {
                this.d1 = new String[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d2: {
                this.d2 = new String[arrayElementValue.u2elementValuesCount];
            }
        }
        arrayElementValue.elementValuesAccept(clazz, annotation, new ArrayElementValueCollector(arrayElementType));
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.currentType == MetadataType.xs) {
            this.xs = utf8Constant.getString();
        } else if (this.currentType == MetadataType.pn) {
            this.pn = utf8Constant.getString();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        if (this.currentType == MetadataType.k) {
            this.k = integerConstant.getValue();
        } else if (this.currentType == MetadataType.xi) {
            this.xi = integerConstant.getValue();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    private static <K> List<K> trimmed(ArrayList<K> list) {
        list.trimToSize();
        return list;
    }

    private static proguard.classfile.kotlin.JvmMethodSignature fromKotlinJvmMethodSignature(JvmMethodSignature jvmMethodSignature) {
        if (jvmMethodSignature == null) {
            return null;
        }
        return new proguard.classfile.kotlin.JvmMethodSignature(jvmMethodSignature.getName(), jvmMethodSignature.getDesc());
    }

    private static JvmFieldSignature fromKotlinJvmFieldSignature(kotlinx.metadata.jvm.JvmFieldSignature jvmFieldSignature) {
        if (jvmFieldSignature == null) {
            return null;
        }
        return new JvmFieldSignature(jvmFieldSignature.getName(), jvmFieldSignature.getDesc());
    }

    private class VersionRequirementReader
    extends KmVersionRequirementVisitor {
        private final KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata;

        VersionRequirementReader(KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kotlinVersionRequirementMetadata = kotlinVersionRequirementMetadata;
        }

        public void visit(KmVersionRequirementVersionKind kind, KmVersionRequirementLevel level, Integer errorCode, String message) {
            this.kotlinVersionRequirementMetadata.kind = kind;
            this.kotlinVersionRequirementMetadata.level = level;
            this.kotlinVersionRequirementMetadata.errorCode = errorCode;
            this.kotlinVersionRequirementMetadata.message = message;
        }

        public void visitVersion(int major, int minor, int patch) {
            this.kotlinVersionRequirementMetadata.major = major;
            this.kotlinVersionRequirementMetadata.minor = minor;
            this.kotlinVersionRequirementMetadata.patch = patch;
        }

        public void visitEnd() {
        }
    }

    private class TypeParameterReader
    extends KmTypeParameterVisitor {
        private final KotlinTypeParameterMetadata kotlinTypeParameterMetadata;
        private final ArrayList<KotlinTypeMetadata> upperBounds;

        TypeParameterReader(KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kotlinTypeParameterMetadata = kotlinTypeParameterMetadata;
            this.upperBounds = new ArrayList();
        }

        public KmTypeParameterExtensionVisitor visitExtensions(KmExtensionType type) {
            return new TypeParameterExtensionReader();
        }

        public KmTypeVisitor visitUpperBound(int flags) {
            KotlinTypeMetadata upperBound = new KotlinTypeMetadata(flags);
            this.upperBounds.add(upperBound);
            return new TypeReader(upperBound);
        }

        public void visitEnd() {
            this.kotlinTypeParameterMetadata.upperBounds = this.upperBounds;
        }

        private class TypeParameterExtensionReader
        extends JvmTypeParameterExtensionVisitor {
            private final ArrayList<KotlinMetadataAnnotation> annotations = new ArrayList(1);

            private TypeParameterExtensionReader() {
            }

            public void visitAnnotation(KmAnnotation annotation) {
                this.annotations.add(new KotlinMetadataAnnotation(annotation));
            }

            public void visitEnd() {
                ((TypeParameterReader)TypeParameterReader.this).kotlinTypeParameterMetadata.annotations = KotlinMetadataInitializer.trimmed(this.annotations);
                ((TypeParameterReader)TypeParameterReader.this).kotlinTypeParameterMetadata.flags.common.hasAnnotations = !this.annotations.isEmpty();
            }
        }
    }

    private class TypeReader
    extends KmTypeVisitor {
        private KotlinTypeMetadata kotlinTypeMetadata;
        private final ArrayList<KotlinTypeMetadata> typeArguments;
        private final ArrayList<KotlinTypeMetadata> upperBounds;
        private final ArrayList<KotlinMetadataAnnotation> annotations;

        TypeReader(KotlinTypeMetadata kotlinTypeMetadata) {
            this.kotlinTypeMetadata = kotlinTypeMetadata;
            this.typeArguments = new ArrayList(2);
            this.annotations = new ArrayList(1);
            this.upperBounds = new ArrayList();
        }

        public KmTypeVisitor visitAbbreviatedType(int flags) {
            KotlinTypeMetadata abbreviatedType;
            this.kotlinTypeMetadata.abbreviation = abbreviatedType = new KotlinTypeMetadata(flags);
            return new TypeReader(abbreviatedType);
        }

        public void visitClass(String className) {
            if (ClassUtil.isInternalClassType(className)) {
                className = ClassUtil.internalClassNameFromClassType(className);
            }
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            this.kotlinTypeMetadata.className = className = className.replace('.', '$');
        }

        public void visitTypeParameter(int id) {
            this.kotlinTypeMetadata.typeParamID = id;
        }

        public void visitTypeAlias(String aliasName) {
            this.kotlinTypeMetadata.aliasName = aliasName;
        }

        public KmTypeVisitor visitOuterType(int flags) {
            KotlinTypeMetadata outerType;
            this.kotlinTypeMetadata.outerClassType = outerType = new KotlinTypeMetadata(flags);
            return new TypeReader(outerType);
        }

        public KmTypeVisitor visitArgument(int flags, KmVariance variance) {
            KotlinTypeMetadata typeArgument = new KotlinTypeMetadata(flags, variance);
            this.typeArguments.add(typeArgument);
            return new TypeReader(typeArgument);
        }

        public void visitStarProjection() {
            this.typeArguments.add(KotlinTypeMetadata.starProjection());
        }

        public KmTypeVisitor visitFlexibleTypeUpperBound(int flags, String typeFlexibilityId) {
            this.kotlinTypeMetadata.flexibilityID = typeFlexibilityId;
            KotlinTypeMetadata upperBound = new KotlinTypeMetadata(flags);
            this.upperBounds.add(upperBound);
            return new TypeReader(upperBound);
        }

        public KmTypeExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new TypeExtensionReader();
        }

        public void visitEnd() {
            this.kotlinTypeMetadata.typeArguments = KotlinMetadataInitializer.trimmed(this.typeArguments);
            this.kotlinTypeMetadata.annotations = KotlinMetadataInitializer.trimmed(this.annotations);
            this.kotlinTypeMetadata.upperBounds = KotlinMetadataInitializer.trimmed(this.upperBounds);
            this.kotlinTypeMetadata.flags.common.hasAnnotations = !this.annotations.isEmpty();
        }

        private class TypeExtensionReader
        extends JvmTypeExtensionVisitor {
            private TypeExtensionReader() {
            }

            public void visit(boolean isRaw) {
                ((TypeReader)TypeReader.this).kotlinTypeMetadata.isRaw = isRaw;
            }

            public void visitAnnotation(KmAnnotation annotation) {
                TypeReader.this.annotations.add(new KotlinMetadataAnnotation(annotation));
            }

            public void visitEnd() {
            }
        }
    }

    private class ValueParameterReader
    extends KmValueParameterVisitor {
        private final KotlinValueParameterMetadata kotlinValueParameterMetadata;

        ValueParameterReader(KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kotlinValueParameterMetadata = kotlinValueParameterMetadata;
        }

        public KmTypeVisitor visitType(int flags) {
            KotlinTypeMetadata type;
            this.kotlinValueParameterMetadata.type = type = new KotlinTypeMetadata(flags);
            return new TypeReader(type);
        }

        public KmTypeVisitor visitVarargElementType(int flags) {
            KotlinTypeMetadata varArgType;
            this.kotlinValueParameterMetadata.varArgElementType = varArgType = new KotlinTypeMetadata(flags);
            return new TypeReader(varArgType);
        }

        public void visitEnd() {
        }
    }

    private class EffectExpressionReader
    extends KmEffectExpressionVisitor {
        private final KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata;
        private final List<KotlinEffectExpressionMetadata> andRightHandSides = new ArrayList<KotlinEffectExpressionMetadata>();
        private final List<KotlinEffectExpressionMetadata> orRightHandSides = new ArrayList<KotlinEffectExpressionMetadata>();

        EffectExpressionReader(KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kotlinEffectExpressionMetadata = kotlinEffectExpressionMetadata;
        }

        public void visit(int flags, Integer parameterIndex) {
            this.kotlinEffectExpressionMetadata.setMetadataFlags(flags);
            if (parameterIndex != null) {
                this.kotlinEffectExpressionMetadata.parameterIndex = parameterIndex;
            }
        }

        public void visitConstantValue(Object o) {
            this.kotlinEffectExpressionMetadata.hasConstantValue = true;
            this.kotlinEffectExpressionMetadata.constantValue = o;
        }

        public KmTypeVisitor visitIsInstanceType(int flags) {
            KotlinTypeMetadata typeOfIs;
            this.kotlinEffectExpressionMetadata.typeOfIs = typeOfIs = new KotlinTypeMetadata(flags);
            return new TypeReader(typeOfIs);
        }

        public KmEffectExpressionVisitor visitAndArgument() {
            KotlinEffectExpressionMetadata andRHS = new KotlinEffectExpressionMetadata();
            this.andRightHandSides.add(andRHS);
            return new EffectExpressionReader(andRHS);
        }

        public KmEffectExpressionVisitor visitOrArgument() {
            KotlinEffectExpressionMetadata orRHS = new KotlinEffectExpressionMetadata();
            this.orRightHandSides.add(orRHS);
            return new EffectExpressionReader(orRHS);
        }

        public void visitEnd() {
            this.kotlinEffectExpressionMetadata.andRightHandSides = this.andRightHandSides;
            this.kotlinEffectExpressionMetadata.orRightHandSides = this.orRightHandSides;
        }
    }

    private class EffectReader
    extends KmEffectVisitor {
        private final KotlinEffectMetadata kotlinEffectMetadata;
        private final ArrayList<KotlinEffectExpressionMetadata> constructorArguments = new ArrayList();

        EffectReader(KotlinEffectMetadata kotlinEffectMetadata) {
            this.kotlinEffectMetadata = kotlinEffectMetadata;
        }

        public KmEffectExpressionVisitor visitConclusionOfConditionalEffect() {
            KotlinEffectExpressionMetadata conclusion;
            this.kotlinEffectMetadata.conclusionOfConditionalEffect = conclusion = new KotlinEffectExpressionMetadata();
            return new EffectExpressionReader(conclusion);
        }

        public KmEffectExpressionVisitor visitConstructorArgument() {
            KotlinEffectExpressionMetadata constructorArg = new KotlinEffectExpressionMetadata();
            this.constructorArguments.add(constructorArg);
            return new EffectExpressionReader(constructorArg);
        }

        public void visitEnd() {
            this.kotlinEffectMetadata.constructorArguments = KotlinMetadataInitializer.trimmed(this.constructorArguments);
        }
    }

    private class ContractReader
    extends KmContractVisitor {
        private final KotlinContractMetadata kotlinContractMetadata;
        private final ArrayList<KotlinEffectMetadata> effects;

        ContractReader(KotlinContractMetadata kotlinContractMetadata) {
            this.kotlinContractMetadata = kotlinContractMetadata;
            this.effects = new ArrayList(2);
        }

        public KmEffectVisitor visitEffect(KmEffectType effectType, KmEffectInvocationKind invocationKind) {
            KotlinEffectMetadata effect = new KotlinEffectMetadata(effectType, invocationKind);
            this.effects.add(effect);
            return new EffectReader(effect);
        }

        public void visitEnd() {
            this.kotlinContractMetadata.effects = KotlinMetadataInitializer.trimmed(this.effects);
        }
    }

    private class FunctionReader
    extends KmFunctionVisitor {
        private final KotlinFunctionMetadata kotlinFunctionMetadata;
        private final ArrayList<KotlinContractMetadata> contracts;
        private final ArrayList<KotlinValueParameterMetadata> valueParameters;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        FunctionReader(KotlinFunctionMetadata kotlinFunctionMetadata) {
            this.kotlinFunctionMetadata = kotlinFunctionMetadata;
            this.contracts = new ArrayList(1);
            this.valueParameters = new ArrayList(4);
            this.typeParameters = new ArrayList(1);
        }

        public KmContractVisitor visitContract() {
            KotlinContractMetadata contract = new KotlinContractMetadata();
            this.contracts.add(contract);
            return new ContractReader(contract);
        }

        public KmTypeVisitor visitReceiverParameterType(int flags) {
            KotlinTypeMetadata receiverType;
            this.kotlinFunctionMetadata.receiverType = receiverType = new KotlinTypeMetadata(flags);
            return new TypeReader(receiverType);
        }

        public KmTypeVisitor visitReturnType(int flags) {
            KotlinTypeMetadata returnType;
            this.kotlinFunctionMetadata.returnType = returnType = new KotlinTypeMetadata(flags);
            return new TypeReader(returnType);
        }

        public KmTypeParameterVisitor visitTypeParameter(int flags, String name, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(flags, name, id, variance);
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        public KmValueParameterVisitor visitValueParameter(int flags, String name) {
            KotlinValueParameterMetadata valueParameter = new KotlinValueParameterMetadata(flags, this.valueParameters.size(), name);
            this.valueParameters.add(valueParameter);
            return new ValueParameterReader(valueParameter);
        }

        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinFunctionMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        public KmFunctionExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new FunctionExtensionReader();
        }

        public void visitEnd() {
            this.kotlinFunctionMetadata.contracts = KotlinMetadataInitializer.trimmed(this.contracts);
            this.kotlinFunctionMetadata.valueParameters = KotlinMetadataInitializer.trimmed(this.valueParameters);
            this.kotlinFunctionMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
        }

        private class FunctionExtensionReader
        extends JvmFunctionExtensionVisitor {
            private FunctionExtensionReader() {
            }

            public void visit(JvmMethodSignature signature) {
                ((FunctionReader)FunctionReader.this).kotlinFunctionMetadata.jvmSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(signature);
            }

            public void visitLambdaClassOriginName(String internalName) {
                ((FunctionReader)FunctionReader.this).kotlinFunctionMetadata.lambdaClassOriginName = internalName;
            }

            public void visitEnd() {
            }
        }
    }

    private class PackageReader
    extends KmPackageVisitor {
        private final KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata;
        private final ArrayList<KotlinPropertyMetadata> properties;
        private final ArrayList<KotlinFunctionMetadata> functions;
        private final ArrayList<KotlinTypeAliasMetadata> typeAliases;
        private final ArrayList<KotlinPropertyMetadata> localDelegatedProperties;

        PackageReader(KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            this.kotlinDeclarationContainerMetadata = kotlinDeclarationContainerMetadata;
            this.properties = new ArrayList(8);
            this.functions = new ArrayList(8);
            this.typeAliases = new ArrayList(2);
            this.localDelegatedProperties = new ArrayList(2);
        }

        public KmFunctionVisitor visitFunction(int flags, String name) {
            KotlinFunctionMetadata function = new KotlinFunctionMetadata(flags, name);
            this.functions.add(function);
            return new FunctionReader(function);
        }

        public KmPropertyVisitor visitProperty(int flags, String name, int getterFlags, int setterFlags) {
            KotlinPropertyMetadata property = new KotlinPropertyMetadata(flags, name, getterFlags, setterFlags);
            this.properties.add(property);
            return new PropertyReader(property);
        }

        public KmTypeAliasVisitor visitTypeAlias(int flags, String name) {
            KotlinTypeAliasMetadata typeAlias = new KotlinTypeAliasMetadata(flags, name);
            this.typeAliases.add(typeAlias);
            return new TypeAliasReader(typeAlias);
        }

        public KmPackageExtensionVisitor visitExtensions(KmExtensionType type) {
            return new PackageExtensionReader();
        }

        public void visitEnd() {
            this.kotlinDeclarationContainerMetadata.properties = KotlinMetadataInitializer.trimmed(this.properties);
            this.kotlinDeclarationContainerMetadata.functions = KotlinMetadataInitializer.trimmed(this.functions);
            this.kotlinDeclarationContainerMetadata.typeAliases = KotlinMetadataInitializer.trimmed(this.typeAliases);
            this.kotlinDeclarationContainerMetadata.localDelegatedProperties = KotlinMetadataInitializer.trimmed(this.localDelegatedProperties);
        }

        private class PackageExtensionReader
        extends JvmPackageExtensionVisitor {
            private PackageExtensionReader() {
            }

            public KmPropertyVisitor visitLocalDelegatedProperty(int flags, String name, int getterFlags, int setterFlags) {
                KotlinPropertyMetadata delegatedProperty = new KotlinPropertyMetadata(flags, name, getterFlags, setterFlags);
                PackageReader.this.localDelegatedProperties.add(delegatedProperty);
                return new PropertyReader(delegatedProperty);
            }

            public void visitEnd() {
            }
        }
    }

    private class TypeAliasReader
    extends KmTypeAliasVisitor {
        private final KotlinTypeAliasMetadata kotlinTypeAliasMetadata;
        private final ArrayList<KotlinMetadataAnnotation> annotations;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        TypeAliasReader(KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            this.kotlinTypeAliasMetadata = kotlinTypeAliasMetadata;
            this.annotations = new ArrayList(1);
            this.typeParameters = new ArrayList(1);
        }

        public void visitAnnotation(KmAnnotation annotation) {
            this.annotations.add(new KotlinMetadataAnnotation(annotation));
        }

        public KmTypeParameterVisitor visitTypeParameter(int flags, String name, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(flags, name, id, variance);
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        public KmTypeVisitor visitUnderlyingType(int flags) {
            KotlinTypeMetadata underlyingType;
            this.kotlinTypeAliasMetadata.underlyingType = underlyingType = new KotlinTypeMetadata(flags);
            return new TypeReader(underlyingType);
        }

        public KmTypeVisitor visitExpandedType(int flags) {
            KotlinTypeMetadata expandedType;
            this.kotlinTypeAliasMetadata.expandedType = expandedType = new KotlinTypeMetadata(flags);
            return new TypeReader(expandedType);
        }

        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinTypeAliasMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        public void visitEnd() {
            this.kotlinTypeAliasMetadata.annotations = KotlinMetadataInitializer.trimmed(this.annotations);
            this.kotlinTypeAliasMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
        }
    }

    private class PropertyReader
    extends KmPropertyVisitor {
        private final KotlinPropertyMetadata kotlinPropertyMetadata;
        private final ArrayList<KotlinValueParameterMetadata> setterParameters;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        PropertyReader(KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kotlinPropertyMetadata = kotlinPropertyMetadata;
            this.setterParameters = new ArrayList(4);
            this.typeParameters = new ArrayList(1);
        }

        public KmTypeVisitor visitReceiverParameterType(int flags) {
            KotlinTypeMetadata receiverType;
            this.kotlinPropertyMetadata.receiverType = receiverType = new KotlinTypeMetadata(flags);
            return new TypeReader(receiverType);
        }

        public KmTypeVisitor visitReturnType(int flags) {
            KotlinTypeMetadata returnType;
            this.kotlinPropertyMetadata.type = returnType = new KotlinTypeMetadata(flags);
            return new TypeReader(returnType);
        }

        public KmValueParameterVisitor visitSetterParameter(int flags, String name) {
            KotlinValueParameterMetadata valueParameter = new KotlinValueParameterMetadata(flags, this.setterParameters.size(), name);
            this.setterParameters.add(valueParameter);
            return new ValueParameterReader(valueParameter);
        }

        public KmTypeParameterVisitor visitTypeParameter(int flags, String name, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(flags, name, id, variance);
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinPropertyMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        public KmPropertyExtensionVisitor visitExtensions(KmExtensionType type) {
            return new PropertyExtensionReader();
        }

        public void visitEnd() {
            this.kotlinPropertyMetadata.setterParameters = KotlinMetadataInitializer.trimmed(this.setterParameters);
            this.kotlinPropertyMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
        }

        private class PropertyExtensionReader
        extends JvmPropertyExtensionVisitor {
            private PropertyExtensionReader() {
            }

            public void visit(int jvmFlags, kotlinx.metadata.jvm.JvmFieldSignature fieldSignature, JvmMethodSignature getterSignature, JvmMethodSignature setterSignature) {
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.backingFieldSignature = KotlinMetadataInitializer.fromKotlinJvmFieldSignature(fieldSignature);
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.getterSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(getterSignature);
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.setterSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(setterSignature);
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.flags.setJvmFlags(jvmFlags);
            }

            public void visitSyntheticMethodForAnnotations(JvmMethodSignature jvmMethodSignature) {
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.syntheticMethodForAnnotations = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(jvmMethodSignature);
            }

            public void visitEnd() {
            }
        }
    }

    private class ConstructorReader
    extends KmConstructorVisitor {
        private final boolean hasValidJvmSignature;
        private final KotlinConstructorMetadata kotlinConstructorMetadata;
        private final ArrayList<KotlinValueParameterMetadata> valueParameters;

        ConstructorReader(boolean hasValidJvmSignature, KotlinConstructorMetadata kotlinConstructorMetadata) {
            this.hasValidJvmSignature = hasValidJvmSignature;
            this.kotlinConstructorMetadata = kotlinConstructorMetadata;
            this.valueParameters = new ArrayList(4);
        }

        public KmValueParameterVisitor visitValueParameter(int flags, String name) {
            KotlinValueParameterMetadata valueParameter = new KotlinValueParameterMetadata(flags, this.valueParameters.size(), name);
            this.valueParameters.add(valueParameter);
            return new ValueParameterReader(valueParameter);
        }

        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinConstructorMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        public KmConstructorExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new ConstructorExtensionReader();
        }

        public void visitEnd() {
            this.kotlinConstructorMetadata.valueParameters = KotlinMetadataInitializer.trimmed(this.valueParameters);
        }

        private class ConstructorExtensionReader
        extends JvmConstructorExtensionVisitor {
            private ConstructorExtensionReader() {
            }

            public void visit(JvmMethodSignature jvmSignature) {
                if (ConstructorReader.this.hasValidJvmSignature) {
                    ((ConstructorReader)ConstructorReader.this).kotlinConstructorMetadata.jvmSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(jvmSignature);
                }
            }
        }
    }

    private class LambdaReader
    extends KmLambdaVisitor {
        private final KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata;
        private final ArrayList<KotlinFunctionMetadata> functions;

        LambdaReader(KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            this.kotlinSyntheticClassKindMetadata = kotlinSyntheticClassKindMetadata;
            this.functions = new ArrayList(1);
        }

        public KmFunctionVisitor visitFunction(int flags, String name) {
            KotlinFunctionMetadata function = new KotlinFunctionMetadata(flags, name);
            this.functions.add(function);
            return new FunctionReader(function);
        }

        public void visitEnd() {
            this.kotlinSyntheticClassKindMetadata.functions = KotlinMetadataInitializer.trimmed(this.functions);
        }
    }

    private class ClassReader
    extends KmClassVisitor {
        private final KotlinClassKindMetadata kotlinClassKindMetadata;
        private final ArrayList<KotlinTypeMetadata> superTypes;
        private final ArrayList<KotlinConstructorMetadata> constructors;
        private final ArrayList<KotlinFunctionMetadata> functions;
        private final ArrayList<KotlinPropertyMetadata> properties;
        private final ArrayList<KotlinPropertyMetadata> localDelegatedProperties;
        private final ArrayList<String> enumEntryNames;
        private final ArrayList<String> nestedClassNames;
        private final ArrayList<String> sealedSubClassNames;
        private final ArrayList<KotlinTypeAliasMetadata> typeAliases;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        ClassReader(KotlinClassKindMetadata kotlinClassKindMetadata) {
            this.kotlinClassKindMetadata = kotlinClassKindMetadata;
            this.superTypes = new ArrayList(1);
            this.constructors = new ArrayList(4);
            this.enumEntryNames = new ArrayList(4);
            this.nestedClassNames = new ArrayList(1);
            this.sealedSubClassNames = new ArrayList(2);
            this.typeParameters = new ArrayList(2);
            this.properties = new ArrayList(8);
            this.functions = new ArrayList(8);
            this.typeAliases = new ArrayList(2);
            this.localDelegatedProperties = new ArrayList(2);
        }

        public void visit(int flags, String className) {
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            className = className.replace('.', '$');
            this.kotlinClassKindMetadata.setMetadataFlags(flags);
            this.kotlinClassKindMetadata.className = className;
        }

        public KmTypeVisitor visitSupertype(int flags) {
            KotlinTypeMetadata superType = new KotlinTypeMetadata(flags);
            this.superTypes.add(superType);
            return new TypeReader(superType);
        }

        public void visitCompanionObject(String companionName) {
            this.kotlinClassKindMetadata.companionObjectName = companionName;
        }

        public KmConstructorVisitor visitConstructor(int flags) {
            KotlinConstructorMetadata constructor = new KotlinConstructorMetadata(flags);
            this.constructors.add(constructor);
            return new ConstructorReader(!this.kotlinClassKindMetadata.flags.isAnnotationClass, constructor);
        }

        public void visitEnumEntry(String enumName) {
            this.enumEntryNames.add(enumName);
        }

        public void visitNestedClass(String nestedClassName) {
            this.nestedClassNames.add(nestedClassName);
        }

        public void visitSealedSubclass(String subClassName) {
            subClassName = subClassName.replace(".", "$");
            this.sealedSubClassNames.add(subClassName);
        }

        public KmTypeParameterVisitor visitTypeParameter(int flags, String parameterName, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(flags, parameterName, id, variance);
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinClassKindMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        public KmFunctionVisitor visitFunction(int flags, String name) {
            KotlinFunctionMetadata function = new KotlinFunctionMetadata(flags, name);
            this.functions.add(function);
            return new FunctionReader(function);
        }

        public KmPropertyVisitor visitProperty(int flags, String name, int getterFlags, int setterFlags) {
            KotlinPropertyMetadata property = new KotlinPropertyMetadata(flags, name, getterFlags, setterFlags);
            this.properties.add(property);
            return new PropertyReader(property);
        }

        public KmTypeAliasVisitor visitTypeAlias(int flags, String name) {
            KotlinTypeAliasMetadata typeAlias = new KotlinTypeAliasMetadata(flags, name);
            this.typeAliases.add(typeAlias);
            return new TypeAliasReader(typeAlias);
        }

        public KmClassExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new ClassExtensionReader();
        }

        public void visitEnd() {
            this.kotlinClassKindMetadata.superTypes = KotlinMetadataInitializer.trimmed(this.superTypes);
            this.kotlinClassKindMetadata.constructors = KotlinMetadataInitializer.trimmed(this.constructors);
            this.kotlinClassKindMetadata.enumEntryNames = KotlinMetadataInitializer.trimmed(this.enumEntryNames);
            this.kotlinClassKindMetadata.nestedClassNames = KotlinMetadataInitializer.trimmed(this.nestedClassNames);
            this.kotlinClassKindMetadata.sealedSubclassNames = KotlinMetadataInitializer.trimmed(this.sealedSubClassNames);
            this.kotlinClassKindMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
            this.kotlinClassKindMetadata.properties = KotlinMetadataInitializer.trimmed(this.properties);
            this.kotlinClassKindMetadata.functions = KotlinMetadataInitializer.trimmed(this.functions);
            this.kotlinClassKindMetadata.typeAliases = KotlinMetadataInitializer.trimmed(this.typeAliases);
            this.kotlinClassKindMetadata.localDelegatedProperties = KotlinMetadataInitializer.trimmed(this.localDelegatedProperties);
        }

        private class ClassExtensionReader
        extends JvmClassExtensionVisitor {
            private ClassExtensionReader() {
            }

            public void visitAnonymousObjectOriginName(String internalName) {
                ((ClassReader)ClassReader.this).kotlinClassKindMetadata.anonymousObjectOriginName = internalName;
            }

            public KmPropertyVisitor visitLocalDelegatedProperty(int flags, String name, int getterFlags, int setterFlags) {
                KotlinPropertyMetadata delegatedProperty = new KotlinPropertyMetadata(flags, name, getterFlags, setterFlags);
                ClassReader.this.localDelegatedProperties.add(delegatedProperty);
                return new PropertyReader(delegatedProperty);
            }

            public void visitEnd() {
            }
        }
    }

    private static class SimpleKotlinMetadataSetter
    implements ClassVisitor {
        private final KotlinMetadata kmd;

        SimpleKotlinMetadataSetter(KotlinMetadata kmd) {
            this.kmd = kmd;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            programClass.kotlinMetadata = this.kmd;
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            libraryClass.kotlinMetadata = this.kmd;
        }
    }

    public static enum MetadataType {
        k,
        mv,
        bv,
        d1,
        d2,
        xi,
        xs,
        pn;

    }

    private class ArrayElementValueCollector
    implements ElementValueVisitor,
    ConstantVisitor {
        private final MetadataType arrayType;
        private int index;

        ArrayElementValueCollector(MetadataType array) {
            this.arrayType = array;
            this.index = 0;
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
        }

        @Override
        public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
            if (this.arrayType == MetadataType.d1) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d1[this.index++] = utf8Constant.getString();
            } else if (this.arrayType == MetadataType.d2) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d2[this.index++] = utf8Constant.getString();
            } else {
                throw new UnsupportedOperationException("Cannot store UTF8Constant in int[]");
            }
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            if (this.arrayType == MetadataType.mv) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).mv[this.index++] = integerConstant.getValue();
            } else if (this.arrayType == MetadataType.bv) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).bv[this.index++] = integerConstant.getValue();
            } else {
                throw new UnsupportedOperationException("Cannot store IntegerConstant in String[]");
            }
        }
    }
}

