/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.classfile.Clazz;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.UnknownReferenceValue;
import proguard.evaluation.value.ValueFactory;

public class MultiTypedReferenceValue
extends ReferenceValue {
    private final Set<TypedReferenceValue> potentialTypes = new HashSet<TypedReferenceValue>();
    private final TypedReferenceValue generalizedType;
    public final boolean mayBeUnknown;

    public MultiTypedReferenceValue(Set<TypedReferenceValue> potentialTypes, boolean mayBeUnknown) {
        this.mayBeUnknown = mayBeUnknown;
        this.potentialTypes.addAll(potentialTypes);
        this.generalizedType = this.generalize(potentialTypes);
    }

    public MultiTypedReferenceValue(TypedReferenceValue type, boolean mayBeUnknown) {
        this.mayBeUnknown = mayBeUnknown;
        this.potentialTypes.add(type);
        this.generalizedType = type;
    }

    private TypedReferenceValue checkForAlreadyContainedType(TypedReferenceValue newGeneralizedType) {
        Optional<TypedReferenceValue> matchingPotentialType = this.potentialTypes.stream().filter(t -> Objects.equals(t.getType(), newGeneralizedType.getType()) && Objects.equals(t.getReferencedClass(), newGeneralizedType.getReferencedClass())).findAny();
        return matchingPotentialType.orElse(newGeneralizedType);
    }

    private TypedReferenceValue generalize(Set<TypedReferenceValue> potentialTypes) {
        TypedReferenceValue generalizedType = null;
        for (TypedReferenceValue type : potentialTypes) {
            if (generalizedType == null) {
                generalizedType = type;
                continue;
            }
            ReferenceValue newGeneralizedType = generalizedType.generalize(type);
            if (newGeneralizedType instanceof TypedReferenceValue) {
                generalizedType = (TypedReferenceValue)newGeneralizedType;
                continue;
            }
            throw new IllegalStateException("Generalized type not a typed reference value: " + newGeneralizedType.getClass().getSimpleName());
        }
        return this.checkForAlreadyContainedType(generalizedType);
    }

    public Set<TypedReferenceValue> getPotentialTypes() {
        return this.potentialTypes;
    }

    public TypedReferenceValue getGeneralizedType() {
        return this.generalizedType;
    }

    private int conditionMatches(Set<Integer> possibilities) {
        if (possibilities.size() == 1) {
            return possibilities.iterator().next();
        }
        return 0;
    }

    @Override
    public String getType() {
        return this.generalizedType.getType();
    }

    @Override
    public Clazz getReferencedClass() {
        return this.generalizedType.getReferencedClass();
    }

    @Override
    public boolean mayBeExtension() {
        return this.potentialTypes.stream().anyMatch(TypedReferenceValue::mayBeExtension);
    }

    @Override
    public int isNull() {
        return this.conditionMatches(this.potentialTypes.stream().map(TypedReferenceValue::isNull).collect(Collectors.toSet()));
    }

    @Override
    public int instanceOf(String otherType, Clazz otherReferencedClass) {
        return this.conditionMatches(this.potentialTypes.stream().map(t -> t.instanceOf(otherType, otherReferencedClass)).collect(Collectors.toSet()));
    }

    @Override
    public ReferenceValue cast(String type, Clazz referencedClass, ValueFactory valueFactory, boolean alwaysCast) {
        if (this.instanceOf(type, referencedClass) == 1) {
            return this;
        }
        return new MultiTypedReferenceValue(new TypedReferenceValue(type, referencedClass, this.mayBeExtension(), this.isNull() != -1), this.mayBeUnknown);
    }

    @Override
    public ReferenceValue referenceArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Set<TypedReferenceValue> potentialTypes = this.potentialTypes.stream().map(t -> t.referenceArrayLoad(indexValue, valueFactory)).filter(MultiTypedReferenceValue.class::isInstance).map(MultiTypedReferenceValue.class::cast).flatMap(t -> t.potentialTypes.stream()).collect(Collectors.toSet());
        if (potentialTypes.isEmpty()) {
            return valueFactory.createReferenceValue();
        }
        return new MultiTypedReferenceValue(potentialTypes, this.mayBeUnknown);
    }

    @Override
    public ReferenceValue generalize(ReferenceValue other) {
        return other.generalize(this);
    }

    @Override
    public ReferenceValue generalize(TypedReferenceValue other) {
        return this.generalize(new MultiTypedReferenceValue(other, false));
    }

    @Override
    public ReferenceValue generalize(UnknownReferenceValue other) {
        return new MultiTypedReferenceValue(this.potentialTypes, true);
    }

    @Override
    public ReferenceValue generalize(MultiTypedReferenceValue other) {
        if (this.equals(other)) {
            return this;
        }
        HashSet<TypedReferenceValue> newPotentialTypes = new HashSet<TypedReferenceValue>(this.potentialTypes);
        newPotentialTypes.addAll(other.potentialTypes);
        return new MultiTypedReferenceValue(newPotentialTypes, this.mayBeUnknown || other.mayBeUnknown);
    }

    @Override
    public int equal(ReferenceValue other) {
        return other.equal(this);
    }

    @Override
    public int equal(MultiTypedReferenceValue other) {
        return this.conditionMatches(this.potentialTypes.stream().map(t -> t.equal(other.generalizedType)).collect(Collectors.toSet()));
    }

    @Override
    public String internalType() {
        return this.generalizedType.internalType();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiTypedReferenceValue that = (MultiTypedReferenceValue)o;
        return Objects.equals(this.potentialTypes, that.potentialTypes) && this.mayBeUnknown == that.mayBeUnknown;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.potentialTypes);
    }

    @Override
    public String toString() {
        return "potentialTypes=[" + this.potentialTypes.stream().map(TypedReferenceValue::toString).collect(Collectors.joining(", ")) + "], generalizedType=" + this.generalizedType;
    }
}

