/*
 * Decompiled with CFR 0.152.
 */
package proguard.preverify;

import java.util.ArrayList;
import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.VerificationTypeFactory;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InitializationFinder;
import proguard.evaluation.LivenessAnalyzer;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.ReferenceTracingInvocationUnit;
import proguard.evaluation.ReferenceTracingValueFactory;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;

public class CodePreverifier
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final int AT_METHOD_ENTRY = -1;
    private final boolean microEdition;
    private final ReferenceTracingValueFactory referenceTracingValueFactory = new ReferenceTracingValueFactory(new TypedReferenceValueFactory());
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.referenceTracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(this.referenceTracingValueFactory)), true, this.referenceTracingValueFactory);
    private final InitializationFinder initializationFinder = new InitializationFinder(this.partialEvaluator, false);
    private final LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer(this.partialEvaluator, false, this.initializationFinder, false);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();

    public CodePreverifier(boolean microEdition) {
        this.microEdition = microEdition;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while preverifying:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        ProgramClass programClass = (ProgramClass)clazz;
        ProgramMethod programMethod = (ProgramMethod)method;
        int codeLength = codeAttribute.u4codeLength;
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        this.initializationFinder.visitCodeAttribute(clazz, method, codeAttribute);
        this.livenessAnalyzer.visitCodeAttribute(clazz, method, codeAttribute);
        this.codeAttributeEditor.reset(codeLength);
        ArrayList<FullFrame> stackMapFrameList = new ArrayList<FullFrame>();
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) {
                this.codeAttributeEditor.deleteInstruction(offset);
                continue;
            }
            if (!this.partialEvaluator.isBranchOrExceptionTarget(offset)) continue;
            VerificationType[] variableTypes = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, offset, this.partialEvaluator.getVariablesBefore(offset));
            VerificationType[] stackTypes = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, offset, this.partialEvaluator.getStackBefore(offset));
            stackMapFrameList.add(new FullFrame(offset, variableTypes, stackTypes));
        }
        if (!this.microEdition && !stackMapFrameList.isEmpty()) {
            VerificationType[] initialVariables = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, -1, this.partialEvaluator.getVariablesBefore(0));
            if (method.getName(programClass).equals("<init>")) {
                initialVariables[0] = VerificationTypeFactory.createUninitializedThisType();
            }
            this.compressStackMapFrames(initialVariables, stackMapFrameList);
        }
        String stackMapAttributeName = this.microEdition ? "StackMap" : "StackMapTable";
        int frameCount = stackMapFrameList.size();
        if (frameCount == 0) {
            new AttributesEditor(programClass, programMethod, codeAttribute, true).deleteAttribute(stackMapAttributeName);
        } else {
            Attribute stackMapAttribute;
            if (this.microEdition) {
                FullFrame[] stackMapFrames = new FullFrame[frameCount];
                stackMapFrameList.toArray(stackMapFrames);
                stackMapAttribute = new StackMapAttribute(stackMapFrames);
            } else {
                StackMapFrame[] stackMapFrames = new StackMapFrame[frameCount];
                stackMapFrameList.toArray(stackMapFrames);
                stackMapAttribute = new StackMapTableAttribute(stackMapFrames);
            }
            stackMapAttribute.u2attributeNameIndex = new ConstantPoolEditor(programClass).addUtf8Constant(stackMapAttributeName);
            new AttributesEditor(programClass, programMethod, codeAttribute, true).addAttribute(stackMapAttribute);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private VerificationType[] correspondingVerificationTypes(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int offset, TracedVariables variables) {
        Value value;
        int index;
        int typeIndex;
        int typeCount = 0;
        if (offset == -1) {
            typeCount = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass), programMethod.getAccessFlags());
        } else {
            typeCount = 0;
            int maximumVariablesSize = variables.size();
            typeIndex = 0;
            for (index = 0; index < maximumVariablesSize; ++index) {
                value = variables.getValue(index);
                ++typeIndex;
                if (value == null || !this.livenessAnalyzer.isAliveBefore(offset, index) && !this.isUninitalizedThis(offset, index)) continue;
                typeCount = typeIndex;
                if (!value.isCategory2()) continue;
                ++index;
            }
        }
        VerificationType[] types = new VerificationType[typeCount];
        typeIndex = 0;
        index = 0;
        while (typeIndex < typeCount) {
            VerificationType type;
            value = variables.getValue(index);
            Value producerValue = variables.getProducerValue(index);
            if (value != null && (offset == -1 || this.livenessAnalyzer.isAliveBefore(offset, index) || this.isUninitalizedThis(offset, index))) {
                type = this.correspondingVerificationType(programClass, programMethod, codeAttribute, offset, value, producerValue);
                if (value.isCategory2()) {
                    ++index;
                }
            } else {
                type = offset == -1 ? VerificationTypeFactory.createUninitializedThisType() : VerificationTypeFactory.createTopType();
            }
            types[typeIndex++] = type;
            ++index;
        }
        return types;
    }

    private VerificationType[] correspondingVerificationTypes(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int offset, TracedStack stack) {
        int maximumStackSize = stack.size();
        int typeCount = 0;
        for (int index = 0; index < maximumStackSize; ++index) {
            Value value = stack.getTop(index);
            ++typeCount;
            if (!value.isCategory2()) continue;
            ++index;
        }
        VerificationType[] types = new VerificationType[typeCount];
        int typeIndex = typeCount;
        for (int index = 0; index < maximumStackSize; ++index) {
            Value value = stack.getTop(index);
            Value producerValue = stack.getTopProducerValue(index);
            types[--typeIndex] = this.correspondingVerificationType(programClass, programMethod, codeAttribute, offset, value, producerValue);
            if (!value.isCategory2()) continue;
            ++index;
        }
        return types;
    }

    private VerificationType correspondingVerificationType(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int offset, Value value, Value producerValue) {
        if (value == null) {
            return VerificationTypeFactory.createTopType();
        }
        int type = value.computationalType();
        switch (type) {
            case 1: 
            case 6: {
                return VerificationTypeFactory.createIntegerType();
            }
            case 2: {
                return VerificationTypeFactory.createLongType();
            }
            case 3: {
                return VerificationTypeFactory.createFloatType();
            }
            case 4: {
                return VerificationTypeFactory.createDoubleType();
            }
            case 7: {
                return VerificationTypeFactory.createTopType();
            }
            case 5: {
                TracedReferenceValue tracedReferenceValue;
                InstructionOffsetValue instructionOffsetValue;
                ReferenceValue referenceValue = value.referenceValue();
                if (referenceValue.isNull() == 1) {
                    return VerificationTypeFactory.createNullType();
                }
                if (offset != -1 && (instructionOffsetValue = (tracedReferenceValue = (TracedReferenceValue)referenceValue).getTraceValue().instructionOffsetValue()).instructionOffsetCount() == 1) {
                    if (instructionOffsetValue.isMethodParameter(0)) {
                        if (this.isUninitalizedThis(offset, instructionOffsetValue.methodParameter(0))) {
                            return VerificationTypeFactory.createUninitializedThisType();
                        }
                    } else if (instructionOffsetValue.isNewinstance(0)) {
                        int producerOffset = instructionOffsetValue.instructionOffset(0);
                        if (!this.initializationFinder.isInitializedBefore(offset, instructionOffsetValue)) {
                            return VerificationTypeFactory.createUninitializedType(producerOffset);
                        }
                    }
                }
                return VerificationTypeFactory.createObjectType(this.createClassConstant(programClass, referenceValue));
            }
        }
        throw new IllegalArgumentException("Unknown computational type [" + type + "]");
    }

    private int createClassConstant(ProgramClass programClass, ReferenceValue referenceValue) {
        return new ConstantPoolEditor(programClass).addClassConstant(referenceValue.getType(), referenceValue.getReferencedClass());
    }

    private void compressStackMapFrames(VerificationType[] initialVariableTypes, List stackMapFrameList) {
        int previousVariablesCount = initialVariableTypes.length;
        VerificationType[] previousVariableTypes = initialVariableTypes;
        int previousOffset = -1;
        for (int index = 0; index < stackMapFrameList.size(); ++index) {
            FullFrame fullFrame = (FullFrame)stackMapFrameList.get(index);
            int variablesCount = fullFrame.variablesCount;
            VerificationType[] variables = fullFrame.variables;
            int stackCount = fullFrame.stackCount;
            VerificationType[] stack = fullFrame.stack;
            StackMapFrame compressedFrame = fullFrame;
            if (variablesCount == previousVariablesCount && this.equalVerificationTypes(variables, previousVariableTypes, variablesCount)) {
                if (stackCount == 0) {
                    compressedFrame = new SameZeroFrame();
                } else if (stackCount == 1) {
                    compressedFrame = new SameOneFrame(stack[0]);
                }
            } else if (stackCount == 0) {
                int additionalVariablesCount = variablesCount - previousVariablesCount;
                if (additionalVariablesCount < 0 && additionalVariablesCount > -4 && this.equalVerificationTypes(variables, previousVariableTypes, variablesCount)) {
                    compressedFrame = new LessZeroFrame((byte)(-additionalVariablesCount));
                } else if (additionalVariablesCount > 0 && additionalVariablesCount < 4 && this.equalVerificationTypes(variables, previousVariableTypes, previousVariablesCount)) {
                    VerificationType[] additionalVariables = new VerificationType[additionalVariablesCount];
                    System.arraycopy(variables, variablesCount - additionalVariablesCount, additionalVariables, 0, additionalVariablesCount);
                    compressedFrame = new MoreZeroFrame(additionalVariables);
                }
            }
            int offset = fullFrame.u2offsetDelta;
            compressedFrame.u2offsetDelta = offset - previousOffset - 1;
            previousOffset = offset;
            previousVariablesCount = fullFrame.variablesCount;
            previousVariableTypes = fullFrame.variables;
            stackMapFrameList.set(index, compressedFrame);
        }
    }

    private boolean equalVerificationTypes(VerificationType[] types1, VerificationType[] types2, int length) {
        if (length > 0 && (types1.length < length || types2.length < length)) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (types1[index].equals(types2[index])) continue;
            return false;
        }
        return true;
    }

    private boolean isUninitalizedThis(int offset, int variableIndex) {
        return variableIndex == 0 && this.initializationFinder.isInitializer() && offset <= this.initializationFinder.superInitializationOffset();
    }
}

