/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.reflect.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionConstantVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.reflect.FunctionReferenceInfo;
import proguard.classfile.kotlin.reflect.JavaFieldReferenceInfo;
import proguard.classfile.kotlin.reflect.JavaMethodReferenceInfo;
import proguard.classfile.kotlin.reflect.LocalVariableReferenceInfo;
import proguard.classfile.kotlin.reflect.PropertyReferenceInfo;
import proguard.classfile.kotlin.visitor.AllPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.MethodToKotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinPropertyFilter;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;

public class KotlinCallableReferenceInitializer
implements KotlinMetadataVisitor {
    private static final MemberFinder memberFinder = new MemberFinder();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;

    public KotlinCallableReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata syntheticClassKindMetadata) {
        if (clazz.extendsOrImplements("kotlin/jvm/internal/CallableReference")) {
            Consumer<InfoLoaderResult> loader = result -> {
                if (clazz.extendsOrImplements("kotlin/jvm/internal/FunctionReference")) {
                    Method method = memberFinder.findMethod(result.callableOwnerClass, result.callableName, result.callableSignature.substring(result.callableSignature.indexOf(40)));
                    if (method != null) {
                        Clazz methodReferencedClass = memberFinder.correspondingClass();
                        if (result.callableOwnerMetadata != null) {
                            method.accept(methodReferencedClass, new MethodToKotlinFunctionVisitor(new FunctionReferenceInfoInitializer(result.callableOwnerClass, result.callableOwnerMetadata, syntheticClassKindMetadata)));
                        }
                        if (syntheticClassKindMetadata.callableReferenceInfo == null) {
                            syntheticClassKindMetadata.callableReferenceInfo = new JavaMethodReferenceInfo(result.callableOwnerClass, methodReferencedClass, method);
                        }
                    }
                } else if (clazz.extendsOrImplements("kotlin/jvm/internal/LocalVariableReference")) {
                    if (result.callableOwnerMetadata != null) {
                        result.callableOwnerClass.kotlinMetadataAccept(new LocalVariableReferenceInfoInitializer(result.callableOwnerClass, result.callableOwnerMetadata, syntheticClassKindMetadata, result.callableName, result.callableSignature));
                    }
                } else if (clazz.extendsOrImplements("kotlin/jvm/internal/PropertyReference")) {
                    Field field;
                    if (result.callableOwnerMetadata != null) {
                        try {
                            result.callableOwnerClass.hierarchyAccept(true, true, false, false, new ReferencedKotlinMetadataVisitor(new AllPropertyVisitor(new KotlinPropertyFilter(prop -> prop.name.equals(result.callableName), (_clazz, declarationContainerMetadata, propertyMetadata) -> {
                                if (syntheticClassKindMetadata.callableReferenceInfo == null) {
                                    syntheticClassKindMetadata.callableReferenceInfo = new PropertyReferenceInfo(result.callableOwnerClass, result.callableOwnerMetadata, propertyMetadata);
                                    throw new PropertyFoundException();
                                }
                            }))));
                        }
                        catch (PropertyFoundException method) {
                            // empty catch block
                        }
                    }
                    if (syntheticClassKindMetadata.callableReferenceInfo == null && (field = memberFinder.findField(result.callableOwnerClass, result.callableName, result.callableSignature.substring(result.callableSignature.lastIndexOf(41) + 1))) != null) {
                        syntheticClassKindMetadata.callableReferenceInfo = new JavaFieldReferenceInfo(result.callableOwnerClass, memberFinder.correspondingClass(), field);
                    }
                }
            };
            clazz.accept(syntheticClassKindMetadata.mv[0] == 1 && syntheticClassKindMetadata.mv[1] <= 3 ? new CallableReferenceInfoLoader1dot3(loader) : new CallableReferenceInfoLoader1dot4(loader));
        }
    }

    private static class PropertyFoundException
    extends RuntimeException {
        private PropertyFoundException() {
        }
    }

    public static class LocalVariableReferenceInfoInitializer
    implements KotlinMetadataVisitor {
        private final Clazz ownerClass;
        private final KotlinDeclarationContainerMetadata owner;
        private final KotlinSyntheticClassKindMetadata syntheticClassKindMetadata;
        private final String name;
        private final String signature;

        LocalVariableReferenceInfoInitializer(Clazz ownerClass, KotlinDeclarationContainerMetadata ownerMetadata, KotlinSyntheticClassKindMetadata syntheticClassKindMetadata, String name, String signature) {
            this.ownerClass = ownerClass;
            this.owner = ownerMetadata;
            this.syntheticClassKindMetadata = syntheticClassKindMetadata;
            this.name = name;
            this.signature = signature;
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            this.syntheticClassKindMetadata.callableReferenceInfo = new LocalVariableReferenceInfo(this.ownerClass, this.owner, this.name, this.signature);
        }
    }

    private static class FunctionReferenceInfoInitializer
    implements KotlinFunctionVisitor {
        private final Clazz ownerClass;
        private final KotlinDeclarationContainerMetadata ownerMetadata;
        private final KotlinSyntheticClassKindMetadata syntheticClassKindMetadata;

        private FunctionReferenceInfoInitializer(Clazz ownerClass, KotlinDeclarationContainerMetadata ownerMetadata, KotlinSyntheticClassKindMetadata syntheticClassKindMetadata) {
            this.ownerClass = ownerClass;
            this.ownerMetadata = ownerMetadata;
            this.syntheticClassKindMetadata = syntheticClassKindMetadata;
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            this.syntheticClassKindMetadata.callableReferenceInfo = new FunctionReferenceInfo(this.ownerClass, this.ownerMetadata, kotlinFunctionMetadata);
        }
    }

    private static class CallableReferenceInfoLoader1dot3
    implements ClassVisitor,
    MemberVisitor,
    ConstantVisitor,
    KotlinMetadataVisitor {
        private final Consumer<InfoLoaderResult> infoLoaderResultConsumer;
        private final InfoLoaderResult result = new InfoLoaderResult();
        private String currentMethod;

        public CallableReferenceInfoLoader1dot3(Consumer<InfoLoaderResult> infoLoaderResultConsumer) {
            this.infoLoaderResultConsumer = infoLoaderResultConsumer;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            clazz.methodsAccept(this);
            if (this.result.callableOwnerClass != null) {
                this.result.callableOwnerClass.kotlinMetadataAccept(this);
                if (this.result.callableName != null && this.result.callableSignature != null) {
                    this.infoLoaderResultConsumer.accept(this.result);
                }
            }
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            this.currentMethod = programMethod.getName(programClass) + programMethod.getDescriptor(programClass);
            programMethod.accept(programClass, (MemberVisitor)new AllAttributeVisitor(new AllInstructionVisitor(new InstructionConstantVisitor(this))));
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            if (this.currentMethod.equals("getSignature()Ljava/lang/String;")) {
                this.result.callableSignature = stringConstant.getString(clazz);
            } else if (this.currentMethod.equals("getName()Ljava/lang/String;")) {
                this.result.callableName = stringConstant.getString(clazz);
            }
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            if (this.currentMethod.equals("getOwner()Lkotlin/reflect/KDeclarationContainer;")) {
                this.result.callableOwnerClass = classConstant.referencedClass;
            }
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            this.result.callableOwnerMetadata = kotlinDeclarationContainerMetadata;
        }
    }

    private class CallableReferenceInfoLoader1dot4
    implements ClassVisitor,
    InstructionVisitor {
        private static final int OWNER_INDEX = 0x40000003;
        private static final int NAME_INDEX = 0x40000004;
        private static final int SIGNATURE_INDEX = 0x40000005;
        private static final int FLAGS_INDEX = 0x40000006;
        private final List<InstructionSequenceMatcher> matchers = new ArrayList<InstructionSequenceMatcher>();
        private final Consumer<InfoLoaderResult> consumer;

        public CallableReferenceInfoLoader1dot4(Consumer<InfoLoaderResult> consumer) {
            this.consumer = consumer;
            InstructionSequenceBuilder builder = new InstructionSequenceBuilder(KotlinCallableReferenceInitializer.this.programClassPool, KotlinCallableReferenceInitializer.this.libraryClassPool).ldc_(0x40000003).ldc_(0x40000004).ldc_(0x40000005).ldc_(0x40000006).invokespecial(0x40000000);
            this.matchers.add(new InstructionSequenceMatcher(builder.constants(), builder.instructions()));
            builder.ldc_(0x40000003).ldc_(0x40000004).ldc_(0x40000005).iconst(0x4000000B).invokespecial(0x40000000);
            this.matchers.add(new InstructionSequenceMatcher(builder.constants(), builder.instructions()));
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            for (InstructionSequenceMatcher matcher : this.matchers) {
                matcher.reset();
            }
            clazz.methodsAccept(new MemberNameFilter("<init>", (MemberVisitor)new AllAttributeVisitor(new AllInstructionVisitor(this))));
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            for (InstructionSequenceMatcher matcher : this.matchers) {
                instruction.accept(clazz, method, codeAttribute, offset, matcher);
                if (!matcher.isMatching()) continue;
                final InfoLoaderResult result = new InfoLoaderResult();
                clazz.constantPoolEntryAccept(matcher.matchedConstantIndex(0x40000003), new ConstantVisitor(){

                    @Override
                    public void visitAnyConstant(Clazz clazz, Constant constant) {
                    }

                    @Override
                    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
                        result.callableOwnerClass = classConstant.referencedClass;
                    }
                });
                clazz.constantPoolEntryAccept(matcher.matchedConstantIndex(0x40000004), new ConstantVisitor(){

                    @Override
                    public void visitAnyConstant(Clazz clazz, Constant constant) {
                    }

                    @Override
                    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
                        result.callableName = stringConstant.getString(clazz);
                    }
                });
                clazz.constantPoolEntryAccept(matcher.matchedConstantIndex(0x40000005), new ConstantVisitor(){

                    @Override
                    public void visitAnyConstant(Clazz clazz, Constant constant) {
                    }

                    @Override
                    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
                        result.callableSignature = stringConstant.getString(clazz);
                    }
                });
                if (result.callableOwnerClass == null) break;
                result.callableOwnerClass.kotlinMetadataAccept(new KotlinMetadataVisitor(){

                    @Override
                    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
                    }

                    @Override
                    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata declarationContainer) {
                        result.callableOwnerMetadata = declarationContainer;
                    }
                });
                if (result.callableName == null || result.callableSignature == null) break;
                this.consumer.accept(result);
                break;
            }
        }
    }

    private static class InfoLoaderResult {
        Clazz callableOwnerClass;
        KotlinDeclarationContainerMetadata callableOwnerMetadata;
        String callableName;
        String callableSignature;

        private InfoLoaderResult() {
        }
    }
}

