/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.FieldSignature;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.RecordAttribute;
import proguard.classfile.attribute.RecordComponentInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.RecordComponentInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.kotlin.KotlinAnnotatable;
import proguard.classfile.kotlin.KotlinAnnotation;
import proguard.classfile.kotlin.KotlinAnnotationArgument;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinAnnotationArgumentVisitor;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceFixer
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
RecordComponentInfoVisitor,
InnerClassesInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final Logger logger = LogManager.getLogger(ClassReferenceFixer.class);
    private final boolean ensureUniqueMemberNames;
    private final KotlinReferenceFixer kotlinReferenceFixer = new KotlinReferenceFixer();

    public ClassReferenceFixer(boolean ensureUniqueMemberNames) {
        this.ensureUniqueMemberNames = ensureUniqueMemberNames;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        programClass.kotlinMetadataAccept(this.kotlinReferenceFixer);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String descriptor = programField.getDescriptor(programClass);
        String newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, programField.referencedClass);
        this.visitProgramMember(programClass, programField, descriptor, newDescriptor);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String descriptor = programMethod.getDescriptor(programClass);
        String newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, programMethod.referencedClasses);
        this.visitProgramMember(programClass, programMethod, descriptor, newDescriptor);
    }

    private void visitProgramMember(ProgramClass programClass, ProgramMember programMember, String descriptor, String newDescriptor) {
        if (!descriptor.equals(newDescriptor)) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programMember.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            if (this.ensureUniqueMemberNames) {
                String name = programMember.getName(programClass);
                String newName = this.newUniqueMemberName(name, descriptor);
                programMember.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            }
        }
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String newDescriptor;
        String descriptor = libraryField.getDescriptor(libraryClass);
        libraryField.descriptor = newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, libraryField.referencedClass);
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String newDescriptor;
        String descriptor = libraryMethod.getDescriptor(libraryClass);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, libraryMethod.referencedClasses))) {
            libraryMethod.descriptor = newDescriptor;
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String externalClassName;
        String internalClassName;
        String newInternalClassName;
        Clazz referencedClass = stringConstant.referencedClass;
        Member referencedMember = stringConstant.referencedMember;
        if (referencedClass != null && referencedMember == null && !(newInternalClassName = ClassReferenceFixer.newClassName(internalClassName = ClassUtil.internalClassName(externalClassName = stringConstant.getString(clazz)), referencedClass)).equals(internalClassName)) {
            String newExternalClassName = externalClassName.indexOf(46) >= 0 ? ClassUtil.externalClassName(newInternalClassName) : newInternalClassName;
            stringConstant.u2stringIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newExternalClassName);
        }
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        String newDescriptor;
        String descriptor = dynamicConstant.getType(clazz);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, dynamicConstant.referencedClasses))) {
            String name = dynamicConstant.getName(clazz);
            dynamicConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(name, newDescriptor);
        }
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String newDescriptor;
        String descriptor = invokeDynamicConstant.getType(clazz);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, invokeDynamicConstant.referencedClasses))) {
            String name = invokeDynamicConstant.getName(clazz);
            invokeDynamicConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(name, newDescriptor);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String newClassName;
        String className;
        Clazz referencedClass = classConstant.referencedClass;
        if (referencedClass != null && !(className = classConstant.getName(clazz)).equals(newClassName = ClassReferenceFixer.newClassName(className, referencedClass))) {
            classConstant.u2nameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newClassName);
        }
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        String newDescriptor;
        String descriptor = methodTypeConstant.getType(clazz);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, methodTypeConstant.referencedClasses))) {
            methodTypeConstant.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newDescriptor);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitRecordAttribute(Clazz clazz, RecordAttribute recordAttribute) {
        recordAttribute.componentsAccept(clazz, this);
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        String newSignature;
        String signature = signatureAttribute.getSignature(clazz);
        if (!signature.equals(newSignature = ClassReferenceFixer.newDescriptor(signature, signatureAttribute.referencedClasses))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
        }
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitRecordComponentInfo(Clazz clazz, RecordComponentInfo recordComponentInfo) {
        recordComponentInfo.attributesAccept(clazz, this);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        String newInnerName;
        int index;
        int innerClassIndex = innerClassesInfo.u2innerClassIndex;
        int innerNameIndex = innerClassesInfo.u2innerNameIndex;
        if (innerClassIndex != 0 && innerNameIndex != 0 && (index = (newInnerName = clazz.getClassName(innerClassIndex)).lastIndexOf(36)) >= 0) {
            innerClassesInfo.u2innerNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newInnerName.substring(index + 1));
        }
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        String newDescriptor;
        String descriptor = localVariableInfo.getDescriptor(clazz);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, localVariableInfo.referencedClass))) {
            localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newDescriptor);
        }
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        String newSignature;
        String signature = localVariableTypeInfo.getSignature(clazz);
        if (!signature.equals(newSignature = ClassReferenceFixer.newDescriptor(signature, localVariableTypeInfo.referencedClasses))) {
            localVariableTypeInfo.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        String newTypeName;
        String typeName = annotation.getType(clazz);
        if (!typeName.equals(newTypeName = ClassReferenceFixer.newDescriptor(typeName, annotation.referencedClasses))) {
            annotation.u2typeIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newTypeName);
        }
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        String newTypeName;
        String typeName = enumConstantElementValue.getTypeName(clazz);
        if (!typeName.equals(newTypeName = ClassReferenceFixer.newDescriptor(typeName, enumConstantElementValue.referencedClasses))) {
            enumConstantElementValue.u2typeNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newTypeName);
        }
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        String newClassName;
        String className = classElementValue.getClassName(clazz);
        if (!className.equals(newClassName = ClassReferenceFixer.newDescriptor(className, classElementValue.referencedClasses))) {
            classElementValue.u2classInfoIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newClassName);
        }
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    public static String shortKotlinNestedClassName(String enclosingClassName, String shortInnerClassName, Clazz referencedClass) {
        String newFulllName = ClassReferenceFixer.newClassName(enclosingClassName + "$" + shortInnerClassName, referencedClass);
        if (newFulllName.equals(enclosingClassName + "$" + shortInnerClassName)) {
            return shortInnerClassName;
        }
        return ClassUtil.internalSimpleClassName(newFulllName);
    }

    private static String newDescriptor(String descriptor, Clazz referencedClass) {
        if (referencedClass == null) {
            return descriptor;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(descriptor);
        StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.length());
        newDescriptorBuffer.append(descriptorClassEnumeration.nextFluff());
        if (descriptorClassEnumeration.hasMoreClassNames()) {
            String className = descriptorClassEnumeration.nextClassName();
            String fluff = descriptorClassEnumeration.nextFluff();
            String newClassName = ClassReferenceFixer.newClassName(className, referencedClass);
            newDescriptorBuffer.append(newClassName);
            newDescriptorBuffer.append(fluff);
        }
        return newDescriptorBuffer.toString();
    }

    public static String newDescriptor(String descriptor, Clazz[] referencedClasses) {
        if (referencedClasses == null || referencedClasses.length == 0) {
            return descriptor;
        }
        try {
            DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(descriptor);
            StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.length());
            newDescriptorBuffer.append(descriptorClassEnumeration.nextFluff());
            int index = 0;
            while (descriptorClassEnumeration.hasMoreClassNames()) {
                String className = descriptorClassEnumeration.nextClassName();
                boolean isInnerClassName = descriptorClassEnumeration.isInnerClassName();
                String fluff = descriptorClassEnumeration.nextFluff();
                String newClassName = ClassReferenceFixer.newClassName(className, referencedClasses[index++]);
                if (isInnerClassName) {
                    newClassName = newClassName.substring(newClassName.lastIndexOf(36) + 1);
                }
                newDescriptorBuffer.append(newClassName);
                newDescriptorBuffer.append(fluff);
            }
            return newDescriptorBuffer.toString();
        }
        catch (RuntimeException e) {
            logger.error("Unexpected error while updating descriptor:");
            logger.error("  Descriptor = [{}]", (Object)descriptor);
            logger.error("  Referenced classes: {}", (Object)referencedClasses.length);
            for (int index = 0; index < referencedClasses.length; ++index) {
                Clazz referencedClass = referencedClasses[index];
                if (referencedClass == null) continue;
                logger.error("    #{}: [{}]", (Object)index, (Object)referencedClass.getName());
            }
            throw e;
        }
    }

    private String newUniqueMemberName(String name, String descriptor) {
        return name.equals("<init>") ? "<init>" : name + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
    }

    private static String newClassName(String className, Clazz referencedClass) {
        if (referencedClass == null) {
            return className;
        }
        String newClassName = referencedClass.getName();
        if (className.charAt(0) == '[') {
            newClassName = className.substring(0, className.indexOf(76) + 1) + newClassName + ';';
        }
        return newClassName;
    }

    private static String newInnerClassName(String enclosingClassName, String shortInnerClassName, Clazz referencedClass) {
        String newFulllName = ClassReferenceFixer.newClassName(enclosingClassName + "$" + shortInnerClassName, referencedClass);
        return newFulllName.substring(newFulllName.indexOf(36) + 1);
    }

    private static MethodSignature fixPropertyMethod(Clazz referencedMethodClass, Method referencedMethod, KotlinPropertyAccessorFlags flags, MethodSignature oldSignature) {
        if (oldSignature == null) {
            return null;
        }
        MethodSignature newSignature = new MethodSignature(referencedMethodClass, referencedMethod);
        if (!oldSignature.equals(newSignature) && flags != null) {
            ClassReferenceFixer.addJvmNameAnnotation((ProgramClass)referencedMethodClass, (ProgramMethod)referencedMethod);
            flags.common.hasAnnotations = true;
        }
        return newSignature;
    }

    private static void addJvmNameAnnotation(ProgramClass programClass, ProgramMethod programMethod) {
        ConstantPoolEditor editor = new ConstantPoolEditor(programClass);
        Annotation jvmName = new Annotation(editor.addUtf8Constant("Lkotlin/jvm/JvmName;"), 1, new ElementValue[]{new ConstantElementValue('s', editor.addUtf8Constant("name"), editor.addUtf8Constant(programMethod.getName(programClass)))});
        AttributesEditor attributesEditor = new AttributesEditor(programClass, programMethod, false);
        Attribute annotationsAttribute = attributesEditor.findAttribute("RuntimeInvisibleAnnotations");
        if (annotationsAttribute == null) {
            attributesEditor.addAttribute(new RuntimeInvisibleAnnotationsAttribute(editor.addUtf8Constant("RuntimeInvisibleAnnotations"), 1, new Annotation[]{jvmName}));
        } else {
            final AnnotationsAttributeEditor annotationsAttributeEditor = new AnnotationsAttributeEditor((AnnotationsAttribute)annotationsAttribute);
            programMethod.attributesAccept(programClass, new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/jvm/JvmName;", new AnnotationVisitor(){

                @Override
                public void visitAnnotation(Clazz clazz, Annotation annotation) {
                    annotationsAttributeEditor.deleteAnnotation(annotation);
                }
            })));
            annotationsAttributeEditor.addAnnotation(jvmName);
        }
    }

    private static class KotlinReferenceFixer
    implements KotlinMetadataVisitor,
    KotlinPropertyVisitor,
    KotlinFunctionVisitor,
    KotlinConstructorVisitor,
    KotlinTypeVisitor,
    KotlinTypeAliasVisitor,
    KotlinValueParameterVisitor,
    KotlinTypeParameterVisitor,
    KotlinAnnotationVisitor,
    KotlinAnnotationArgumentVisitor {
        private KotlinReferenceFixer() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            kotlinDeclarationContainerMetadata.ownerClassName = ClassReferenceFixer.newClassName(kotlinDeclarationContainerMetadata.ownerClassName, kotlinDeclarationContainerMetadata.ownerReferencedClass);
            kotlinDeclarationContainerMetadata.propertiesAccept(clazz, this);
            kotlinDeclarationContainerMetadata.delegatedPropertiesAccept(clazz, this);
            kotlinDeclarationContainerMetadata.functionsAccept(clazz, this);
            kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, this);
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            int k;
            kotlinClassKindMetadata.className = ClassReferenceFixer.newClassName(kotlinClassKindMetadata.className, kotlinClassKindMetadata.referencedClass);
            if (kotlinClassKindMetadata.anonymousObjectOriginName != null) {
                kotlinClassKindMetadata.anonymousObjectOriginName = ClassReferenceFixer.newClassName(kotlinClassKindMetadata.anonymousObjectOriginName, kotlinClassKindMetadata.anonymousObjectOriginClass);
            }
            if (kotlinClassKindMetadata.companionObjectName != null) {
                kotlinClassKindMetadata.companionObjectName = kotlinClassKindMetadata.referencedCompanionField.getName(clazz);
            }
            for (k = 0; k < kotlinClassKindMetadata.enumEntryNames.size(); ++k) {
                kotlinClassKindMetadata.enumEntryNames.set(k, kotlinClassKindMetadata.referencedEnumEntries.get(k).getName(clazz));
            }
            for (k = 0; k < kotlinClassKindMetadata.nestedClassNames.size(); ++k) {
                kotlinClassKindMetadata.nestedClassNames.set(k, ClassReferenceFixer.shortKotlinNestedClassName(clazz.getName(), kotlinClassKindMetadata.nestedClassNames.get(k), kotlinClassKindMetadata.referencedNestedClasses.get(k)));
            }
            for (k = 0; k < kotlinClassKindMetadata.sealedSubclassNames.size(); ++k) {
                kotlinClassKindMetadata.sealedSubclassNames.set(k, ClassReferenceFixer.newClassName(kotlinClassKindMetadata.sealedSubclassNames.get(k), kotlinClassKindMetadata.referencedSealedSubClasses.get(k)));
            }
            kotlinClassKindMetadata.typeParametersAccept(clazz, this);
            kotlinClassKindMetadata.superTypesAccept(clazz, this);
            kotlinClassKindMetadata.constructorsAccept(clazz, this);
            this.visitKotlinDeclarationContainerMetadata(clazz, kotlinClassKindMetadata);
        }

        @Override
        public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
            this.visitKotlinDeclarationContainerMetadata(clazz, kotlinFileFacadeKindMetadata);
        }

        @Override
        public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
        }

        @Override
        public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
            for (int k = 0; k < kotlinMultiFileFacadeKindMetadata.partClassNames.size(); ++k) {
                kotlinMultiFileFacadeKindMetadata.partClassNames.set(k, ClassReferenceFixer.newClassName(kotlinMultiFileFacadeKindMetadata.partClassNames.get(k), kotlinMultiFileFacadeKindMetadata.referencedPartClasses.get(k)));
            }
        }

        @Override
        public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
            kotlinMultiFilePartKindMetadata.facadeName = ClassReferenceFixer.newClassName(kotlinMultiFilePartKindMetadata.facadeName, kotlinMultiFilePartKindMetadata.referencedFacadeClass);
            this.visitKotlinDeclarationContainerMetadata(clazz, kotlinMultiFilePartKindMetadata);
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            ProgramClass programClass = (ProgramClass)clazz;
            if (kotlinPropertyMetadata.backingFieldSignature != null) {
                Clazz backingFieldClass = kotlinPropertyMetadata.referencedBackingFieldClass;
                Field backingField = kotlinPropertyMetadata.referencedBackingField;
                kotlinPropertyMetadata.backingFieldSignature = new FieldSignature(backingFieldClass, backingField);
            }
            kotlinPropertyMetadata.getterSignature = ClassReferenceFixer.fixPropertyMethod(programClass, kotlinPropertyMetadata.referencedGetterMethod, kotlinPropertyMetadata.getterFlags, kotlinPropertyMetadata.getterSignature);
            kotlinPropertyMetadata.setterSignature = ClassReferenceFixer.fixPropertyMethod(programClass, kotlinPropertyMetadata.referencedSetterMethod, kotlinPropertyMetadata.setterFlags, kotlinPropertyMetadata.setterSignature);
            kotlinPropertyMetadata.syntheticMethodForAnnotations = ClassReferenceFixer.fixPropertyMethod(kotlinPropertyMetadata.referencedSyntheticMethodClass, kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations, null, kotlinPropertyMetadata.syntheticMethodForAnnotations);
            kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                kotlinFunctionMetadata.lambdaClassOriginName = null;
                kotlinFunctionMetadata.referencedLambdaClassOrigin = null;
            }
            if (kotlinFunctionMetadata.jvmSignature != null) {
                Clazz jvmClass = kotlinFunctionMetadata.referencedMethodClass;
                Method jvmMethod = kotlinFunctionMetadata.referencedMethod;
                kotlinFunctionMetadata.jvmSignature = new MethodSignature(jvmClass, jvmMethod);
            }
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinMetadata, new AllTypeVisitor(this));
            kotlinFunctionMetadata.name = kotlinFunctionMetadata.referencedMethod.getName(kotlinFunctionMetadata.referencedMethodClass);
        }

        @Override
        public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
            if (kotlinConstructorMetadata.jvmSignature != null) {
                Method jvmMethod = kotlinConstructorMetadata.referencedMethod;
                kotlinConstructorMetadata.jvmSignature = new MethodSignature(clazz, jvmMethod);
            }
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, this);
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            if (kotlinTypeMetadata.className != null) {
                kotlinTypeMetadata.className = kotlinTypeMetadata.referencedClass.getName();
            }
            kotlinTypeMetadata.annotationsAccept(clazz, this);
            kotlinTypeMetadata.typeArgumentsAccept(clazz, this);
            kotlinTypeMetadata.outerClassAccept(clazz, this);
            kotlinTypeMetadata.upperBoundsAccept(clazz, this);
            kotlinTypeMetadata.abbreviationAccept(clazz, this);
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            kotlinTypeAliasMetadata.annotationsAccept(clazz, this);
            kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        }

        @Override
        public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        }

        @Override
        public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        }

        @Override
        public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)this);
        }

        @Override
        public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)this);
        }

        @Override
        public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            kotlinTypeParameterMetadata.annotationsAccept(clazz, this);
            kotlinTypeParameterMetadata.upperBoundsAccept(clazz, this);
        }

        @Override
        public void visitAnyAnnotation(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation) {
            annotation.className = annotation.referencedAnnotationClass.getName();
            annotation.argumentsAccept(clazz, annotatable, this);
        }

        @Override
        public void visitAnyArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.Value value) {
            argument.name = argument.referencedAnnotationMethod.getName(annotation.referencedAnnotationClass);
        }

        @Override
        public void visitClassArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.ClassValue value) {
            this.visitAnyArgument(clazz, annotatable, annotation, argument, value);
            value.className = value.referencedClass.getName();
        }

        @Override
        public void visitEnumArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.EnumValue value) {
            this.visitAnyArgument(clazz, annotatable, annotation, argument, value);
            value.className = value.referencedClass.getName();
        }
    }
}

