/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.util.ArrayUtil;

public class MultiClassPoolVisitor
implements ClassPoolVisitor {
    private ClassPoolVisitor[] classPoolVisitors;
    private int classPoolVisitorCount;

    public MultiClassPoolVisitor() {
        this.classPoolVisitors = new ClassPoolVisitor[16];
    }

    public MultiClassPoolVisitor(ClassPoolVisitor ... classPoolVisitors) {
        this.classPoolVisitors = classPoolVisitors;
        this.classPoolVisitorCount = classPoolVisitors.length;
    }

    public void addClassPoolVisitor(ClassPoolVisitor classPoolVisitor) {
        this.classPoolVisitors = ArrayUtil.add(this.classPoolVisitors, this.classPoolVisitorCount++, classPoolVisitor);
    }

    @Override
    public void visitClassPool(ClassPool classPool) {
        for (int index = 0; index < this.classPoolVisitorCount; ++index) {
            this.classPoolVisitors[index].visitClassPool(classPool);
        }
    }
}

